/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.catalog.type.utils.HumanTaskHelper;
import oracle.bpm.project.events.ProjectEventManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.soa.humantask.HumanTaskException;
import oracle.bpm.soa.humantask.Participant;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.Payload;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.TaskDisplayInfo;
import oracle.bpm.soa.humantask.TaskForm;
import oracle.bpm.soa.humantask.Title;
import oracle.bpm.soa.humantask.WorkflowConfiguration;
import oracle.bpm.soa.io.IOFactory;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.ArrayUtils;

public class HumanTaskImpl
extends CatalogObjectImpl
implements HumanTask {
    private RoutingSlip routingSlip;
    private oracle.bpm.soa.humantask.HumanTask task;
    private Title title;
    private WorkflowConfiguration workflowConfiguration;

    public HumanTaskImpl(Project project, TypeRef model) {
        super(project, model);
        this.setDefault(false);
    }

    @Override
    public Sequence<Argument> getArguments() {
        MethodTypeDescription member = this.getObjectType().getMember("invoke", 14);
        return member != null ? CollectionUtils.asSequence(ArrayUtils.asList(member.getArguments())) : CollectionUtils.asSequence(new ArrayList());
    }

    @Override
    public boolean isHumanTask() {
        return true;
    }

    @Override
    public Class getRawClass() {
        return HumanTask.class;
    }

    @Override
    public String getHumanTaskNativeName() {
        return this.getDelegate().asObject().getNativeName();
    }

    @Override
    public String getHumanTaskId() {
        ObjectTypeDescription otd = this.getDelegate().asObject();
        return otd.getProperty("human.task.id");
    }

    @Override
    public HumanTaskType getHumanTaskType() {
        ObjectTypeDescription otd = this.getDelegate().asObject();
        String name = otd.getProperty("human.task.pattern");
        HumanTaskType type = HumanTaskType.COMPLEX;
        if (name != null) {
            try {
                type = HumanTaskType.valueOf(name);
            }
            catch (IllegalArgumentException ignore) {}
        } else {
            type = HumanTaskType.SIMPLE;
        }
        return type;
    }

    @Override
    public int getPriority() {
        return this.getTask().getPriority();
    }

    @Override
    public void setPriority(int priority) {
        this.getTask().setPriority(priority);
        this.events().objectChanged();
    }

    @Override
    public String getTargetNamespace() {
        return this.getTask().getTargetNamespace();
    }

    @Override
    public void setTargetNamespace(String value) {
        this.getTask().setTargetNamespace(value);
        this.events().objectChanged();
    }

    @Override
    public Title getTitle() {
        if (this.title == null) {
            this.title = new TitleAdapter(this.events(), this.getTask().getTitle());
        }
        return this.title;
    }

    @Override
    public WorkflowConfiguration getWorkflowConfiguration() {
        if (this.workflowConfiguration == null) {
            this.workflowConfiguration = new WorkflowConfigurationAdapter(this.events(), this.getTask().getWorkflowConfiguration());
        }
        return this.workflowConfiguration;
    }

    @Override
    public RoutingSlip getRoutingSlip() {
        if (this.routingSlip == null) {
            this.routingSlip = new RoutingSlipAdapter(this.events(), this.getTask().getRoutingSlip());
        }
        return this.routingSlip;
    }

    public oracle.bpm.soa.humantask.HumanTask getTask() {
        if (this.task == null) {
            VFile vFile = this.as(VFile.class);
            try {
                this.task = IOFactory.createTaskVFileIO().loadTask((Object)vFile);
            }
            catch (HumanTaskException e) {
                throw new RuntimeException(e);
            }
        }
        return this.task;
    }

    private class WorkflowConfigurationAdapter
    extends AbstractAdapter<WorkflowConfiguration>
    implements WorkflowConfiguration {
        private Payload payload;

        private WorkflowConfigurationAdapter(ProjectEventManager events, WorkflowConfiguration wc) {
            super(events, wc);
        }

        public WorkflowConfigurationAdapter create(ProjectEventManager events, WorkflowConfiguration wc) {
            return new WorkflowConfigurationAdapter(events, wc);
        }

        public WorkflowConfiguration.Outcomes getOutcomes() {
            return ((WorkflowConfiguration)this.getDelegate()).getOutcomes();
        }

        public boolean isGlobalCreation() {
            return ((WorkflowConfiguration)this.getDelegate()).isGlobalCreation();
        }

        public void setGlobalCreation(boolean value) {
            boolean oldValue = this.isGlobalCreation();
            if (value != oldValue) {
                ((WorkflowConfiguration)this.getDelegate()).setGlobalCreation(value);
                this.changed("humanTask.workflowconfiguration.globalcreation", oldValue, value);
            }
        }

        public boolean isEnableAutoClaim() {
            return ((WorkflowConfiguration)this.getDelegate()).isEnableAutoClaim();
        }

        public void setEnableAutoClaim(boolean value) {
            boolean oldValue = this.isEnableAutoClaim();
            if (value != oldValue) {
                ((WorkflowConfiguration)this.getDelegate()).setEnableAutoClaim(value);
                this.changed("humanTask.workflowconfiguration.enableautoclaim", oldValue, value);
            }
        }

        public boolean isShowCompleteGraphicalHistory() {
            return ((WorkflowConfiguration)this.getDelegate()).isShowCompleteGraphicalHistory();
        }

        public void setShowCompleteGraphicalHistory(boolean value) {
            boolean oldValue = this.isShowCompleteGraphicalHistory();
            if (value != oldValue) {
                ((WorkflowConfiguration)this.getDelegate()).setShowCompleteGraphicalHistory(value);
                this.changed("humanTask.workflowconfiguration.showcompletegraphicalhistory", oldValue, value);
            }
        }

        public List<TaskDisplayInfo> getTaskDisplayInfos() {
            return ((WorkflowConfiguration)this.getDelegate()).getTaskDisplayInfos();
        }

        public void setTaskDisplayInfos(List<TaskDisplayInfo> infos) {
            ((WorkflowConfiguration)this.getDelegate()).setTaskDisplayInfos(infos);
            this.changed("humanTask.workflowconfiguration.taskdisplayinfos", null, infos);
        }

        public void addTaskDisplayInfo(TaskDisplayInfo info) {
            ((WorkflowConfiguration)this.getDelegate()).addTaskDisplayInfo(info);
            this.changed("humanTask.workflowconfiguration.addtaskdisplayinfo", null, info);
        }

        public Payload getPayload() {
            if (this.payload == null) {
                this.payload = new PayloadAdapter(this.events(), ((WorkflowConfiguration)this.getDelegate()).getPayload());
            }
            return this.payload;
        }

        public void setTaskForm(TaskForm newValue) {
            TaskForm oldValue = ((WorkflowConfiguration)this.getDelegate()).getTaskForm();
            ((WorkflowConfiguration)this.getDelegate()).setTaskForm(newValue);
            this.changed("humanTask.workflowconfiguration.taskform", oldValue, newValue);
        }

        public TaskForm getTaskForm() {
            return ((WorkflowConfiguration)this.getDelegate()).getTaskForm();
        }
    }

    private class PayloadAdapter
    extends AbstractAdapter<Payload>
    implements Payload {
        PayloadAdapter(ProjectEventManager events, Payload payload) {
            super(events, payload);
        }

        public PayloadAdapter create(ProjectEventManager events, Payload payload) {
            return new PayloadAdapter(events, payload);
        }

        public String getXmlSchemaDefinition() {
            return ((Payload)this.getDelegate()).getXmlSchemaDefinition();
        }

        public void setXmlSchemaDefinition(String value) {
            String oldValue = this.getXmlSchemaDefinition();
            if (!value.equals(oldValue)) {
                ((Payload)this.getDelegate()).setXmlSchemaDefinition(value);
                this.changed("humanTask.workflowconfiguration.payload.xmlschemadefinition", oldValue, value);
            }
        }

        public List<Payload.Attribute> getAttributes() {
            return ((Payload)this.getDelegate()).getAttributes();
        }

        public void addAttribute(Payload.Attribute attribute) {
            ((Payload)this.getDelegate()).addAttribute(attribute);
            HumanTaskHelper.updateInvokeMethod((ObjectTypeDescription)HumanTaskImpl.this.getObjectType(), (List)((Payload)this.getDelegate()).getAttributes());
            this.changed("humanTask.workflowconfiguration.payload.addattribute", null, attribute.getName());
        }

        public void removeAttribute(Payload.Attribute attribute) {
            ((Payload)this.getDelegate()).removeAttribute(attribute);
            HumanTaskHelper.updateInvokeMethod((ObjectTypeDescription)HumanTaskImpl.this.getObjectType(), (List)((Payload)this.getDelegate()).getAttributes());
            this.changed("humanTask.workflowconfiguration.payload.removeattribute", null, attribute.getName());
        }

        public void updateFromXsd(InputStream inputStream, String schemaLocation) {
            ((Payload)this.getDelegate()).updateFromXsd(inputStream, schemaLocation);
        }

        public void updateFromPayloadXsd(InputStream inputStream, String schemaLocation) {
            ((Payload)this.getDelegate()).updateFromPayloadXsd(inputStream, schemaLocation);
        }

        public boolean isExternalSchema() {
            return ((Payload)this.getDelegate()).isExternalSchema();
        }

        public void setExternalSchema(boolean newValue) {
            boolean oldValue = ((Payload)this.getDelegate()).isExternalSchema();
            if (newValue != oldValue) {
                ((Payload)this.getDelegate()).setExternalSchema(newValue);
                this.changed("humanTask.workflowconfiguration.payload.externalSchema", oldValue, newValue);
            }
        }
    }

    private static class TitleAdapter
    extends AbstractAdapter<Title>
    implements Title {
        private TitleAdapter(ProjectEventManager events, Title title) {
            super(events, title);
        }

        public static TitleAdapter create(ProjectEventManager events, Title title) {
            return new TitleAdapter(events, title);
        }

        public Title.Type getType() {
            return ((Title)this.getDelegate()).getType();
        }

        public void setType(Title.Type type) {
            Title.Type oldType = this.getType();
            ((Title)this.getDelegate()).setType(type);
            this.changed("humanTask.title.type", oldType, type);
        }

        public String getValue() {
            return ((Title)this.getDelegate()).getValue();
        }

        public void setValue(String value) {
            String oldValue = this.getValue();
            ((Title)this.getDelegate()).setValue(value);
            this.changed("humanTask.title.value", oldValue, value);
        }
    }

    private static class RoutingSlipAdapter
    extends AbstractAdapter<RoutingSlip>
    implements RoutingSlip {
        private RoutingSlipAdapter(ProjectEventManager events, RoutingSlip rs) {
            super(events, rs);
        }

        public Participants getParticipants() {
            return ((RoutingSlip)this.getDelegate()).getParticipants();
        }

        public void setParticipants(Participants participants) {
            ((RoutingSlip)this.getDelegate()).setParticipants(participants);
            this.changed("humanTask.routingslip.participants", null, null);
        }

        public Participant getParent() {
            return ((RoutingSlip)this.getDelegate()).getParent();
        }

        public RoutingSlip.Notification getNotification() {
            return ((RoutingSlip)this.getDelegate()).getNotification();
        }

        public RoutingSlip.GlobalConfiguration getGlobalConfiguration() {
            return ((RoutingSlip)this.getDelegate()).getGlobalConfiguration();
        }

        public void addExcludedParticipant(RoutingSlip.ExcludedParticipantsType value) {
            ((RoutingSlip)this.getDelegate()).addExcludedParticipant(value);
        }

        public List<RoutingSlip.ExcludedParticipantsType> getExcludedParticipants() {
            return ((RoutingSlip)this.getDelegate()).getExcludedParticipants();
        }

        public void setExcludedParticipants(List<RoutingSlip.ExcludedParticipantsType> list) {
            ((RoutingSlip)this.getDelegate()).setExcludedParticipants(list);
        }
    }

    private static abstract class AbstractAdapter<E> {
        private E delegate;
        private ProjectEventManager events;

        protected AbstractAdapter(ProjectEventManager events, E object) {
            this.events = events;
            this.delegate = object;
        }

        protected E getDelegate() {
            return this.delegate;
        }

        protected void changed(String propertyName, Object oldValue, Object newValue) {
            this.events.objectChanged(propertyName, oldValue, newValue);
        }

        protected ProjectEventManager events() {
            return this.events;
        }
    }
}

