/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.cil.CilCompiler;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.log.Log;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.CorrelationModelImpl;
import oracle.bpm.project.CorrelationPropertyAliasKey;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.FuegoProcessList;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.ProjectResourceObjectFactory;
import oracle.bpm.project.ProjectVariableImpl;
import oracle.bpm.project.ResourceContainerImpl;
import oracle.bpm.project.ResourceFilesContainerImpl;
import oracle.bpm.project.ResourceManagerImpl;
import oracle.bpm.project.UndeletableFolderContainerImpl;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.compiler.ProjectCompiler;
import oracle.bpm.project.events.EventSource;
import oracle.bpm.project.model.CompiledProject;
import oracle.bpm.project.model.CorrelationModel;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectGenerateEvents;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceFilesContainer;
import oracle.bpm.project.model.ResourceManager;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.casemgmt.CaseContainer;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogAdapter;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.OrganizationImpl;
import oracle.bpm.project.preferences.ProjectPreferencesImpl;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.CatalogListener;
import oracle.bpm.util.LazyHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuegoProject
extends ResourceContainerImpl
implements CompiledProject {
    @Nullable
    private CaseContainer caseContainer;
    private Map<String, CatalogObject> catalogObjects = new HashMap<String, CatalogObject>();
    private CorrelationModelImpl correlationModel;
    private ObjectPropertyListener dependencyPropertyListener;
    private FolderContainer modelsRoot;
    private boolean open;
    @Nullable
    private Organization organization;
    private LazyHolder<ProjectPreferences> preferencesHolder = this.buildPreferencesHolder();
    private LazyHolder<ComponentCatalog> projectCatalogHolder = this.buildCatalogHolder();
    private ProjectLoader projectLoader;
    private Process projectModel;
    private String projectName;
    private ProjectWriter projectWriter;
    private ProjectRepository repository;
    private ResourceFilesContainer resourceFilesContainer;
    private ResourceManager resourceManager;
    @Nullable
    private SimulationsContainer simulationsContainer;

    protected FuegoProject(String projectName) {
        super(null);
        this.projectName = projectName;
        this.correlationModel = new CorrelationModelImpl(this);
        this.addListeners();
        this.events().enable();
    }

    public static FuegoProject getFrom(TypeRef ref) {
        FuegoProject result = null;
        if (ref instanceof ProjectObject) {
            result = (FuegoProject)FuegoProject.getFrom((ProjectObject)ref);
        } else if (ref != null) {
            int kind = ref.getKind();
            if (kind == 11 || kind == 17) {
                MutableComponentCatalog catalog = (MutableComponentCatalog)ref.getCatalog();
                if (catalog != null) {
                    result = (FuegoProject)catalog.getOwner();
                }
            } else {
                result = FuegoProject.getFrom((TypeRef)ref.get().getParent());
            }
        }
        return result;
    }

    public static FuegoProject create(String projectName) {
        return new FuegoProject(projectName);
    }

    public static FuegoProject createInMemory(String projectName) {
        FuegoProject project = new FuegoProject(projectName);
        try {
            Process projectModel = ProjectResourceObjectFactory.createProjectProcess(project, "default", true);
            project.setProjectModel(projectModel);
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
        return project;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getProjectModel().getFeature(AnnotationsFeature.class).getAnnotations(visible);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getProjectModel().getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getProjectModel().getFeature(AnnotationsFeature.class).addAnnotation(key, value, visible);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getProjectModel().getFeature(AnnotationsFeature.class).removeAnnotation(key, visible);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROJECT;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this;
    }

    @Override
    public Path getPath() {
        return Path.ROOT;
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
        switch (newObject.getProjectObjectType()) {
            case MODEL_CONTAINER: {
                break;
            }
            case PROJECT: {
                break;
            }
            case PROJECT_SIMULATION: {
                this.getSimulations().replaceProjectSimulation((ProjectSimulation)newObject);
                break;
            }
            case UDDI_PROCESS_PUBLICATION: {
                break;
            }
            case ACTIVITY: {
                break;
            }
            case ALL: {
                break;
            }
            case ATTRIBUTE: {
                break;
            }
            case ATTRIBUTE_GROUP: {
                break;
            }
            case COMPONENT: {
                break;
            }
            case CONFIGURATION: {
                break;
            }
            case CONFIGURATION_MANAGER: {
                break;
            }
            case CONNECTOR: {
                break;
            }
            case CORRELATION: {
                break;
            }
            case ENGINE: {
                break;
            }
            case EXTERNAL_RESOURCE: {
                break;
            }
            case BPM_OBJECT: {
                break;
            }
            case INSTANCE_VARIABLE: {
                break;
            }
            case LANE: {
                break;
            }
            case MAPPING: {
                break;
            }
            case MEASUREMENT: {
                break;
            }
            case METHOD: {
                break;
            }
            case MODEL: {
                Process model = (Process)newObject;
                if (ModelUtils.isDefaultProcess(model)) {
                    this.replaceProjectModel(this.getProjectModel(), model);
                    break;
                }
                model.getParentObject().replace(newObject);
                break;
            }
            case MODEL_SIMULATION: {
                this.getSimulations().replaceModelSimulation((ModelSimulation)newObject);
                break;
            }
            case NOTE: {
                break;
            }
            case ORGANIZATION: {
                Organization oldObject = this.getOrganization();
                this.organization = (Organization)newObject;
                this.events().objectReplaced(oldObject, newObject);
                break;
            }
            case OU: {
                ((OrganizationImpl)this.getOrganization()).replaceOrganizationalUnit((OrganizationalUnit)newObject);
                break;
            }
            case ORGANIZATIONAL_CHART: {
                ((OrganizationImpl)this.getOrganization()).replaceOrganizationalChart((OrganizationalChart)newObject);
                break;
            }
            case ORGANIZATION_ROLE: {
                ((OrganizationImpl)this.getOrganization()).replaceRole((Role)newObject);
                break;
            }
            case ORGANIZATION_GROUP: {
                ((OrganizationImpl)this.getOrganization()).replaceGroup((Group)newObject);
                break;
            }
            case PARTICIPANT: {
                ((OrganizationImpl)this.getOrganization()).replaceParticipant((Participant)newObject);
                break;
            }
            case CALENDAR_RULE: {
                ((OrganizationImpl)this.getOrganization()).replaceCalendarRule((CalendarRule)newObject);
                break;
            }
            case HOLIDAY_RULE: {
                ((OrganizationImpl)this.getOrganization()).replaceHolidayRule((HolidayRule)newObject);
                break;
            }
            case BUSINESS_PARAMETER: {
                break;
            }
            case BUSINESS_VARIABLE: {
                break;
            }
            case EXTERNAL_VARIABLE: {
                break;
            }
            case PROCESS_DEPLOYMENT: {
                break;
            }
            case PROCESS_WEB_SERVICE: {
                break;
            }
            case SCHEDULE: {
                break;
            }
            case SIMULATION_ACTIVITY: {
                break;
            }
            case SIMULATION_RESOURCE: {
                break;
            }
            case SIMULATION_TRANSITION: {
                break;
            }
            case TASK: {
                break;
            }
            case TOPOLOGY: {
                break;
            }
            case TRANSFORMATION: {
                break;
            }
            case TRANSFORMATION_MAPPING: {
                break;
            }
            case TRANSFORMATION_METHOD: {
                break;
            }
        }
    }

    @Override
    public void setLoader(ProjectLoader projectLoader) {
        this.projectLoader = projectLoader;
    }

    @Override
    @Nullable
    public ProjectLoader getLoader() {
        return this.projectLoader;
    }

    @Override
    public ProjectWriter getWriter() {
        return this.projectWriter;
    }

    @Override
    public void setWriter(ProjectWriter projectWriter) {
        this.projectWriter = projectWriter;
    }

    public void dependencyChange() {
        ComponentCatalog catalog = this.projectCatalogHolder.getIfSet();
        if (catalog == null) {
            return;
        }
        MutableComponentCatalog defaultCatalog = this.getDefaultCatalog();
        ((MutableComponentCatalog)catalog).redefineParent(defaultCatalog);
    }

    public MutableComponentCatalog getDefaultCatalog() {
        return TypeUtils.getDefaultCatalog();
    }

    public FuegoProcessList getAllProcesses() {
        return FuegoProject.getRecursiveProcesses(this.getModelsRoot());
    }

    @Override
    public Locale getDefaultLanguage() {
        return this.getPreferences().getDefaultLanguage();
    }

    @Override
    public Collection<Locale> getAvailableLanguages() {
        return Collections.unmodifiableCollection(this.getPreferences().getAvailableLanguages());
    }

    @Override
    public boolean isDefault() {
        return this.getLoader() != null && this == this.getLoader().getProjectRepository().getDefaultProject();
    }

    public void setName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String getName() {
        return this.projectName;
    }

    @Override
    public FolderContainer getModelsRoot() {
        if (this.modelsRoot == null) {
            FolderContainer folderContainer = this.getObject(this, FolderContainer.class, Path.PROCESSES.getName());
            if (folderContainer == null) {
                folderContainer = new UndeletableFolderContainerImpl(this, this, Path.PROCESSES.getName());
                this.adaptToRootFile(folderContainer, Path.PROCESSES.getName());
            }
            this.setModelsRoot(folderContainer);
        }
        return this.modelsRoot;
    }

    @Override
    public Collection<Process> getProcesses() {
        return FuegoProject.getRecursiveProcesses(this.getModelsRoot());
    }

    public Collection<Process> getModels(SchemaType type) {
        FuegoProcessList processesOfType = this.getProcessesOfType();
        return new ArrayList<Process>(processesOfType);
    }

    public Process createProcess(String id) {
        try {
            return this.getModelsRoot().createModel(id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Process createCallableSubProcess(String id) {
        try {
            return this.getModelsRoot().createCallableSubprocess(id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Process createCallableEmptySubProcess(String id) {
        try {
            return this.getModelsRoot().createEmptyCallableSubprocess(id);
        }
        catch (ProjectException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void addProcess(Process model) throws ProjectException {
        this.getModelsRoot().addChild(model);
    }

    @Override
    public Sequence<ProjectDataObject> getProjectDataObjects() {
        return this.getLocalDeclarations(ProjectDataObject.class);
    }

    @Override
    public ProjectDataObject findDataObject(String variableId) {
        return this.findLocalDeclaration(ProjectDataObject.class, variableId);
    }

    @Override
    public Process getProjectModel() {
        if (this.projectModel == null) {
            Process model = this.findChild(Process.class, "default");
            if (model == null) {
                try {
                    model = ProjectResourceObjectFactory.createProjectProcess(this.getProject(), "default", true);
                }
                catch (ProjectException e) {
                    throw new RuntimeException(e);
                }
            }
            this.projectModel = model;
        }
        return this.projectModel;
    }

    @Override
    public ActivityGuide getActivityGuide() {
        return this.findChild(ActivityGuide.class, "activityGuide");
    }

    @Override
    public boolean isTemplate() {
        return this.getPreferences().isTemplate();
    }

    @Override
    public ProjectGenerateEvents getGenerateEvents() {
        return this.getPreferences().getKeyPerformanceIndicatorsContainer().getGenerateEvents();
    }

    @Override
    public Sequence<ProjectDataObject> getBusinessIndicators() {
        return this.getProjectDataObjects().select(new Predicate<ProjectDataObject>(){

            @Override
            public boolean check(@Nullable ProjectDataObject value) {
                return value != null && value.isBusiness();
            }
        });
    }

    @Override
    public Sequence<ProjectDataObject> getBusinessIndicatorsByType(final BusinessVariableType type) {
        return this.getProjectDataObjects().select(new Predicate<ProjectDataObject>(){

            @Override
            public boolean check(@Nullable ProjectDataObject value) {
                return value != null && value.isBusiness() && value.getBusinessVariableType() == type;
            }
        });
    }

    @Override
    public String getProjectNamespace() {
        return this.correlationModel.getLowLevelModel().getTargetNamespace();
    }

    public CorrelationModel getCorrelationModel() {
        return this.correlationModel;
    }

    @Override
    @NotNull
    public Sequence<CorrelationProperty> getProperties() {
        return this.getCorrelationModel().getProperties();
    }

    @Override
    @Nullable
    public CorrelationProperty findProperty(@NotNull QName propertyName) {
        return this.getCorrelationModel().findProperty(propertyName);
    }

    @Override
    @Nullable
    public CorrelationProperty findProperty(@NotNull String propertyName) {
        return this.getCorrelationModel().findProperty(propertyName);
    }

    @Override
    @NotNull
    public Sequence<CorrelationPropertyAlias> getPropertyAliases() {
        return this.getCorrelationModel().getPropertyAliases();
    }

    @Override
    public void setProperty(@NotNull CorrelationProperty prop) throws ProjectException {
        this.getCorrelationModel().setProperty(prop);
    }

    @Override
    public void setPropertyAlias(@NotNull CorrelationPropertyAlias propertyAlias) throws ProjectException {
        this.getCorrelationModel().setPropertyAlias(propertyAlias);
    }

    public final void setPropertyAliasExpressionMode(@NotNull CorrelationPropertyAliasKey aliasKey, @NotNull ExpressionMode mode) {
        this.correlationModel.setPropertyAliasExpressionMode(aliasKey.getId(), aliasKey.getPropertyName(), mode);
    }

    @Override
    public void removeProperty(@NotNull String propertyName) throws ProjectException {
        CorrelationProperty property = this.findProperty(propertyName);
        if (property != null) {
            this.getCorrelationModel().removeProperty(propertyName);
        }
    }

    @Override
    public void removePropertyAlias(@NotNull CorrelationPropertyAlias correlationPropertyAlias) throws ProjectException {
        this.getCorrelationModel().removePropertyAlias(correlationPropertyAlias);
    }

    @Override
    @NotNull
    public CorrelationProperty createCorrelationProperty(@NotNull String propertyName, @NotNull CatalogType catalogType) {
        return this.getCorrelationModel().createCorrelationProperty(propertyName, catalogType);
    }

    @Override
    public CorrelationPropertyAlias findPropertyAlias(@NotNull CorrelationProperty correlationProperty, @Nullable String partName, boolean isInput, @NotNull CorrelationsEnabled correlationsEnabled) {
        return this.getCorrelationModel().findPropertyAlias(correlationProperty, partName, isInput, correlationsEnabled);
    }

    @Override
    @NotNull
    public CorrelationPropertyAlias createPropertyAlias(@NotNull CorrelationProperty correlationProperty, @Nullable String partName, boolean isInput, @NotNull CorrelationsEnabled correlationsEnabled, @NotNull Expression expression) {
        return this.getCorrelationModel().createPropertyAlias(correlationProperty, partName, isInput, correlationsEnabled, expression);
    }

    @Override
    public boolean hasSameCorrelationMessage(@NotNull CorrelationsEnabled correlationsEnabled) {
        return this.getCorrelationModel().hasSameCorrelationMessage(correlationsEnabled);
    }

    @Override
    @NotNull
    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManagerImpl(this);
        }
        return this.resourceManager;
    }

    @Override
    @NotNull
    public CatalogType getCatalogType(@NotNull TypeRef typeRef) {
        return CatalogTypeImpl.get(typeRef);
    }

    @Override
    @Nullable
    public CatalogObject findCatalogObject(@NotNull String typeName) throws AmbiguousTypeNameException {
        return this.findCatalogObject(typeName, true);
    }

    @Override
    @Nullable
    public CatalogObject findCatalogObject(@NotNull String typeName, boolean useExactMatching) throws AmbiguousTypeNameException {
        TypeRef typeRef = this.getComponentCatalog().findType(typeName, null, null, useExactMatching);
        if (typeRef == null) {
            return null;
        }
        return CatalogObjectImpl.create(this, typeRef);
    }

    @Override
    public CatalogObject findSchemaElement(@NotNull XmlElementType xmlElementType, @NotNull String namespace, @NotNull String nativeName) {
        CatalogObject result = null;
        String id = UUIDFactory.createXmlId((XmlElementType)xmlElementType, (String)namespace, (String)nativeName).getId();
        TypeRef typeRef = this.getComponentCatalog().findById(ComponentType.XML, id);
        if (typeRef != null) {
            result = CatalogObjectImpl.create(this, typeRef);
        }
        return result;
    }

    @Override
    public ProjectPreferences getPreferences() {
        if (this.preferencesHolder == null) {
            return null;
        }
        return this.preferencesHolder.get();
    }

    public Process getProcessByName(@Nullable String name) {
        if (name != null && !"".equals(name)) {
            for (Process process : this.getAllProcesses()) {
                if (!name.equalsIgnoreCase(process.getId())) continue;
                return process;
            }
        }
        return null;
    }

    public FuegoProcessList getProcessesOfType() {
        return FuegoProject.getRecursiveProcesses(this.getModelsRoot());
    }

    public MutableComponentCatalog getComponentCatalog() {
        return (MutableComponentCatalog)this.projectCatalogHolder.get();
    }

    @Override
    @Deprecated
    public List<TypeRef> getBusinessCatalog() throws ProjectException {
        MutableComponentCatalog catalog = this.getComponentCatalog();
        ObjectTypeDescription root = catalog.getRoot();
        ArrayList<TypeRef> types = new ArrayList<TypeRef>();
        for (TypeRef ref : root.getInnerTypeRefs()) {
            if ("Ext".equals(ref.getName())) continue;
            types.add(ref);
        }
        return types;
    }

    @Override
    public void dispose() throws ProjectException {
        ComponentCatalog catalog;
        if (this.getLoader() != null) {
            this.getLoader().dispose();
        }
        if (this.getWriter() != null) {
            this.getWriter().dispose();
        }
        if ((catalog = this.projectCatalogHolder.getIfSet()) != null) {
            catalog.dispose();
        }
        this.close();
    }

    @Override
    public Organization getOrganization() {
        Organization result = this.organization;
        if (result == null) {
            this.organization = result = this.findChild(Organization.class, "organization");
        }
        return result;
    }

    @Override
    public void setComponentCatalog(ComponentCatalog repository) {
        this.projectCatalogHolder.set(repository);
    }

    @Override
    public CatalogObject createCatalogObject(TypeRef typeRef) {
        return CatalogObjectImpl.create(this, typeRef);
    }

    @Override
    public CompiledProject compile() throws ProjectException {
        ProjectCompiler compiler = ProjectCompiler.createDefault(this);
        FuegoCompiler fuegoCompiler = new FuegoCompiler();
        final Any.Holder exceptionHolder = new Any.Holder();
        compiler.setCatalogCompiler((CilCompiler)fuegoCompiler);
        compiler.addCompilationListener(new ProjectCompilationListener(){

            @Override
            public void onError(ProjectException exception) {
                exceptionHolder.value = exception;
            }

            @Override
            public void onInfo(ProjectException exception) {
            }

            @Override
            public void onWarning(ProjectException exception) {
            }

            @Override
            public void onCheckStarted(ProjectObject projectObject) {
            }

            @Override
            public void onCheckFinished(ProjectObject projectObject) {
            }

            @Override
            public boolean onInterruptionCheck() {
                return false;
            }
        });
        compiler.compile(null);
        if (exceptionHolder.value != null) {
            throw (ProjectException)exceptionHolder.value;
        }
        return this;
    }

    @Override
    public Process findProcess(String modelName) {
        return this.getProcessByName(modelName);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean isOpen) {
        this.open = isOpen;
    }

    @Override
    public CatalogModule getCatalogRoot() {
        return CatalogObjectImpl.create((TypeRef)this.getComponentCatalog().getRoot()).asModule();
    }

    @Override
    public void setId(String id) {
    }

    public String toString() {
        return "FuegoProject(" + this.getName() + ')';
    }

    @Override
    public void addProjectPreferences(ProjectPreferences projectPreferences) throws ProjectException {
        this.events().preObjectAdded(projectPreferences, (ProjectObject)this);
        this.preferencesHolder.set(projectPreferences);
        projectPreferences.addPropertyObserver("j2eeMode", new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                FuegoProject.this.events().objectChanged();
            }
        });
        this.dependencyPropertyListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                FuegoProject.this.dependencyChange();
            }
        };
        projectPreferences.addPropertyObserver("dependencies", this.dependencyPropertyListener);
        this.events().postObjectAdded(projectPreferences, (ProjectObject)this);
    }

    @Override
    public void removeProjectPreferences() throws ProjectException {
        ProjectPreferences projectPreferences = this.preferencesHolder.getIfSet();
        if (projectPreferences != null) {
            this.events().preObjectRemoved(projectPreferences, (ProjectObject)this);
            this.preferencesHolder.reset();
            this.events().postObjectRemoved(projectPreferences, (ProjectObject)this);
        }
    }

    @Override
    public ProjectPreferences createProjectPreferences(String projectId) {
        return new ProjectPreferencesImpl(this, projectId);
    }

    @Override
    public void removeChild(ProjectObject object) throws ProjectException {
        assert (object.getParentObject() == this);
        if (object instanceof Process) {
            if (ModelUtils.isDefaultProcess((Process)object)) {
                this.events().preObjectRemoved(object, (ProjectObject)this);
                this.setProjectModel(null);
                this.events().postObjectRemoved(object, (ProjectObject)this);
            } else {
                this.getModelsRoot().removeChild(object);
            }
        } else {
            super.removeChild(object);
        }
    }

    @Override
    public SimulationsContainer getSimulations() {
        if (this.simulationsContainer == null) {
            this.simulationsContainer = this.findChild(SimulationsContainer.class, Path.SIMULATIONS.getName());
        }
        return this.simulationsContainer;
    }

    @Override
    @Nullable
    public CaseContainer getCaseContainer() {
        return (CaseContainer)this.findChild(FolderContainer.class, Path.CASE.getName());
    }

    @Override
    @Nullable
    public ProjectCase getCase() {
        ProjectCase result;
        Sequence<ProjectCase> cases = this.getChildrenByType(ProjectCase.class);
        ProjectCase projectCase = result = cases.isEmpty() ? null : cases.iterator().next();
        if (result == null) {
            CaseContainer caseContainer = this.getCaseContainer();
            result = caseContainer == null ? null : caseContainer.getCase();
        }
        return result;
    }

    public <P extends ProjectObject> P getObject(@NotNull ResourceContainer container, @NotNull Class<P> objectClass, @NotNull String id) {
        try {
            ProjectLoader loader = this.getLoader();
            if (loader != null) {
                return loader.getObject(container, objectClass, id);
            }
        }
        catch (ProjectException e) {
            Log.logWarning(ProjectMsg.CANNOT_LOAD_OBJECT(objectClass.toString(), id));
            Log.logDebug(e);
        }
        catch (UnsupportedOperationException e) {
            Log.logDebug(e);
        }
        return null;
    }

    @Override
    @NotNull
    public ResourceFilesContainer getResourceFilesContainer() {
        ResourceFilesContainer result = this.resourceFilesContainer;
        if (result == null) {
            this.resourceFilesContainer = result = new ResourceFilesContainerImpl(this);
        }
        return result;
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        Sequence<DataDeclaration> result = this.getProjectModel().getLocalDeclarations();
        return PredefinedVariablesHelper.appendPredefinedVariablesForContainer(result, this);
    }

    @Override
    @Nullable
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return this.getLocalDeclarations();
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return this.getProjectModel().findLocalDeclaration(name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return this.getProjectModel().findDeclaration(name);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return this.getProjectModel().findDeclarationPath(path);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public ProjectDataObject createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createDeclaration(name, type, null);
    }

    @Override
    public ProjectDataObject createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.createProjectDataObject(name, type);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof ProjectDataObject) : "DataDeclaration added to the project must be a ProjectDataObject";
        this.addProjectDataObject((ProjectDataObject)dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        this.getProjectModel().removeDeclaration(dataDeclaration);
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        this.getProjectModel().clearDeclarations();
    }

    @Override
    public <T extends ProjectObject> T createFromXml(Class<T> iface, String xml) throws ProjectException {
        return this.getLoader().createFromXml(iface, xml);
    }

    @Override
    public ProjectRepository getRepository() {
        return this.repository;
    }

    @Nullable
    public CatalogObject findExistingCatalogObject(@Nullable String typeName) {
        return this.catalogObjects.get(typeName);
    }

    public void setRepository(ProjectRepository repository) {
        this.repository = repository;
    }

    @Override
    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        ProjectObjectList<ProjectObject> list = new ProjectObjectList<ProjectObject>();
        list.add(this.getModelsRoot());
        ProjectLoader loader = this.getLoader();
        List<ProjectCase> cases = loader.getChildrenByType(this, ProjectCase.class);
        for (ProjectCase aCase : cases) {
            list.add(aCase);
        }
        this.caseContainer = (CaseContainer)this.getObject(this, FolderContainer.class, Path.CASE.getName());
        if (this.caseContainer != null) {
            list.add(this.caseContainer);
        }
        list.add(this.getObject(this, ActivityGuide.class, "activityGuide"));
        list.add(this.getObject(this, Organization.class, "organization"));
        list.add(this.getCatalogRoot());
        list.add(this.getObject(this, FolderContainer.class, Path.SIMULATIONS.getName()));
        list.add(this.getObject(this, Process.class, "default"));
        list.add(this.getResourceFilesContainer());
        List<BpelProcess> bpelProcesses = this.getLoader().getChildrenByType(this, BpelProcess.class);
        for (BpelProcess bpelProcess : bpelProcesses) {
            list.add(bpelProcess);
        }
        List<ProjectCaseActivity> caseActivities = this.getLoader().getChildrenByType(this, ProjectCaseActivity.class);
        for (ProjectCaseActivity ca : caseActivities) {
            list.add(ca);
        }
        return list;
    }

    CatalogObject createCatalogObjectInternal(TypeRef typeRef) {
        CatalogObject result = this.catalogObjects.get(typeRef.getText());
        if (result == null) {
            result = CatalogObjectImpl.newInstance(typeRef, this.getProject());
            if (!typeRef.get().isUnknown()) {
                this.catalogObjects.put(typeRef.getText(), result);
            }
        }
        return result;
    }

    private static Project getFrom(ProjectObject ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 'ref' cannot be null");
        }
        Project result = ref.getProject();
        assert (result != null) : "Type ref has no component catalog " + ref.getId();
        return result;
    }

    private static boolean isValidType(ProjectDataObject dataObject) {
        boolean result = false;
        CatalogType variableType = dataObject.getType();
        for (TypeDescription type : ProjectVariableImpl.getValidTypes()) {
            if (variableType.getKind() != type.getKind()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<Process> getProcesses(FolderContainer node, boolean recursive) {
        ArrayList<Process> result = new ArrayList<Process>();
        FuegoProject.addProcesses(result, node, recursive);
        return result;
    }

    private static void addProcesses(List<Process> list, FolderContainer node, boolean recursive) {
        Sequence<Process> models = node.getChildrenByType(Process.class);
        for (Process process : models) {
            list.add(process);
        }
        if (recursive) {
            Sequence<FolderContainer> containers = node.getChildrenByType(FolderContainer.class);
            for (FolderContainer child : containers) {
                FuegoProject.addProcesses(list, child, recursive);
            }
        }
    }

    private static FuegoProcessList getRecursiveProcesses(FolderContainer node) {
        List<Process> list = FuegoProject.getProcesses(node, true);
        return FuegoProcessList.create(list);
    }

    private void adaptToRootFile(ProjectObject po, String name) {
        ProjectLoader loader = this.getLoader();
        if (loader != null) {
            VFileSystem dataFileSystem = loader.getProjectFileSystem().getDataFileSystem();
            VFile processes = dataFileSystem.createFile(name);
            ProjectObjectImpl.setAdapter(po, processes);
        }
    }

    private void addListeners() {
        this.correlationModel.addCorrelationsModelListener(new CorrelationModelImpl.CorrelationsModelListener(){

            @Override
            public void propertyAdded(CorrelationProperty addedProperty) {
                FuegoProject.this.events().postObjectAdded(addedProperty, (ProjectObject)FuegoProject.this);
            }

            @Override
            public void propertyRemoved(CorrelationProperty removedProperty) {
                FuegoProject.this.events().postObjectRemoved(removedProperty, (ProjectObject)FuegoProject.this);
            }

            @Override
            public void propertyAliasAdded(CorrelationPropertyAlias addedAlias) {
                FuegoProject.this.events().postObjectAdded(addedAlias, (ProjectObject)FuegoProject.this);
            }

            @Override
            public void propertyAliasRemoved(CorrelationPropertyAlias removedAlias) {
                FuegoProject.this.events().postObjectRemoved(removedAlias, (ProjectObject)FuegoProject.this);
            }
        });
        this.addListener(new BatchProjectListenerAdapter<CatalogObject>(CatalogObject.class){

            @Override
            public void processPostEvents(ProjectEventSet events) {
                for (ProjectEvent event : events) {
                    Object projectObject;
                    if (event.getType() != ProjectEvent.Type.POST_REMOVE || !((projectObject = event.getProjectObject()) instanceof CatalogObject)) continue;
                    CatalogObject catalogObject = (CatalogObject)projectObject;
                    CatalogObject oldReference = (CatalogObject)FuegoProject.this.catalogObjects.remove(catalogObject.getText());
                    oldReference.dispose();
                }
            }
        });
    }

    private ProjectDataObject createProjectDataObject(String variableId, CatalogType type) throws ProjectException {
        return (ProjectDataObject)this.getProjectModel().createDeclaration(variableId, type);
    }

    private void addProjectDataObject(ProjectDataObject dataObject) throws ProjectException {
        if (!FuegoProject.isValidType(dataObject)) {
            throw new ProjectException(dataObject, ProjectModelMsg.INVALID_CONVERT_PROJECT_VARIABLE_TYPE(dataObject.getDefaultLabel()));
        }
        this.getProjectModel().addDeclaration(dataObject);
    }

    private LazyHolder<ProjectPreferences> buildPreferencesHolder() {
        return new LazyHolder<ProjectPreferences>(){

            @Override
            @NotNull
            protected ProjectPreferences init() {
                ProjectPreferences preferences;
                ResourceContainer configFolder = FuegoProject.this.getObject(FuegoProject.this, FolderContainer.class, Path.CONFIG.getName());
                ProjectPreferences projectPreferences = preferences = configFolder != null ? FuegoProject.this.getObject(configFolder, ProjectPreferences.class, Path.PREFERENCES.getName()) : null;
                if (preferences == null) {
                    preferences = FuegoProject.this.createProjectPreferences(Path.PREFERENCES.getName());
                }
                return preferences;
            }
        };
    }

    private LazyHolder<ComponentCatalog> buildCatalogHolder() {
        return new LazyHolder<ComponentCatalog>(){

            @Override
            @NotNull
            protected ComponentCatalog init() {
                ProjectLoader loader = FuegoProject.this.getLoader();
                try {
                    loader.loadCatalog(null);
                }
                catch (ProjectException e) {
                    Log.logSevere(e);
                }
                ComponentCatalog result = (ComponentCatalog)this.getIfSet();
                if (result != null) {
                    result.addListener((CatalogListener)new CatalogAdapter(){

                        @Override
                        public void typeRemoved(String typeName) {
                            FuegoProject.this.catalogObjects.remove(typeName);
                        }
                    });
                }
                ((ProjectObjectImpl)((Object)FuegoProject.this.getCatalogRoot())).events().enable();
                assert (result != null);
                return result;
            }
        };
    }

    private void setModelsRoot(FolderContainer folderContainer) {
        this.modelsRoot = folderContainer;
        if (folderContainer != null && ((EventSource)((Object)folderContainer)).events() != null) {
            ((EventSource)((Object)folderContainer)).events().enable();
        }
    }

    private void setProjectModel(Process model) {
        this.projectModel = model;
    }

    private void replaceProjectModel(Process oldProcess, Process newModel) {
        this.setProjectModel(newModel);
        this.events().objectReplaced(oldProcess, newModel);
    }

    private void close() {
        super.wipe();
        if (this.dependencyPropertyListener != null) {
            this.getPreferences().removePropertyObserver("dependencies", this.dependencyPropertyListener);
        }
        this.events().clear();
        this.organization = null;
        ComponentCatalog componentCatalog = this.projectCatalogHolder.getIfSet();
        if (componentCatalog != null) {
            componentCatalog.removeListeners();
            this.projectCatalogHolder.reset();
        }
        this.setLoader(null);
        this.setWriter(null);
        this.open = false;
        this.projectModel = null;
        this.repository = null;
        if (this.resourceFilesContainer != null) {
            this.resourceFilesContainer.clear();
            this.resourceFilesContainer = null;
        }
        if (this.simulationsContainer != null) {
            this.simulationsContainer.clear();
            this.simulationsContainer = null;
        }
        if (this.preferencesHolder != null) {
            this.preferencesHolder.reset();
        }
        if (this.catalogObjects != null) {
            this.catalogObjects.clear();
            this.catalogObjects = null;
        }
        if (this.correlationModel != null) {
            this.correlationModel.wipe();
        }
        if (this.modelsRoot != null) {
            this.modelsRoot.clear();
            this.modelsRoot = null;
        }
        if (this.preferencesHolder != null) {
            this.preferencesHolder.reset();
            this.preferencesHolder = null;
        }
        this.resourceManager = null;
    }
}

