/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.model.features.AnalyticsViewIdentifierFeature;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.AuthorFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.FileRevisionFeature;
import oracle.bpm.project.model.features.GreedyExecutionModeFeature;
import oracle.bpm.project.model.features.IncludesStoredI18n;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.IsAtomicFeature;
import oracle.bpm.project.model.features.IsInstanceScreenflowFeature;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.project.model.features.OutputArgumentsFeature;
import oracle.bpm.project.model.features.ProcessLayoutFeature;
import oracle.bpm.project.model.features.ProcessRelativeCoordinatesFeature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.features.SuspendInstanceOnDataAssociationErrorFeature;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.activities.ProcessGenerateEventsFeature;
import oracle.bpm.project.model.processes.activities.SharePredefinedVariablesFeature;

public class FeaturesByProcess {
    private FeaturesByProcess() {
    }

    public static Features get(Process model) {
        HashMap<Class, Feature> result = new HashMap<Class, Feature>();
        FeaturesByProcess.addTo(result, IsInstanceScreenflowFeature.create());
        FeaturesByProcess.addTo(result, ProcessLayoutFeature.create());
        FeaturesByProcess.addTo(result, ViewScaleFeature.create());
        FeaturesByProcess.addTo(result, ProcessSealTypeFeature.create());
        FeaturesByProcess.addTo(result, SharePredefinedVariablesFeature.create());
        FeaturesByProcess.addTo(result, ProcessGenerateEventsFeature.create());
        FeaturesByProcess.addTo(result, GreedyExecutionModeFeature.create());
        FeaturesByProcess.addTo(result, NamespaceFeature.create());
        FeaturesByProcess.addTo(result, AuthorFeature.create());
        FeaturesByProcess.addTo(result, AnalyticsViewIdentifierFeature.create());
        FeaturesByProcess.addTo(result, IsAtomicFeature.create());
        FeaturesByProcess.addTo(result, AnnotationsFeature.create());
        FeaturesByProcess.addTo(result, FileRevisionFeature.create());
        FeaturesByProcess.addTo(result, IncludesStoredI18n.create());
        FeaturesByProcess.addTo(result, InputArgumentsFeature.create(model));
        FeaturesByProcess.addTo(result, OutputArgumentsFeature.create(model));
        FeaturesByProcess.addTo(result, ProcessRelativeCoordinatesFeature.create());
        FeaturesByProcess.addTo(result, SuspendInstanceOnDataAssociationErrorFeature.create());
        return Features.create(result);
    }

    private static void addTo(Map<Class, Feature> result, Feature feature) {
        result.put(feature.getClass(), feature);
    }
}

