/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.type.Argument;
import org.jetbrains.annotations.NotNull;

public class DefaultDeclaration
extends DataDeclarationImpl
implements DataDeclaration {
    private Argument argument;
    private DataDeclarationContainer container;

    public DefaultDeclaration(@NotNull DataDeclarationContainer container, @NotNull String name, @NotNull CatalogType type, @NotNull AccessType accessType) {
        super(container.getProject());
        this.container = container;
        this.argument = new Argument(name, type.getDynamicRef(), this.decodeModifiers(accessType));
    }

    @Override
    public String getName() {
        return this.argument.getName();
    }

    @Override
    public CatalogType getType() {
        return CatalogTypeImpl.get(this.argument.getTypeRef());
    }

    @Override
    public boolean isIn() {
        return this.argument.isIn();
    }

    @Override
    public boolean isOut() {
        return this.argument.isOut();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void setName(String name) {
        this.argument.setName(name);
    }

    @Override
    public void setType(CatalogType type) {
        this.argument.setType(type.getDynamicRef());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public DataDeclarationType getDeclarationType() {
        return DataDeclarationType.DATA_DECLARATION;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.container;
    }

    public AccessType getAccessType() {
        return DataDeclarationImpl.getAccessType(this);
    }

    @Override
    public DataDeclarationContainer getDeclarationContainer() {
        return this.container;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultDeclaration)) {
            return false;
        }
        DefaultDeclaration that = (DefaultDeclaration)o;
        if (this.getAccessType() != that.getAccessType()) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return !(this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null);
    }

    public int hashCode() {
        int result = this.getAccessType() != null ? this.getAccessType().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        return result;
    }

    @Override
    public Class getRawClass() {
        return DefaultDeclaration.class;
    }

    private long decodeModifiers(@NotNull AccessType access) {
        switch (access) {
            case IN: {
                return 1L;
            }
            case OUT: {
                return 2L;
            }
            case IN_OUT: {
                return 3L;
            }
        }
        return 1L;
    }
}

