/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.CorrelationPropertyAliasImpl;
import oracle.bpm.project.CorrelationPropertyAliasKey;
import oracle.bpm.project.CorrelationPropertyImpl;
import oracle.bpm.project.CorrelationUtils;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.catalog.correlation.CorrelationLowLevelModel;
import oracle.bpm.project.catalog.correlation.Property;
import oracle.bpm.project.catalog.correlation.PropertyAlias;
import oracle.bpm.project.catalog.correlation.PropertyAliasImpl;
import oracle.bpm.project.catalog.correlation.PropertyAliasSetId;
import oracle.bpm.project.catalog.correlation.PropertyImpl;
import oracle.bpm.project.model.CorrelationModel;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorrelationModelImpl
extends ResourceObjectImpl
implements CorrelationModel {
    private final CorrelationLowLevelModel correlationLowLevelModel;
    private final ArrayList<CorrelationsModelListener> listeners;
    private Project project;
    private final HashMap<QName, CorrelationProperty> propertiesCache;
    private final HashMap<CorrelationPropertyAliasKey, CorrelationPropertyAlias> propertyAliasesCache;
    private final HashMap<CorrelationPropertyAliasKey, ExpressionMode> propertyAliasExpressionModeMap;

    public CorrelationModelImpl(@NotNull Project project) {
        super(project);
        this.project = project;
        this.correlationLowLevelModel = new CorrelationLowLevelModel(project);
        this.listeners = new ArrayList();
        this.propertiesCache = new HashMap();
        this.propertyAliasesCache = new HashMap();
        this.propertyAliasExpressionModeMap = new HashMap();
        this.addListeners();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void wipe() {
        super.wipe();
        this.listeners.clear();
        this.propertyAliasesCache.clear();
        this.propertyAliasExpressionModeMap.clear();
    }

    @Override
    @NotNull
    public Sequence<CorrelationProperty> getProperties() {
        List lowLevelPropertyList = this.correlationLowLevelModel.getAllProperties();
        ArrayList<CorrelationProperty> propertyList = new ArrayList<CorrelationProperty>();
        for (Property lowLevelProperty : lowLevelPropertyList) {
            CorrelationProperty property = this.findProperty(lowLevelProperty.getName());
            propertyList.add(property);
        }
        List<CorrelationProperty> sortedList = CollectionUtils.sort(propertyList, new Comparator<CorrelationProperty>(){

            @Override
            public int compare(CorrelationProperty correlationProperty, CorrelationProperty correlationProperty1) {
                return correlationProperty.getName().compareTo(correlationProperty1.getName());
            }
        });
        return CollectionUtils.asSequence(sortedList);
    }

    @Override
    @NotNull
    public Sequence<CorrelationPropertyAlias> getPropertyAliases() {
        List lowLevelPropertyAliases = this.correlationLowLevelModel.getPropertyAliases();
        ArrayList<CorrelationPropertyAlias> propertyAliasesList = new ArrayList<CorrelationPropertyAlias>();
        for (PropertyAlias lowLevelPropertyAlias : lowLevelPropertyAliases) {
            CorrelationPropertyAlias correlationPropertyAlias = this.findOrCreatePropertyAlias(lowLevelPropertyAlias);
            if (correlationPropertyAlias == null) continue;
            propertyAliasesList.add(correlationPropertyAlias);
        }
        return CollectionUtils.asSequence(propertyAliasesList);
    }

    @Override
    public CorrelationProperty findProperty(@NotNull QName propertyName) {
        return this.findOrCreateCachedProperty(propertyName);
    }

    @Override
    @Nullable
    public CorrelationProperty findProperty(@NotNull String propertyLocalPartName) {
        return this.findProperty(this.createPropertyQName(propertyLocalPartName));
    }

    @Override
    @NotNull
    public CorrelationProperty createCorrelationProperty(@NotNull String propertyName, @NotNull CatalogType catalogType) {
        QName typeQName = this.getQNameFromType(catalogType);
        PropertyImpl lowLevelProperty = new PropertyImpl(false, this.createPropertyQName(propertyName), typeQName);
        return new CorrelationPropertyImpl(this.getProject(), (Property)lowLevelProperty);
    }

    @Override
    public void setProperty(@NotNull CorrelationProperty property) throws ProjectException {
        this.propertiesCache.put(property.getFullName(), property);
        QName typeQName = this.getQNameFromType(property.getType());
        PropertyImpl lowLevelProperty = new PropertyImpl(property.isReadOnly(), property.getFullName(), typeQName);
        this.correlationLowLevelModel.setProperty((Property)lowLevelProperty);
        this.write();
    }

    @Override
    public void setPropertyAlias(@NotNull CorrelationPropertyAlias correlationPropertyAlias) throws ProjectException {
        PropertyAliasSetId propertyAliasSetId = this.getPropertyAliasSetId(correlationPropertyAlias);
        CorrelationPropertyAliasKey key = CorrelationPropertyAliasKey.create(propertyAliasSetId, correlationPropertyAlias.getProperty().getFullName());
        this.putPropertyAliasInCache(correlationPropertyAlias, key);
        PropertyAlias alias = PropertyAliasImpl.build((QName)correlationPropertyAlias.getProperty().getFullName(), (PropertyAliasSetId)propertyAliasSetId, (Expression)correlationPropertyAlias.getExpression());
        this.correlationLowLevelModel.setPropertyAlias(alias);
        this.write();
    }

    @Override
    public void removeProperty(@NotNull String propertyName) throws ProjectException {
        this.correlationLowLevelModel.removeProperty(propertyName);
        this.write();
    }

    @Override
    public void removePropertyAlias(@NotNull CorrelationPropertyAlias alias) throws ProjectException {
        PropertyAliasSetId propertyAliasSetId = CorrelationUtils.getPropertyAliasSetId(alias);
        this.correlationLowLevelModel.removePropertyAlias(alias.getProperty().getFullName(), propertyAliasSetId);
        this.write();
    }

    @Override
    public CorrelationPropertyAlias findPropertyAlias(@NotNull CorrelationProperty correlationProperty, @Nullable String partName, boolean isInput, @NotNull CorrelationsEnabled correlationsEnabled) {
        PropertyAliasSetId propertyAliasSetId = CorrelationUtils.getPropertyAliasSetId(correlationsEnabled, isInput, partName);
        PropertyAlias propertyAlias = this.correlationLowLevelModel.findPropertyAlias(correlationProperty.getFullName(), propertyAliasSetId);
        return this.findOrCreatePropertyAlias(propertyAlias);
    }

    @Override
    @NotNull
    public CorrelationPropertyAlias createPropertyAlias(@NotNull CorrelationProperty correlationProperty, @Nullable String partName, boolean isInput, @NotNull CorrelationsEnabled correlationsEnabled, @NotNull Expression expression) {
        PropertyAliasSetId id = PropertyAliasSetId.create((CorrelationsEnabled)correlationsEnabled, (boolean)isInput, (String)partName);
        CorrelationPropertyAliasImpl correlationPropertyAlias = id != null ? CorrelationPropertyAliasImpl.create(this.getProject(), expression, correlationProperty.getFullName(), id) : null;
        return correlationPropertyAlias;
    }

    @NotNull
    public CorrelationLowLevelModel getLowLevelModel() {
        return this.correlationLowLevelModel;
    }

    public void addCorrelationsModelListener(@NotNull CorrelationsModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeCorrelationsModelListener(@NotNull CorrelationsModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean hasSameCorrelationMessage(@NotNull CorrelationsEnabled correlationsEnabled) {
        if (correlationsEnabled.isInputCorrelationsEnabled() && correlationsEnabled.isOutputArgumentsEnabled()) {
            PropertyAliasSetId inputPropertyAliasSetId = PropertyAliasSetId.create((CorrelationsEnabled)correlationsEnabled, (boolean)true, null);
            PropertyAliasSetId outputPropertyAliasSetId = PropertyAliasSetId.create((CorrelationsEnabled)correlationsEnabled, (boolean)false, null);
            return inputPropertyAliasSetId != null && outputPropertyAliasSetId != null && inputPropertyAliasSetId.equals((Object)outputPropertyAliasSetId);
        }
        return false;
    }

    public final void setPropertyAliasExpressionMode(@NotNull PropertyAliasSetId propertyAliasSetId, @NotNull QName fullPropertyName, @NotNull ExpressionMode mode) {
        CorrelationPropertyAliasKey key = CorrelationPropertyAliasKey.create(propertyAliasSetId, fullPropertyName);
        this.propertyAliasExpressionModeMap.put(key, mode);
    }

    public final void setPropertyAliasExpressionMode(@NotNull CorrelationPropertyAliasKey aliasKey, @NotNull ExpressionMode mode) {
        this.setPropertyAliasExpressionMode(aliasKey.getId(), aliasKey.getPropertyName(), mode);
    }

    private void write() throws ProjectException {
        this.getProject().getWriter().write(this);
    }

    @Nullable
    private CorrelationProperty findOrCreateCachedProperty(@NotNull QName propertyName) {
        CorrelationProperty result = null;
        if (this.propertiesCache.containsKey(propertyName)) {
            result = this.propertiesCache.get(propertyName);
        } else {
            Property property = this.correlationLowLevelModel.findProperty(propertyName);
            if (property != null) {
                result = new CorrelationPropertyImpl(this.getProject(), property);
                this.propertiesCache.put(propertyName, result);
            }
        }
        return result;
    }

    @NotNull
    private PropertyAliasSetId getPropertyAliasSetId(@NotNull CorrelationPropertyAlias propertyAlias) {
        return CorrelationUtils.getPropertyAliasSetId(propertyAlias);
    }

    @Nullable
    private CorrelationPropertyAlias findOrCreatePropertyAlias(@Nullable PropertyAlias propertyAlias) {
        CorrelationPropertyAlias correlationPropertyAlias = null;
        if (propertyAlias != null) {
            PropertyAliasSetId propertyAliasSetId = CorrelationUtils.getPropertyAliasSetId(propertyAlias);
            CorrelationPropertyAliasKey key = CorrelationPropertyAliasKey.create(propertyAliasSetId, propertyAlias.getProperty());
            if (this.propertyAliasesCache.containsKey(key)) {
                correlationPropertyAlias = this.getPropertyAliasFromCache(key);
            } else {
                correlationPropertyAlias = CorrelationPropertyAliasImpl.create(this.getProject(), propertyAlias);
                this.putPropertyAliasInCache(correlationPropertyAlias, key);
            }
        }
        return correlationPropertyAlias;
    }

    @Nullable
    private CorrelationPropertyAlias getPropertyAliasFromCache(@NotNull CorrelationPropertyAliasKey key) {
        CorrelationPropertyAlias correlationPropertyAlias = this.propertyAliasesCache.get(key);
        ExpressionMode expressionMode = this.propertyAliasExpressionModeMap.get(key);
        if (expressionMode != null && correlationPropertyAlias != null) {
            correlationPropertyAlias.getExpression().setMode(expressionMode);
        }
        return correlationPropertyAlias;
    }

    private void putPropertyAliasInCache(@NotNull CorrelationPropertyAlias correlationPropertyAlias, @NotNull CorrelationPropertyAliasKey key) {
        this.propertyAliasesCache.put(key, correlationPropertyAlias);
        this.propertyAliasExpressionModeMap.put(key, correlationPropertyAlias.getExpression().getMode());
    }

    private void addListeners() {
        this.correlationLowLevelModel.addListener(new CorrelationLowLevelModel.CorrelationPropertiesListener(){

            public void propertiesRemoved(Collection<Property> removedProperties) {
                for (Property removedProperty : removedProperties) {
                    CorrelationProperty property = CorrelationModelImpl.this.findProperty(removedProperty.getName());
                    if (CorrelationModelImpl.this.propertiesCache.containsKey(removedProperty.getName())) {
                        CorrelationModelImpl.this.propertiesCache.remove(removedProperty.getName());
                    }
                    CorrelationModelImpl.this.firePropertyRemoved(property);
                }
            }

            public void propertyAliasesRemoved(Collection<PropertyAlias> removedAliases) {
                for (PropertyAlias removedAlias : removedAliases) {
                    CorrelationPropertyAlias alias = CorrelationModelImpl.this.findOrCreatePropertyAlias(removedAlias);
                    PropertyAliasSetId propertyAliasSetId = CorrelationUtils.getPropertyAliasSetId(removedAlias);
                    CorrelationPropertyAliasKey key = CorrelationPropertyAliasKey.create(propertyAliasSetId, removedAlias.getProperty());
                    if (CorrelationModelImpl.this.propertyAliasesCache.containsKey(key)) {
                        CorrelationModelImpl.this.propertyAliasesCache.remove(key);
                    }
                    if (CorrelationModelImpl.this.propertyAliasExpressionModeMap.containsKey(key)) {
                        CorrelationModelImpl.this.propertyAliasExpressionModeMap.remove(key);
                    }
                    CorrelationModelImpl.this.firePropertyAliasRemoved(alias);
                }
            }

            public void propertiesAdded(Collection<Property> addedProperties) {
                for (Property addedProperty : addedProperties) {
                    CorrelationProperty property = CorrelationModelImpl.this.findProperty(addedProperty.getName());
                    CorrelationModelImpl.this.firePropertyAdded(property);
                }
            }

            public void propertyAliasesAdded(Collection<PropertyAlias> addedAliases) {
                for (PropertyAlias addedAlias : addedAliases) {
                    CorrelationPropertyAlias alias = CorrelationModelImpl.this.findOrCreatePropertyAlias(addedAlias);
                    CorrelationModelImpl.this.firePropertyAliasAdded(alias);
                }
            }

            public void clear() {
            }
        });
    }

    @Nullable
    private QName getQNameFromType(@NotNull CatalogType catalogType) {
        return catalogType.getDelegate().asSchemaObject().getQName();
    }

    @NotNull
    private QName createPropertyQName(@NotNull String propertyName) {
        return new QName(this.getProject().getProjectNamespace(), propertyName);
    }

    private void firePropertyAdded(@Nullable CorrelationProperty property) {
        for (CorrelationsModelListener listener : this.listeners) {
            listener.propertyAdded(property);
        }
    }

    private void firePropertyRemoved(@Nullable CorrelationProperty property) {
        for (CorrelationsModelListener listener : this.listeners) {
            listener.propertyRemoved(property);
        }
    }

    private void firePropertyAliasAdded(@Nullable CorrelationPropertyAlias alias) {
        for (CorrelationsModelListener listener : this.listeners) {
            listener.propertyAliasAdded(alias);
        }
    }

    private void firePropertyAliasRemoved(@Nullable CorrelationPropertyAlias alias) {
        for (CorrelationsModelListener listener : this.listeners) {
            listener.propertyAliasRemoved(alias);
        }
    }

    public static interface CorrelationsModelListener {
        public void propertyAdded(CorrelationProperty var1);

        public void propertyRemoved(CorrelationProperty var1);

        public void propertyAliasAdded(CorrelationPropertyAlias var1);

        public void propertyAliasRemoved(CorrelationPropertyAlias var1);
    }
}

