/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.UnknownCorrelationProperty;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorrelationKeyImpl
extends ProjectObjectImpl
implements CorrelationKey {
    private final Set<QName> propertiesQNames;

    public CorrelationKeyImpl(@NotNull CorrelationKeyContainer container, @NotNull String correlationKeyId) {
        super(container.getProject());
        this.setId(correlationKeyId);
        this.setParentObject(container);
        this.propertiesQNames = new HashSet<QName>();
    }

    @Override
    public String getName() {
        return super.getId();
    }

    @Override
    public void setName(@NotNull String name) {
        super.setId(name);
    }

    @Override
    @NotNull
    public Sequence<CorrelationProperty> getProperties() {
        ArrayList<CorrelationProperty> correlationProperties = new ArrayList<CorrelationProperty>();
        for (QName propertyQName : this.propertiesQNames) {
            CorrelationProperty correlationProperty = this.getProject().findProperty(propertyQName);
            if (correlationProperty != null) {
                correlationProperties.add(correlationProperty);
                continue;
            }
            correlationProperties.add(UnknownCorrelationProperty.create(propertyQName));
        }
        return CollectionUtils.asSequence(correlationProperties);
    }

    @Override
    @Nullable
    public CorrelationProperty getProperty(final @NotNull QName propertyName) {
        Sequence<CorrelationProperty> correlationPropertySequence = this.getProperties().select(new Predicate<CorrelationProperty>(){

            @Override
            public boolean check(@Nullable CorrelationProperty correlationProperty) {
                return correlationProperty != null && correlationProperty.getFullName().equals(propertyName);
            }
        });
        return !correlationPropertySequence.isEmpty() ? correlationPropertySequence.iterator().next() : null;
    }

    @Override
    public void addProperty(@NotNull CorrelationProperty correlationProperty) throws ProjectException {
        this.propertiesQNames.add(correlationProperty.getFullName());
        this.events().objectChanged();
    }

    @Override
    public void addProperty(@NotNull QName propertyQName) throws ProjectException {
        this.propertiesQNames.add(propertyQName);
        this.events().objectChanged();
    }

    @Override
    public void removeProperty(@NotNull CorrelationProperty correlationProperty) throws ProjectException {
        this.propertiesQNames.remove(correlationProperty.getFullName());
        this.events().objectChanged();
    }

    @Override
    public void removeProperty(@NotNull QName propertyName) throws ProjectException {
        CorrelationProperty property = null;
        for (CorrelationProperty correlationProperty : this.getProperties()) {
            if (!correlationProperty.getFullName().equals(propertyName)) continue;
            property = correlationProperty;
            break;
        }
        if (property != null) {
            this.removeProperty(property);
        }
    }

    @Override
    public void clearProperties() {
        this.propertiesQNames.clear();
        this.events().objectChanged();
    }

    @Override
    public CorrelationKeyContainer getParentObject() {
        return (CorrelationKeyContainer)super.getParentObject();
    }

    @Override
    public CorrelationKey copy() {
        CorrelationKeyImpl result = new CorrelationKeyImpl(this.getParentObject(), this.getId());
        for (QName property : this.propertiesQNames) {
            try {
                result.addProperty(property);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }
        return result;
    }

    @Override
    public void applyFrom(@NotNull CorrelationKey source) {
        this.setId(source.getId());
        this.setParentObject(source.getParentObject());
        this.clearProperties();
        for (CorrelationProperty property : source.getProperties()) {
            try {
                this.addProperty(property);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }
    }
}

