/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.CorrelationItemImpl;
import oracle.bpm.project.ImmutableDataDeclarationContainer;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CorrelationItemsContainerImpl
extends ProjectObjectContainerImpl
implements CorrelationItemsContainer {
    public CorrelationItemsContainerImpl(CorrelationsEnabled parent) {
        super(parent.getProject());
        this.setParentObject(parent);
    }

    @Override
    @NotNull
    public Sequence<CorrelationItem> getCorrelationItems() {
        return this.getChildrenByType(CorrelationItem.class);
    }

    @Override
    public void addCorrelationItem(@NotNull CorrelationItem correlationItem) throws ProjectException {
        this.addChild(correlationItem);
    }

    @Override
    public void removeCorrelationItem(@NotNull CorrelationItem correlationItem) throws ProjectException {
        this.removeChild(correlationItem);
    }

    @Override
    public void clearCorrelationItems() {
        this.clear();
    }

    @Override
    @NotNull
    public Sequence<CorrelationKey> getScopedCorrelationKeys() {
        Sequence<CorrelationKey> scopedCorrelationKeys = CollectionUtils.emptySequence();
        CorrelationKeyContainer keyContainer = this.getCorrelationKeyContainer();
        if (keyContainer != null) {
            scopedCorrelationKeys = keyContainer.getScopedCorrelationKeys();
        }
        return scopedCorrelationKeys;
    }

    @Override
    public Sequence<CorrelationKey> getCorrelationKeys() {
        ArrayList<CorrelationKey> result = new ArrayList<CorrelationKey>();
        for (CorrelationItem item : this.getCorrelationItems()) {
            result.add(item.getCorrelationKey());
        }
        return CollectionUtils.asSequence(result);
    }

    @Override
    public CorrelationItem createCorrelationItem(@NotNull CorrelationKey correlationKey, boolean initiates) {
        return new CorrelationItemImpl(this, correlationKey, initiates);
    }

    @Override
    public DataDeclarationContainer getExpressionContext(@Nullable String partName) {
        ImmutableDataDeclarationContainer result = null;
        DataDeclarationContainer argumentsContainer = this.getArgumentsContainer();
        if (argumentsContainer != null) {
            if (partName != null) {
                final DataDeclaration argument = argumentsContainer.findDeclaration(partName);
                result = new ImmutableDataDeclarationContainer(this.getProject()){

                    @Override
                    public Sequence<DataDeclaration> getLocalDeclarations() {
                        return argument != null ? CollectionUtils.singletonSequence(argument) : CollectionUtils.emptySequence();
                    }
                };
            } else {
                result = new ImmutableDataDeclarationContainer(this.getProject()){

                    @Override
                    public Sequence<DataDeclaration> getLocalDeclarations() {
                        return CorrelationItemsContainerImpl.this.getArgumentsContainer().getLocalDeclarations();
                    }
                };
            }
        }
        return result;
    }

    @Override
    public CorrelationsEnabled getParentObject() {
        return (CorrelationsEnabled)super.getParentObject();
    }

    @Override
    public Sequence<String> getPartNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getParentObject().mustSplitCorrelationParts()) {
            Sequence<DataDeclaration> arguments = this.getArgumentsContainer().getLocalDeclarations();
            for (DataDeclaration argument : arguments) {
                result.add(argument.getName());
            }
        } else {
            result.add(null);
        }
        return CollectionUtils.asSequence(result);
    }

    @Override
    public String getNativePartName(@Nullable String partName) {
        DataDeclaration argumentDeclaration;
        String result = partName;
        if (partName != null && (argumentDeclaration = this.getArgumentsContainer().findLocalDeclaration(partName)) != null && argumentDeclaration instanceof CatalogArgument) {
            CatalogArgument catalogArgument = (CatalogArgument)argumentDeclaration;
            result = catalogArgument.getDelegateArgument().getProperty("partName");
        }
        return result;
    }

    protected abstract DataDeclarationContainer getArgumentsContainer();

    @Nullable
    private CorrelationKeyContainer getCorrelationKeyContainer() {
        ProjectObject parent;
        for (parent = this.getParentObject(); parent != null && !CorrelationKeyContainer.class.isAssignableFrom(parent.getRawClass()); parent = parent.getParentObject()) {
        }
        return parent != null && CorrelationKeyContainer.class.isAssignableFrom(parent.getRawClass()) ? (CorrelationKeyContainer)parent : null;
    }
}

