/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Correlation;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;
import org.jetbrains.annotations.NotNull;

public class CorrelationImpl
extends ProcessObjectImpl
implements Correlation.Mutable {
    private Process content;
    private ArrayList<Variable> elements = new ArrayList();

    public CorrelationImpl(ProcessContent content) {
        super(content.getProject(), content);
        this.content = content;
    }

    public CorrelationImpl(ProcessContent content, String name) {
        this(content);
        this.setId(name);
    }

    public Process getContent() {
        return this.content;
    }

    @Override
    public Variable getElement(String name) {
        for (Variable variable : this.elements) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    @NotNull
    public Correlation.Mutable asMutable() {
        return this;
    }

    @Override
    public Variable[] getElements() {
        return this.elements.toArray(new Variable[this.elements.size()]);
    }

    @Override
    public int getElementIndex(String name) {
        return this.elements.indexOf(this.getElement(name));
    }

    @Override
    public void addElement(String name, TypeRef type) {
        this.addElement(new Variable(name, type));
    }

    @Override
    public void addElement(Variable variable) {
        this.elements.add(variable);
    }

    public boolean containsProperty(String mapName) {
        return this.getElement(mapName) != null;
    }

    @Override
    public void moveElementDown(String name) {
        Variable var = this.getElement(name);
        if (var == null) {
            return;
        }
        int index = this.elements.indexOf(var);
        if (index == this.elements.size() - 1) {
            return;
        }
        this.elements.remove(var);
        this.elements.add(index + 1, var);
    }

    @Override
    public void moveElementUp(String name) {
        Variable var = this.getElement(name);
        if (var == null) {
            return;
        }
        int index = this.elements.indexOf(var);
        if (index == 0) {
            return;
        }
        this.elements.remove(var);
        this.elements.add(index - 1, var);
    }

    @Override
    public boolean removeElement(String name) {
        for (Variable variable : this.elements) {
            if (!variable.getName().equals(name)) continue;
            return this.elements.remove(variable);
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.CORRELATION;
    }
}

