/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.collections.Sequence;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.catalog.loaders.MdsDictionaryFinder;
import oracle.bpm.project.catalog.loaders.VFileSystemDictionaryFinder;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.soa.io.IOFactory;
import oracle.bpm.soa.rules.exception.BpmBusinessRuleException;
import oracle.bpm.type.TypeRef;
import oracle.rules.sdk2.decisionpoint.DecisionPointDictionaryFinder;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import org.jetbrains.annotations.NotNull;

public class BusinessRuleImpl
extends CatalogObjectImpl
implements BusinessRule {
    RuleDictionary m_dictionary;

    public BusinessRuleImpl(Project project, TypeRef model) {
        super(project, model);
        this.setDefault(false);
        this.m_dictionary = null;
    }

    @Override
    public boolean isBusinessRule() {
        return true;
    }

    @Override
    public Sequence<CatalogMember> getMethods() {
        this.clear();
        return super.getMethods();
    }

    @Override
    public Class getRawClass() {
        return BusinessRule.class;
    }

    @Override
    public String getBusinessRuleNativeName() {
        return this.getDelegate().asObject().getNativeName();
    }

    @Override
    public RuleDictionary getDictionary() {
        if (this.m_dictionary == null) {
            VFile vFile = this.as(VFile.class);
            DictionaryFinder finder = BusinessRuleImpl.createDictionaryFinderChain(vFile);
            try {
                this.m_dictionary = IOFactory.createRulesVFileIO().loadDictionary((Object)vFile, finder);
            }
            catch (BpmBusinessRuleException exc) {
                throw new RuntimeException(exc);
            }
        }
        return this.m_dictionary;
    }

    @NotNull
    private static DictionaryFinder createDictionaryFinderChain(VFile dictionaryFile) {
        DecisionPointDictionaryFinder pointDictionaryFinder = new DecisionPointDictionaryFinder();
        VFileSystemDictionaryFinder vFileSystemDictionaryFinder = new VFileSystemDictionaryFinder((DictionaryFinder)pointDictionaryFinder, dictionaryFile.getFileSystem());
        MdsDictionaryFinder mdsRulesDictionaryFinder = new MdsDictionaryFinder((DictionaryFinder)vFileSystemDictionaryFinder, "rules");
        MdsDictionaryFinder mdsMediatorDictionaryFinder = new MdsDictionaryFinder((DictionaryFinder)mdsRulesDictionaryFinder, "mediator/oracle/rules");
        MdsDictionaryFinder mdsCasemgmtDictionaryFinder = new MdsDictionaryFinder((DictionaryFinder)mdsMediatorDictionaryFinder, "casemgmt/oracle/rules");
        return mdsCasemgmtDictionaryFinder;
    }
}

