/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lib.Expression;
import oracle.bpm.processmodel.ActivityType;
import oracle.bpm.project.BPMNTypes;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.EmptyDataDeclarationContainer;
import oracle.bpm.project.ImmutableDataDeclarationContainer;
import oracle.bpm.project.InputCorrelationItemsContainerImpl;
import oracle.bpm.project.LoopCharacteristicsImpl;
import oracle.bpm.project.OutputCorrelationItemsContainerImpl;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.activities.FeaturesByBPMNType;
import oracle.bpm.project.activities.FeaturesByEventTrigger;
import oracle.bpm.project.catalog.type.utils.NotificationServiceHelper;
import oracle.bpm.project.catalog.type.utils.TaskManagementServiceHelper;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.NotificationObject;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.catalog.UpdateObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.BusinessRuleTaskFeature;
import oracle.bpm.project.model.features.ConversationalFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.InputCorrelationItemsFeature;
import oracle.bpm.project.model.features.InputDataAssociationFeature;
import oracle.bpm.project.model.features.InputMessageHeaderSetFeature;
import oracle.bpm.project.model.features.InputServicePropertySetFeature;
import oracle.bpm.project.model.features.InstantiateFeature;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.features.IsDraftFeature;
import oracle.bpm.project.model.features.IsInterruptingFeature;
import oracle.bpm.project.model.features.LoggableFeature;
import oracle.bpm.project.model.features.NotificationFeature;
import oracle.bpm.project.model.features.OutputArgumentsFeature;
import oracle.bpm.project.model.features.OutputCorrelationItemsFeature;
import oracle.bpm.project.model.features.OutputDataAssociationFeature;
import oracle.bpm.project.model.features.OutputMessageHeaderSetFeature;
import oracle.bpm.project.model.features.OutputServicePropertySetFeature;
import oracle.bpm.project.model.features.RelatedProcessNameFeature;
import oracle.bpm.project.model.features.ScriptTaskFeature;
import oracle.bpm.project.model.features.UpdateFeature;
import oracle.bpm.project.model.features.UserTaskFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ActivityGenerateEvents;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventBasedGatewayType;
import oracle.bpm.project.model.processes.EventBasedGatewayTypeFeature;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.ExpressionFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OperationReferenceExtended;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.ParticipantReference;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ReinitiatePolicy;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.ComplexGatewayFeature;
import oracle.bpm.project.model.processes.activities.EventTriggerTypeFeature;
import oracle.bpm.project.model.processes.activities.GatewayDirectionFeature;
import oracle.bpm.project.model.processes.activities.GenerateEventsFeature;
import oracle.bpm.project.model.processes.activities.LoopCharacteristicsFeature;
import oracle.bpm.project.model.processes.activities.MergingGatewayFeature;
import oracle.bpm.project.model.processes.activities.WaitForInteractionFeature;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ConversationalType;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerTrigger;
import oracle.bpm.project.model.processes.messageheaders.MessageHeaderSet;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.notification.NotificationType;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetType;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UpdateType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.ErrorEventDefinitionImpl;
import oracle.bpm.project.process.LoopImpl;
import oracle.bpm.project.process.MessageEventDefinitionImpl;
import oracle.bpm.project.process.MultiInstanceImpl;
import oracle.bpm.project.process.SignalEventDefinitionImpl;
import oracle.bpm.project.process.TerminateEventDefinitionImpl;
import oracle.bpm.project.process.TimerEventDefinitionImpl;
import oracle.bpm.project.process.conversational.ConversationalDefinitionImpl;
import oracle.bpm.project.process.conversational.ConversationalHelper;
import oracle.bpm.project.process.conversational.DefineInterfaceConversationalDefinitionImpl;
import oracle.bpm.project.process.conversational.ProcessCallConversationalDefinitionImpl;
import oracle.bpm.project.process.conversational.ServiceCallConversationalDefinitionImpl;
import oracle.bpm.project.process.conversational.UseInterfaceConversationalDefinitionImpl;
import oracle.bpm.project.process.dataassociations.InputDataAssociationSet;
import oracle.bpm.project.process.dataassociations.OutputDataAssociationSet;
import oracle.bpm.project.process.loghandler.LogHandlerSetImpl;
import oracle.bpm.project.process.messageheaders.MessageHeaderSetImpl;
import oracle.bpm.project.process.notification.IMNotificationDefinitionImpl;
import oracle.bpm.project.process.notification.MailNotificationDefinitionImpl;
import oracle.bpm.project.process.notification.NotificationDefinitionImpl;
import oracle.bpm.project.process.notification.NotificationObjectImpl;
import oracle.bpm.project.process.notification.SMSNotificationDefinitionImpl;
import oracle.bpm.project.process.notification.UserNotificationDefinitionImpl;
import oracle.bpm.project.process.notification.VoiceNotificationDefinitionImpl;
import oracle.bpm.project.process.serviceproperties.ServicePropertySetImpl;
import oracle.bpm.project.process.update.AllUserTasksUpdateTargetDefinitionImpl;
import oracle.bpm.project.process.update.DefaultUpdateDefinitionImpl;
import oracle.bpm.project.process.update.OutcomeUpdateDefinitionImpl;
import oracle.bpm.project.process.update.PriorityUpdateDefinitionImpl;
import oracle.bpm.project.process.update.ReassignUpdateDefinitionImpl;
import oracle.bpm.project.process.update.TaskIdUpdateTargetDefinitionImpl;
import oracle.bpm.project.process.update.UpdateDefinitionImpl;
import oracle.bpm.project.process.update.UpdateObjectImpl;
import oracle.bpm.project.process.update.UpdateTargetDefinitionImpl;
import oracle.bpm.project.process.update.UserTaskUpdateTargetDefinitionImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.CatchAllHelper;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityImpl
extends ProcessObjectImpl
implements Serializable,
Cloneable,
Activity,
ManualTask,
ReceiveTask,
SendTask,
ScriptTask,
UserTask,
ServiceTask,
CallActivity,
BusinessRuleTask,
NotificationTask,
UpdateTask,
Gateway,
ParallelGateway,
ExclusiveGateway,
InclusiveGateway,
EventBasedGateway,
ComplexGateway,
Event,
StartEvent,
EndEvent,
ThrowEvent,
CatchEvent,
BoundaryEvent {
    public transient int relPosition_d;
    protected NodeContainer container;
    protected LocaleStringMap description = LocaleStringMap.create();
    protected Features features;
    protected IntFeature height = IntFeature.create("height", 0);
    protected IntFeature width = IntFeature.create("width", 0);
    protected IntFeature x = IntFeature.create("x", 0);
    protected IntFeature y = IntFeature.create("y", 0);
    private BpmnType bpmntype;
    private EventDefinition definition;
    private OperationReferenceExtended operationRef = new OperationReferenceAdapter();
    private ParticipantReference participantRef = new ParticipantReferenceAdapter();
    private static final long serialVersionUID = -3614895649074258587L;
    public static final int ACTIVITY_DEFAULT_HEIGHT = 0;
    public static final int ACTIVITY_DEFAULT_WIDTH = 0;

    public ActivityImpl(Process content, NodeContainer container, BpmnType type, EventTriggerType triggerType) {
        this(content, container, type, triggerType, null);
    }

    public ActivityImpl(Process content, NodeContainer container, BpmnType type, EventTriggerType triggerType, String id) {
        super(content.getProject(), content);
        this.container = container;
        if (id == null) {
            id = ModelUtils.nextIdFor(type, this);
        }
        this.setId(id);
        this.setActivityType(type, triggerType);
        this.addModificationListener(this.x, this.y, this.width, this.height);
    }

    public static String getValidActivityName(String value) {
        int index;
        String validName = value;
        if (value.indexOf(32) != -1) {
            validName = Identifier.valid(value);
        }
        if ((index = value.indexOf(46)) != -1) {
            validName = validName.substring(0, index) + "$" + validName.substring(index + 1);
        }
        return validName;
    }

    @Override
    public void setMergeGateway(Gateway gateway) {
        this.getFeature(MergingGatewayFeature.class).setValue(gateway.getId());
    }

    @Override
    public Gateway getMergeGateway() {
        return this.getFeature(MergingGatewayFeature.class).getAssociatedNode();
    }

    @Override
    public void setReinitiate(boolean value) {
        this.getFeature(UserTaskFeature.class).setReInitiate(value);
    }

    @Override
    public ReinitiatePolicy getReinitiatePolicy() {
        return this.getFeature(UserTaskFeature.class).getReinitiatePolicy();
    }

    @Override
    public void setReinitiatePolicy(ReinitiatePolicy policy) {
        this.getFeature(UserTaskFeature.class).setReinitiatePolicy(policy);
    }

    @Override
    public boolean isManualStart() {
        return this.getFeature(UserTaskFeature.class).isManualStart();
    }

    @Override
    @Deprecated
    public void setManualStart(boolean value) {
        this.getFeature(UserTaskFeature.class).setManualStart(value);
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return this.features.getValue(clazz);
    }

    @Override
    public CatchEvent asCatchEvent() {
        ActivityImpl result = null;
        if (this.isCatchEvent()) {
            result = this;
        }
        return result;
    }

    @Override
    public ThrowEvent asThrowEvent() {
        ActivityImpl result = null;
        if (this.isThrowEvent()) {
            result = this;
        }
        return result;
    }

    @Override
    public int getX() {
        return this.x.getValue();
    }

    @Override
    public int getY() {
        return this.y.getValue();
    }

    @Override
    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public void setX(int x) {
        this.x.setValue(x);
    }

    @Override
    public void setY(int y) {
        this.y.setValue(y);
    }

    @Override
    public void setHeight(int height) {
        this.height.setValue(height);
    }

    @Override
    public int getHeight() {
        return this.height.getValue();
    }

    @Override
    public void setWidth(int width) {
        this.width.setValue(width);
    }

    @Override
    public int getWidth() {
        return this.width.getValue();
    }

    public Activity toActivity() {
        this.updateActivityType(BpmnType.ABSTRACT_ACTIVITY, null);
        return this;
    }

    @Override
    public void setLocation(@NotNull Point location) {
        this.x.setValue(location.getX());
        this.y.setValue(location.getY());
    }

    @Override
    public boolean isDeletable() {
        return ModelUtils.canDelete(this);
    }

    @Override
    public void afterAdd(ProjectObjectContainer objectContainer) throws ProjectException {
        this.container = (NodeContainer)objectContainer;
    }

    @Override
    public Sequence<SequenceFlow> getOutgoingSequenceFlows() {
        return ModelUtils.getOutgoingSequenceFlows(this);
    }

    @Override
    public Sequence<SequenceFlow> getIncomingSequenceFlows() {
        return ModelUtils.getIncomingSequenceFlows(this);
    }

    @Override
    public Sequence<ConditionalFlow> getOutgoingConditionalFlows() {
        Predicate<SequenceFlow> conditionals = new Predicate<SequenceFlow>(){

            @Override
            public boolean check(SequenceFlow sequenceFlow) {
                return sequenceFlow.isConditionalFlow();
            }
        };
        Function<SequenceFlow, ConditionalFlow> function = new Function<SequenceFlow, ConditionalFlow>(){

            @Override
            public ConditionalFlow eval(SequenceFlow sequenceFlow) {
                return sequenceFlow.asConditionalFlow();
            }
        };
        return this.getOutgoingSequenceFlows().select(conditionals).map(function);
    }

    @Override
    public Lane getLane() {
        Lane lane;
        FlowNode flowNode;
        if (this.isBoundaryEvent() && (flowNode = ModelUtils.getAssociatedFlowNode(this)) != null) {
            return flowNode.getLane();
        }
        Lane result = null;
        int parentOffset = this.getParentOffsetInLane();
        int childOffset = this.getOffsetInLane();
        int offset = Math.max(0, parentOffset) + childOffset;
        Map.Entry<Integer, Lane> entry = this.getProcessContent().getLanesInternal().floorEntry(offset);
        if (entry != null && offset - (lane = entry.getValue()).getOffset() < lane.getSize()) {
            result = lane;
        }
        return result;
    }

    @Override
    public boolean isActivity() {
        return this.getBpmnType() != null && this.getBpmnType().isActivity();
    }

    @Override
    public boolean isEvent() {
        return this.getBpmnType() != null && this.getBpmnType().isEvent();
    }

    @Override
    public boolean isGateway() {
        return this.getBpmnType() != null && this.getBpmnType().isGateway();
    }

    @Override
    public boolean isConversationMember() {
        return this.isEvent() && this.getEventTriggerType() != null && this.getEventTriggerType().equals(EventTriggerType.MESSAGE) || this.isSendTask() || this.isReceiveTask() || this.isServiceTask();
    }

    @Override
    public boolean isProcessCommunicationMember() {
        return false;
    }

    @Override
    public <T extends FlowNode> T asAnyNode(Class<T> clazz) {
        Class<? extends FlowElement> actClass = this.getBpmnType().getBpmnClass();
        if (clazz.isAssignableFrom(actClass)) {
            return (T)((FlowNode)clazz.cast(this));
        }
        return null;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ACTIVITY;
    }

    @Override
    public Class getRawClass() {
        return this.getBpmnType().getBpmnClass();
    }

    @Override
    @Nullable
    public <T extends Activity> T asActivity(Class<T> clazz) {
        BpmnType type = BPMNTypes.getBpmnTypeFor(clazz);
        if (type == this.getBpmnType()) {
            switch (type) {
                case ABSTRACT_ACTIVITY: {
                    return (T)((Activity)clazz.cast(this.toActivity()));
                }
                case CALL_ACTIVITY: {
                    return (T)((Activity)clazz.cast(this.toCallActivity()));
                }
                case RECEIVE_TASK: {
                    return (T)((Activity)clazz.cast(this.toReceiveTask()));
                }
                case SCRIPT_TASK: {
                    return (T)((Activity)clazz.cast(this.toScriptTask()));
                }
                case SEND_TASK: {
                    return (T)((Activity)clazz.cast(this.toSendTask()));
                }
                case SERVICE_TASK: {
                    return (T)((Activity)clazz.cast(this.toServiceTask()));
                }
                case SUBPROCESS: {
                    return (T)((Activity)clazz.cast(this));
                }
                case USER_TASK: {
                    return (T)((Activity)clazz.cast(this.toUserTask()));
                }
                case BUSINESS_RULE_TASK: {
                    return (T)((Activity)clazz.cast(this.toBusinessRuleTask()));
                }
                case NOTIFICATION_TASK: {
                    return (T)((Activity)clazz.cast(this.toNotificationTask()));
                }
                case UPDATE_TASK: {
                    return (T)((Activity)clazz.cast(this.toUpdateTask()));
                }
            }
        }
        return null;
    }

    @Override
    public Class<? extends Activity> getActivityClass() {
        return this.getBpmnType().getBpmnClass();
    }

    @Override
    public Sequence<BoundaryEvent> getActivityBoundaryEvents() {
        return ModelUtils.getBoundaryEventsFor(this);
    }

    @Override
    public LoopCharacteristicsType getLoopCharacteristicsType() {
        LoopCharacteristicsFeature loopCharacteristicsFeature = this.getFeature(LoopCharacteristicsFeature.class);
        return loopCharacteristicsFeature != null ? loopCharacteristicsFeature.getLoopCharacteristicsType() : null;
    }

    @Override
    public void setLoopCharacteristicsType(@NotNull LoopCharacteristicsType loopCharacteristicsType) {
        LoopCharacteristicsFeature loopCharacteristicsFeature = this.getFeature(LoopCharacteristicsFeature.class);
        if (loopCharacteristicsFeature != null) {
            loopCharacteristicsFeature.setLoopCharacteristicsType(loopCharacteristicsType);
        }
    }

    @Override
    public LoopCharacteristics getLoopCharacteristics() {
        LoopCharacteristicsFeature loopCharacteristicsFeature = this.getFeature(LoopCharacteristicsFeature.class);
        return loopCharacteristicsFeature != null ? loopCharacteristicsFeature.getLoopCharacteristics() : null;
    }

    @Override
    public LoopCharacteristics createLoopCharacteristics(@NotNull LoopCharacteristicsType type) {
        LoopCharacteristicsImpl result = null;
        if (type == LoopCharacteristicsType.LOOP) {
            result = new LoopImpl(this);
        } else if (type == LoopCharacteristicsType.MULTIINSTANCE) {
            result = new MultiInstanceImpl(this);
        }
        return result;
    }

    @Override
    public boolean isSubprocess() {
        return this.getBpmnType() == BpmnType.SUBPROCESS;
    }

    @Override
    public boolean isUserTask() {
        return this.getBpmnType() == BpmnType.USER_TASK;
    }

    @Override
    public boolean isServiceTask() {
        return this.getBpmnType() == BpmnType.SERVICE_TASK;
    }

    @Override
    public boolean isReceiveTask() {
        return this.getBpmnType() == BpmnType.RECEIVE_TASK;
    }

    @Override
    public boolean isSendTask() {
        return this.getBpmnType() == BpmnType.SEND_TASK;
    }

    @Override
    public boolean isScriptTask() {
        return this.getBpmnType() == BpmnType.SCRIPT_TASK;
    }

    @Override
    public boolean isManualTask() {
        return this.getBpmnType() == BpmnType.MANUAL_TASK;
    }

    @Override
    public boolean isBusinessRuleTask() {
        return this.getBpmnType() == BpmnType.BUSINESS_RULE_TASK;
    }

    @Override
    public boolean isCallActivity() {
        return this.getBpmnType() == BpmnType.CALL_ACTIVITY;
    }

    @Override
    public boolean isNotificationTask() {
        return this.getBpmnType() == BpmnType.NOTIFICATION_TASK;
    }

    @Override
    public boolean isUpdateTask() {
        return this.getBpmnType() == BpmnType.UPDATE_TASK;
    }

    @Override
    public void setLabelMap(LocaleStringMap label) {
        this.getLabelMap().putAll(label);
    }

    @Override
    public LocaleStringMap getLabelMap() {
        if (this.label == null) {
            this.label = ActivityLocaleStringMap.create(this);
            ((ActivityLocaleStringMap)this.label).addModificationListener(new ModificationListener<ProjectObject>(){

                @Override
                public void objectModified(ModificationEvent<ProjectObject> event) {
                    ActivityImpl.this.fireObjectChanged(ActivityImpl.this, ProjectEvent.CHANGE(ActivityImpl.this));
                }
            });
        }
        return this.label;
    }

    @Override
    public void setDescription(LocaleStringMap description) {
        this.description = description;
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public String toString() {
        return this.getLabelMap().getString();
    }

    @Override
    public void setLane(Lane lane) {
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = this.getParentObject().getPath().create(this.getId());
        }
        return this.path;
    }

    @Override
    public Activity toAbstract() {
        this.updateActivityType(BpmnType.ABSTRACT_ACTIVITY, null);
        return this;
    }

    @Override
    public UserTask toUserTask() {
        this.updateActivityType(BpmnType.USER_TASK, null);
        return this;
    }

    @Override
    public ServiceTask toServiceTask() {
        this.updateActivityType(BpmnType.SERVICE_TASK, null);
        return this;
    }

    @Override
    public ReceiveTask toReceiveTask() {
        this.updateActivityType(BpmnType.RECEIVE_TASK, null);
        return this;
    }

    @Override
    public BusinessRuleTask toBusinessRuleTask() {
        this.updateActivityType(BpmnType.BUSINESS_RULE_TASK, null);
        return this;
    }

    @Override
    public ManualTask toManualTask() {
        this.updateActivityType(BpmnType.MANUAL_TASK, null);
        return this;
    }

    @Override
    public SendTask toSendTask() {
        this.updateActivityType(BpmnType.SEND_TASK, null);
        return this;
    }

    @Override
    public ScriptTask toScriptTask() {
        this.updateActivityType(BpmnType.SCRIPT_TASK, null);
        return this;
    }

    @Override
    public Subprocess toSubprocess() {
        return null;
    }

    @Override
    public CallActivity toCallActivity() {
        this.updateActivityType(BpmnType.CALL_ACTIVITY, null);
        return this;
    }

    @Override
    public ParallelGateway toParallel() {
        this.updateActivityType(BpmnType.PARALLEL_GATEWAY, null);
        return this;
    }

    @Override
    public ExclusiveGateway toExclusive() {
        this.updateActivityType(BpmnType.EXCLUSIVE_GATEWAY, null);
        return this;
    }

    @Override
    public InclusiveGateway toInclusive() {
        this.updateActivityType(BpmnType.INCLUSIVE_GATEWAY, null);
        return this;
    }

    @Override
    public EventBasedGateway toEventBased() {
        this.updateActivityType(BpmnType.EVENT_BASED_GATEWAY, null);
        return this;
    }

    @Override
    public ComplexGateway toComplexGateway() {
        this.updateActivityType(BpmnType.COMPLEX_GATEWAY, null);
        return this;
    }

    @Override
    public NotificationTask toNotificationTask() {
        this.updateActivityType(BpmnType.NOTIFICATION_TASK, null);
        return this;
    }

    @Override
    public UpdateTask toUpdateTask() {
        this.updateActivityType(BpmnType.UPDATE_TASK, null);
        return this;
    }

    @Override
    public void setDirection(GatewayDirection gatewayDirection) {
        GatewayDirectionFeature gatewayDirectionFeature = this.getFeature(GatewayDirectionFeature.class);
        gatewayDirectionFeature.setValue(gatewayDirection);
    }

    @Override
    public BpmnType getBpmnType() {
        return this.bpmntype;
    }

    @Override
    public GatewayDirection getDirection() {
        return (GatewayDirection)this.getFeature(GatewayDirectionFeature.class).getValue();
    }

    @Override
    public void setMergingGateway(Gateway gateway) {
        ModelUtils.setPairedAssociatedGateways(this, gateway);
    }

    @Override
    @Nullable
    public Gateway getMergingGateway() {
        FlowNode node = ModelUtils.getAssociatedFlowNode(this);
        return node != null ? node.asAnyNode(Gateway.class) : null;
    }

    @Override
    public boolean isAbortPendingFlows() {
        ComplexGatewayFeature feature = this.getFeature(ComplexGatewayFeature.class);
        return feature.isAbortPendingFlows();
    }

    @Override
    public void setAbortPendingFlows(boolean abort) {
        ComplexGatewayFeature feature = this.getFeature(ComplexGatewayFeature.class);
        feature.setAbortPendingFlows(abort);
    }

    @Override
    public ThrowEvent toThrow(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.THROW_INTERMEDIATE_EVENT, triggerType);
        return this;
    }

    @Override
    public CatchEvent toCatch(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.CATCH_INTERMEDIATE_EVENT, triggerType);
        return this;
    }

    @Override
    public StartEvent toStart(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.START_EVENT, triggerType);
        return this;
    }

    @Override
    public void setBoundaryActivity(Activity act) {
        ModelUtils.setAssociatedFlowNodes(this, act);
    }

    @Override
    public EndEvent toEnd(EventTriggerType triggerType) {
        this.updateActivityType(BpmnType.END_EVENT, triggerType);
        this.setEventTriggerType(triggerType);
        return this;
    }

    @Override
    public void setEventTriggerType(EventTriggerType triggerType) {
        EventTriggerTypeFeature eventTriggerTypeFeature = this.getFeature(EventTriggerTypeFeature.class);
        EventTriggerType value = (EventTriggerType)eventTriggerTypeFeature.getValue();
        eventTriggerTypeFeature.setValue(triggerType);
        if (triggerType != null && value != triggerType) {
            this.updateFeatures(triggerType);
            this.updateEventDefinition(triggerType);
            this.clearDataAssociations();
            this.clearCorrelations();
        }
    }

    @Override
    @Nullable
    public EventDefinition getEventDefinition() {
        return this.definition;
    }

    @Override
    public EventTriggerType getEventTriggerType() {
        EventTriggerTypeFeature triggerTypeFeature = this.getFeature(EventTriggerTypeFeature.class);
        return triggerTypeFeature != null ? (EventTriggerType)triggerTypeFeature.getValue() : null;
    }

    @Override
    public boolean isCatchEvent() {
        return this.getBpmnType() == BpmnType.CATCH_INTERMEDIATE_EVENT || this.getBpmnType() == BpmnType.START_EVENT || this.getBpmnType() == BpmnType.BOUNDARY_EVENT;
    }

    @Override
    public boolean isThrowEvent() {
        return this.getBpmnType() == BpmnType.THROW_INTERMEDIATE_EVENT || this.getBpmnType() == BpmnType.END_EVENT;
    }

    @Override
    public boolean isStart() {
        return this.getBpmnType() == BpmnType.START_EVENT;
    }

    @Override
    public boolean isIntermediate() {
        return this.getBpmnType() == BpmnType.CATCH_INTERMEDIATE_EVENT || this.getBpmnType() == BpmnType.THROW_INTERMEDIATE_EVENT;
    }

    @Override
    @Nullable
    public <T extends Gateway> T asGateway(Class<T> clazz) {
        BpmnType type = BPMNTypes.getBpmnTypeFor(clazz);
        if (type == this.getBpmnType()) {
            switch (type) {
                case COMPLEX_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toComplexGateway()));
                }
                case EXCLUSIVE_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toExclusive()));
                }
                case INCLUSIVE_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toInclusive()));
                }
                case PARALLEL_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toParallel()));
                }
                case EVENT_BASED_GATEWAY: {
                    return (T)((Gateway)clazz.cast(this.toEventBased()));
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Activity getBoundaryActivity() {
        FlowNode node = ModelUtils.getAssociatedFlowNode(this);
        return node != null ? node.asAnyNode(Activity.class) : null;
    }

    @Override
    public void setInstantiate(boolean instantiate) {
        this.getFeature(InstantiateFeature.class).setValue(instantiate);
    }

    @Override
    public void setType(EventBasedGatewayType type) {
        this.getFeature(EventBasedGatewayTypeFeature.class).setValue(type);
    }

    @Override
    public EventBasedGatewayType getType() {
        return (EventBasedGatewayType)((Object)this.getFeature(EventBasedGatewayTypeFeature.class).getValue());
    }

    @Override
    public boolean isInstantiate() {
        InstantiateFeature feature = this.getFeature(InstantiateFeature.class);
        return feature != null ? feature.getValue() : false;
    }

    @Override
    public void setCancelActivity(boolean cancel) {
        this.setIsInterrupting(cancel);
    }

    @Override
    public boolean cancelActivity() {
        return this.isInterrupting();
    }

    @Override
    public void setIsInterrupting(boolean isInterrupting) {
        this.getFeature(IsInterruptingFeature.class).setValue(isInterrupting);
    }

    @Override
    public boolean isInterrupting() {
        return this.getEventTriggerType() == EventTriggerType.ERROR || this.getFeature(IsInterruptingFeature.class).getValue() != false;
    }

    @Override
    public String getOperationName() {
        String result = null;
        CatalogMember operation = this.getOperation();
        if (operation != null) {
            result = operation.getName();
        }
        return result;
    }

    @Override
    public CatalogMember getOperation() {
        CatalogMember result = null;
        CatalogMember function = this.getFunction();
        if (function != null) {
            result = function;
        } else {
            Conversation conversation;
            CatalogMember invokeMethod = this.getInvokeMethod();
            if (invokeMethod != null) {
                result = invokeMethod;
            } else if (this.isConversational() && (conversation = this.getConversation()) != null) {
                ConversationType conversationType = conversation.getConversationType();
                if (conversationType == ConversationType.SERVICE_CALL) {
                    ServiceCallConversationalDefinition definition = this.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                    result = definition.getOperation();
                } else if (conversationType == ConversationType.USE_INTERFACE) {
                    UseInterfaceConversationalDefinition definition = this.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                    result = definition.getOperation();
                }
            }
        }
        return result;
    }

    @Override
    public void setOperationName(String operationName) {
    }

    @Override
    public CatalogObject getParticipant() {
        CatalogObject result = null;
        BusinessRule businessRule = this.getBusinessRule();
        if (businessRule != null) {
            result = businessRule;
        } else {
            Conversation conversation;
            HumanTask humanTask = this.getHumanTask();
            if (humanTask != null) {
                result = humanTask;
            } else if (this.isConversational() && (conversation = this.getConversation()) != null) {
                ConversationType conversationType = conversation.getConversationType();
                if (conversationType == ConversationType.SERVICE_CALL) {
                    ServiceCallConversationalDefinition definition = this.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                    result = definition.getService();
                } else if (conversationType == ConversationType.USE_INTERFACE) {
                    UseInterfaceConversationalDefinition definition = this.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                    result = definition.getReference();
                }
            }
        }
        return result;
    }

    @Override
    public DataAssociationSet getOutputDataAssociationSet() {
        boolean draft = this.isDraft();
        return this.getFeature(OutputDataAssociationFeature.class) != null ? this.getFeature(OutputDataAssociationFeature.class).getDataAssociationSet(draft) : null;
    }

    @Override
    public String getParticipantName() {
        String result = null;
        CatalogObject participant = this.getParticipant();
        if (participant != null) {
            result = participant.getName();
        }
        return result;
    }

    @Override
    public void setScript(String code) {
        this.getFeature(ScriptTaskFeature.class).setScript(code);
    }

    @Override
    public String getScript() {
        return this.getFeature(ScriptTaskFeature.class).getScript();
    }

    @Override
    public void setSubject(Expression subject) {
        this.getFeature(UserTaskFeature.class).setSubject(subject);
    }

    @Override
    public Expression getSubject() {
        return this.getFeature(UserTaskFeature.class).getSubject();
    }

    @Override
    public void setPriority(Expression priority) {
        this.getFeature(UserTaskFeature.class).setPriority(priority);
    }

    @Override
    public Expression getPriority() {
        return this.getFeature(UserTaskFeature.class).getPriority();
    }

    @Override
    public void setInitiator(Expression initiator) {
        this.getFeature(UserTaskFeature.class).setInitiator(initiator);
    }

    @Override
    public Expression getInitiator() {
        return this.getFeature(UserTaskFeature.class).getInitiator();
    }

    @Override
    public void setOwner(Expression owner) {
        this.getFeature(UserTaskFeature.class).setOwner(owner);
    }

    @Override
    public Expression getOwner() {
        return this.getFeature(UserTaskFeature.class).getOwner();
    }

    @Override
    public void setIdentificationKey(Expression idKey) {
        this.getFeature(UserTaskFeature.class).setIdentificationKey(idKey);
    }

    @Override
    public Expression getIdentificationKey() {
        return this.getFeature(UserTaskFeature.class).getIdentificationKey();
    }

    @Override
    public void setIdentificationContext(Expression idContext) {
        this.getFeature(UserTaskFeature.class).setIdentificationContext(idContext);
    }

    @Override
    public Expression getIdentificationContext() {
        return this.getFeature(UserTaskFeature.class).getIdentificationContext();
    }

    @Override
    public void setApplicationContext(Expression appContext) {
        this.getFeature(UserTaskFeature.class).setApplicationContext(appContext);
    }

    @Override
    public Expression getApplicationContext() {
        return this.getFeature(UserTaskFeature.class).getApplicationContext();
    }

    @Override
    public void setHumanTask(HumanTask humanTask) {
        if (ModelUtils.isSameObjectId(this.getHumanTask(), humanTask)) {
            return;
        }
        this.getFeature(UserTaskFeature.class).setHumanTask(humanTask);
        this.clearDataAssociations();
    }

    @Override
    public HumanTask getHumanTask() {
        UserTaskFeature userTaskFeature = this.getFeature(UserTaskFeature.class);
        return userTaskFeature != null ? userTaskFeature.getHumanTask() : null;
    }

    @Override
    public CatalogMember getInvokeMethod() {
        UserTaskFeature userTaskFeature = this.getFeature(UserTaskFeature.class);
        return userTaskFeature != null ? userTaskFeature.getInvokeMethod() : null;
    }

    @Override
    public void setHumanTaskType(HumanTaskType humanTaskType) {
        UserTaskFeature userTaskFeature = this.getFeature(UserTaskFeature.class);
        if (userTaskFeature != null) {
            userTaskFeature.setHumanTaskType(humanTaskType != null ? humanTaskType : HumanTaskType.DEFAULT);
        }
    }

    @Override
    public HumanTaskType getHumanTaskType() {
        UserTaskFeature userTaskFeature = this.getFeature(UserTaskFeature.class);
        return userTaskFeature != null ? userTaskFeature.getHumanTaskType() : null;
    }

    @Override
    public boolean isReinitiate() {
        return this.getFeature(UserTaskFeature.class).isReInitiateFeature();
    }

    @Override
    public DataAssociationSet getInputDataAssociationSet() {
        boolean draft = this.isDraft();
        return this.getFeature(InputDataAssociationFeature.class) != null ? this.getFeature(InputDataAssociationFeature.class).getDataAssociationSet(draft) : null;
    }

    @Override
    public ServicePropertySet getInputServicePropertySet() {
        return this.getFeature(InputServicePropertySetFeature.class) != null ? this.getFeature(InputServicePropertySetFeature.class).getValue() : null;
    }

    @Override
    public ServicePropertySet getOutputServicePropertySet() {
        return this.getFeature(OutputServicePropertySetFeature.class) != null ? this.getFeature(OutputServicePropertySetFeature.class).getValue() : null;
    }

    @Override
    public boolean isMessageHeadersEnabled() {
        return this.isInputMessageHeadersEnable() || this.isOutputMessageHeadersEnable();
    }

    @Override
    public boolean isInputMessageHeadersEnable() {
        return this.getFeature(InputMessageHeaderSetFeature.class) != null;
    }

    @Override
    public boolean isOutputMessageHeadersEnable() {
        return this.getFeature(OutputMessageHeaderSetFeature.class) != null;
    }

    @Override
    public MessageHeaderSet createMessageHeaderSet() {
        return new MessageHeaderSetImpl(this);
    }

    @Override
    public MessageHeaderSet getInputMessageHeaderSet() {
        return this.isInputMessageHeadersEnable() ? this.getFeature(InputMessageHeaderSetFeature.class).getValue() : null;
    }

    @Override
    public MessageHeaderSet getOutputMessageHeaderSet() {
        return this.isOutputMessageHeadersEnable() ? this.getFeature(OutputMessageHeaderSetFeature.class).getValue() : null;
    }

    @Override
    public Process getCalledElement() {
        String processName;
        Process result = null;
        if (this.getFeature(RelatedProcessNameFeature.class) != null && (processName = this.getFeature(RelatedProcessNameFeature.class).getValue()) != null) {
            result = this.getProcess().getProject().findProcess(processName);
        }
        return result;
    }

    @Override
    public void setCalledElement(Process callableSubprocess) {
        if (ModelUtils.isSameObjectId(this.getCalledElement(), callableSubprocess)) {
            return;
        }
        if (this.getFeature(RelatedProcessNameFeature.class) != null) {
            String value = callableSubprocess != null ? callableSubprocess.getId() : null;
            this.getFeature(RelatedProcessNameFeature.class).setValue(value);
            this.clearDataAssociations();
        }
    }

    @Override
    public String getCalledElementName() {
        return this.getFeature(RelatedProcessNameFeature.class).getValue();
    }

    @Override
    public void setCalledElementName(String callableSubprocessName) {
        this.getFeature(RelatedProcessNameFeature.class).setValue(callableSubprocessName);
    }

    @Override
    public void setParticipant(CatalogObject service) {
    }

    @Override
    public void setOperation(CatalogMember operation) {
    }

    @Override
    public ParticipantReference getParticipantRef() {
        return this.participantRef;
    }

    @Override
    public BoundaryEvent toBoundary(EventTriggerType triggerType, Activity relatedActivity) {
        this.updateActivityType(BpmnType.BOUNDARY_EVENT, triggerType);
        this.setEventTriggerType(triggerType);
        if (relatedActivity != null) {
            ModelUtils.setAssociatedFlowNodes(this, relatedActivity);
        }
        return this;
    }

    @Override
    public boolean isBoundaryEvent() {
        return this.getBpmnType() == BpmnType.BOUNDARY_EVENT;
    }

    public ActivityType getActivityType() {
        return null;
    }

    public void setActivityType(BpmnType type, EventTriggerType triggerType) {
        String defaultLabel = this.getDefaultLabel();
        String validId = this.getBpmnType() != null ? Identifier.valid(this.bpmntype.getString()) : "";
        boolean changeLabel = false;
        boolean sameType = Any.equals(this.bpmntype, type);
        boolean usesDefault = false;
        if (validId != null && defaultLabel.startsWith(validId)) {
            if (defaultLabel.equals(validId)) {
                usesDefault = true;
            } else {
                String s2 = defaultLabel.substring(validId.length());
                try {
                    Integer.parseInt(s2);
                    usesDefault = true;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (defaultLabel != null && usesDefault && !sameType) {
            changeLabel = true;
        }
        if (!sameType || !Any.equals(triggerType, this.getEventTriggerType())) {
            this.bpmntype = type;
            this.updateFeatures(triggerType);
            if (triggerType != null) {
                this.updateEventDefinition(triggerType);
            }
            if (changeLabel) {
                this.setDefaultLabel(ModelUtils.generateDefaultLabel(this));
            }
            if (this.isConversational()) {
                this.setConversation(null);
            }
            this.clearDataAssociations();
            this.clearCorrelations();
        }
    }

    public FlowNode getActivity() {
        return this;
    }

    @Override
    public NodeContainer getParentObject() {
        return this.container;
    }

    @Override
    public void setBusinessRule(BusinessRule rule) {
        BusinessRuleTaskFeature feature = this.getFeature(BusinessRuleTaskFeature.class);
        if (feature != null) {
            feature.setBusinessRule(rule);
        }
    }

    @Override
    public String getBusinessRuleName() {
        return this.getParticipantName();
    }

    @Override
    public String getBusinessRuleNativeName() {
        return this.getBusinessRule().getDelegate().asSchemaObject().getName();
    }

    @Override
    public String getFunctionName() {
        String result = null;
        CatalogMember function = this.getFunction();
        if (function != null) {
            result = function.getName();
        }
        return result;
    }

    @Override
    public BusinessRule getBusinessRule() {
        BusinessRule result = null;
        BusinessRuleTaskFeature feature = this.getFeature(BusinessRuleTaskFeature.class);
        if (feature != null) {
            result = feature.getBusinessRule();
        }
        return result;
    }

    @Override
    public void setFunction(CatalogMember function) {
        BusinessRuleTaskFeature feature = this.getFeature(BusinessRuleTaskFeature.class);
        if (feature != null) {
            feature.setFunction(function);
        }
    }

    @Override
    public CatalogMember getFunction() {
        CatalogMember result = null;
        BusinessRuleTaskFeature feature = this.getFeature(BusinessRuleTaskFeature.class);
        if (feature != null) {
            result = feature.getFunction();
        }
        return result;
    }

    @Override
    public OperationReferenceExtended getOperationRef() {
        return this.operationRef;
    }

    @Override
    public boolean isAdjustable() {
        return !ModelUtils.isBoundaryEvent(this);
    }

    @Override
    public FlowNode copy() {
        ActivityImpl result = new ActivityImpl(this.getProcess(), this.getParentObject(), this.getBpmnType(), this.getEventTriggerType(), this.getId());
        ActivityImpl.copy(this, result);
        return result;
    }

    @Override
    public void applyFrom(FlowNode flowNode) throws ProjectException {
        if (!this.getBpmnType().getInnerType().equals((Object)flowNode.getBpmnType().getInnerType())) {
            throw new ProjectException(this, Msg.QUOTE("Flow Node is incompatible"));
        }
        if (flowNode.isEvent()) {
            Event event = (Event)flowNode;
            this.setActivityType(flowNode.getBpmnType(), event.getEventTriggerType());
            if (event.getEventDefinition() != null) {
                this.definition = event.getEventDefinition();
            }
        } else {
            this.setActivityType(flowNode.getBpmnType(), null);
        }
        ActivityImpl.copy(flowNode, this);
    }

    @Override
    public ActivityGenerateEvents getGenerateEvents() {
        return (ActivityGenerateEvents)this.getFeature(GenerateEventsFeature.class).getValue();
    }

    @Override
    public void setGenerateEvents(ActivityGenerateEvents generateEvents) {
        this.getFeature(GenerateEventsFeature.class).setValue(generateEvents);
    }

    @Override
    @Nullable
    public Subprocess getSubprocess() {
        NodeContainer parentObject = this.getParentObject();
        return parentObject != null && !parentObject.equals(this.getProcess()) ? (Subprocess)parentObject : null;
    }

    @Override
    public boolean isEnd() {
        return this.getBpmnType() == BpmnType.END_EVENT;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        if (this.isActivity()) {
            visitor.visit(this);
        } else if (this.isBoundaryEvent()) {
            visitor.visit(this);
        } else if (this.isEvent()) {
            visitor.visit((Event)this);
        } else if (this.isGateway()) {
            visitor.visit(this);
        } else {
            visitor.visit((FlowNode)this);
        }
    }

    @Override
    public Expression getActivationCondition() {
        return this.getFeature(ExpressionFeature.class).getValue();
    }

    @Override
    public void setActivationCondition(Expression expression) {
        this.getFeature(ExpressionFeature.class).setValue(expression);
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotations(visible);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getFeature(AnnotationsFeature.class).addAnnotation(key, value, visible);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getFeature(AnnotationsFeature.class).removeAnnotation(key, visible);
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        return PredefinedVariablesHelper.getPredefinedVariablesForProjectObject(this, this);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return this.getParentObject();
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return DataDeclarationImpl.findDeclarationPath(this, path);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return false;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public ConversationEnabled getConversationInitiator() {
        return null;
    }

    @Override
    public void setConversationInitiator(@Nullable ConversationEnabled initiator) {
    }

    @Override
    public boolean isSync() {
        return false;
    }

    @Override
    public boolean isConversationInitiator() {
        return false;
    }

    @Override
    public void setSync(boolean sync) {
    }

    @Override
    @Nullable
    public String getDefinedOperationName() {
        return null;
    }

    @Override
    public void setDefinedOperationName(@Nullable String operationName) {
    }

    @Override
    @Nullable
    public Process getAssociatedProcess() {
        return null;
    }

    @Override
    public void setAssociatedProcess(@Nullable Process process) {
    }

    @Override
    @Nullable
    public ConversationEnabled getAssociatedNode() {
        return null;
    }

    @Override
    public void setAssociatedNode(@Nullable ConversationEnabled node) {
    }

    @Override
    public ErrorObject getAssociatedError() {
        return null;
    }

    @Override
    public void setAssociatedError(ErrorObject error) {
    }

    public boolean waitForInteraction() {
        WaitForInteractionFeature feature = this.getFeature(WaitForInteractionFeature.class);
        return feature != null && feature.getValue() != false;
    }

    @Override
    public DataDeclarationContainer getOutputArgumentsContainer() {
        DataDeclarationContainer result = null;
        if (this.isOutputArgumentsEnabled()) {
            if (this.isSubprocess()) {
                OutputArgumentsFeature feature = this.getFeature(OutputArgumentsFeature.class);
                if (feature != null) {
                    result = feature.getCustomArgumentsContainer();
                }
            } else if (this.isConversational()) {
                result = ConversationalHelper.getArgumentsContainer(this, false);
            } else if (this.getInvokeMethod() != null) {
                result = this.getInvokeMethod().getOutputArgumentsContainer();
            } else if (this.getFunction() != null) {
                result = this.getFunction().getOutputArgumentsContainer();
            } else if (this.getCalledElement() != null) {
                Process process = this.getCalledElement();
                result = process.getOutputArgumentsContainer();
            } else if (this.getParentObject() == this.getProcess() && this.getProcess().isCallableSubprocess() && this.isStart() && this.getEventTriggerType() == EventTriggerType.NONE) {
                result = this.getProcess().getInputArgumentsContainer();
            } else if (this.getEventDefinition() != null) {
                result = this.createEventDefinitionPayloadContainer(this, this.getEventDefinition(), this.getEventTriggerType(), AccessType.OUT);
            }
            if (result == null) {
                result = new EmptyDataDeclarationContainer(this.getProject());
            }
        }
        return result;
    }

    @Override
    public DataDeclarationContainer getInputArgumentsContainer() {
        DataDeclarationContainer result = null;
        if (this.isInputArgumentsEnabled()) {
            if (this.isSubprocess()) {
                InputArgumentsFeature feature = this.getFeature(InputArgumentsFeature.class);
                if (feature != null) {
                    result = feature.getCustomArgumentsContainer();
                }
            } else if (this.isConversational()) {
                result = ConversationalHelper.getArgumentsContainer(this, true);
            } else if (this.isNotificationTask()) {
                NotificationFeature notificationFeature = this.getFeature(NotificationFeature.class);
                result = notificationFeature.getNotificationArguments();
            } else if (this.isUpdateTask()) {
                UpdateFeature updateFeature = this.getFeature(UpdateFeature.class);
                result = updateFeature.getUpdateArguments();
            } else if (this.getInvokeMethod() != null) {
                result = this.getInvokeMethod().getInputArgumentsContainer();
            } else if (this.getFunction() != null) {
                result = this.getFunction().getInputArgumentsContainer();
            } else if (this.getCalledElement() != null) {
                Process process = this.getCalledElement();
                result = process.getInputArgumentsContainer();
            } else if (this.getParentObject() == this.getProcess() && this.getProcess().isCallableSubprocess() && this.isEnd() && this.getEventTriggerType() == EventTriggerType.NONE) {
                result = this.getProcess().getOutputArgumentsContainer();
            } else if (this.getEventDefinition() != null) {
                result = this.createEventDefinitionPayloadContainer(this, this.getEventDefinition(), this.getEventTriggerType(), AccessType.IN);
            }
            if (result == null) {
                result = new EmptyDataDeclarationContainer(this.getProject());
            }
        }
        return result;
    }

    @Override
    public boolean isInputArgumentsEnabled() {
        return this.getFeature(InputArgumentsFeature.class) != null;
    }

    @Override
    public boolean isOutputArgumentsEnabled() {
        return this.getFeature(OutputArgumentsFeature.class) != null;
    }

    @Override
    public DataDeclarationContainer createArgumentsContainer() {
        return new ProcessArgumentContainer(this);
    }

    @Override
    public void setReinitiateSource(UserTask source) {
        this.getFeature(UserTaskFeature.class).setReinitiateSource(source);
    }

    @Override
    public UserTask getReinitiateSource() {
        return this.getFeature(UserTaskFeature.class).getReinitiateSource();
    }

    @Override
    public CorrelationItemsContainer getInputCorrelationsContainer() {
        CorrelationItemsContainer result = null;
        InputCorrelationItemsFeature feature = this.getFeature(InputCorrelationItemsFeature.class);
        if (feature != null) {
            result = feature.getValue();
        }
        return result;
    }

    @Override
    public CorrelationItemsContainer getOutputCorrelationsContainer() {
        CorrelationItemsContainer result = null;
        OutputCorrelationItemsFeature feature = this.getFeature(OutputCorrelationItemsFeature.class);
        if (feature != null) {
            result = feature.getValue();
        }
        return result;
    }

    @Override
    @Nullable
    public <T extends CorrelationsEnabled> T as(Class<T> clazz) {
        CorrelationsEnabled retVal = null;
        if (clazz.isAssignableFrom(this.getClass())) {
            retVal = (CorrelationsEnabled)clazz.cast(this);
        }
        return (T)retVal;
    }

    @Override
    public boolean isInputCorrelationsEnabled() {
        return this.getFeature(InputCorrelationItemsFeature.class) != null && !this.getInputArgumentsContainer().getDeclarations().isEmpty();
    }

    @Override
    public boolean isOutputCorrelationsEnabled() {
        return this.getFeature(OutputCorrelationItemsFeature.class) != null && !this.getOutputArgumentsContainer().getDeclarations().isEmpty();
    }

    @Override
    public boolean hasSameCorrelationMessage() {
        return this.getProject() != null && this.getProject().hasSameCorrelationMessage(this);
    }

    @Override
    public boolean mustSplitCorrelationParts() {
        boolean result = true;
        if (this.isConversational()) {
            ConversationType conversationType;
            Conversational conversational = this.asAnyNode(Conversational.class);
            Conversation conversation = conversational.getConversation();
            if (conversation != null && ((conversationType = conversation.getConversationType()) == ConversationType.DEFINE_INTERFACE || conversationType == ConversationType.PROCESS_CALL)) {
                result = false;
            }
        } else if (this.isUserTask()) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasCorrelations() {
        return this.isInputCorrelationsEnabled() && !this.getInputCorrelationsContainer().getCorrelationItems().isEmpty() || this.isOutputCorrelationsEnabled() && !this.getOutputCorrelationsContainer().getCorrelationItems().isEmpty();
    }

    @Override
    public CorrelationItemsContainer createInputCorrelationItemsContainer() {
        return new InputCorrelationItemsContainerImpl(this);
    }

    @Override
    public CorrelationItemsContainer createOutputCorrelationItemsContainer() {
        return new OutputCorrelationItemsContainerImpl(this);
    }

    @Override
    public NotificationType getNotificationType() {
        NotificationType result = null;
        NotificationFeature notificationFeature = this.getFeature(NotificationFeature.class);
        if (notificationFeature != null) {
            result = notificationFeature.getNotificationType();
        }
        return result;
    }

    @Override
    public void setNotificationType(@NotNull NotificationType type) {
        boolean typeChanged;
        NotificationFeature notificationFeature = this.getFeature(NotificationFeature.class);
        if (notificationFeature != null && (typeChanged = notificationFeature.setNotificationType(type))) {
            this.clearDataAssociations();
        }
    }

    @Override
    public NotificationDefinition getNotificationDefinition() {
        NotificationDefinition result = null;
        NotificationFeature notificationFeature = this.getFeature(NotificationFeature.class);
        if (notificationFeature != null) {
            result = notificationFeature.getNotificationDefinition();
        }
        return result;
    }

    @Override
    public NotificationDefinition createNotificationDefinition(@NotNull NotificationType type) {
        NotificationDefinitionImpl result = null;
        if (type == NotificationType.MAIL) {
            result = new MailNotificationDefinitionImpl(this);
        } else if (type == NotificationType.USER) {
            result = new UserNotificationDefinitionImpl(this);
        } else if (type == NotificationType.SMS) {
            result = new SMSNotificationDefinitionImpl(this);
        } else if (type == NotificationType.IM) {
            result = new IMNotificationDefinitionImpl(this);
        } else if (type == NotificationType.VOICE) {
            result = new VoiceNotificationDefinitionImpl(this);
        }
        return result;
    }

    @Override
    public NotificationObject createNotificationObject() {
        NotificationObjectImpl result = null;
        Project project = this.getProject();
        if (project != null) {
            ComponentCatalog catalog = project.getComponentCatalog();
            TypeDescription notificationServiceType = NotificationServiceHelper.createNotificationService((ComponentCatalog)catalog);
            result = new NotificationObjectImpl(project, notificationServiceType);
        }
        return result;
    }

    @Override
    public UpdateType getUpdateType() {
        UpdateType result = null;
        UpdateFeature updateFeature = this.getFeature(UpdateFeature.class);
        if (updateFeature != null) {
            result = updateFeature.getUpdateType();
        }
        return result;
    }

    @Override
    public void setUpdateType(@NotNull UpdateType type) {
        boolean typeChanged;
        UpdateFeature updateFeature = this.getFeature(UpdateFeature.class);
        if (updateFeature != null && (typeChanged = updateFeature.setUpdateType(type))) {
            this.clearDataAssociations();
        }
    }

    @Override
    public UpdateDefinition getUpdateDefinition() {
        UpdateDefinition result = null;
        UpdateFeature updateFeature = this.getFeature(UpdateFeature.class);
        if (updateFeature != null) {
            result = updateFeature.getUpdateDefinition();
        }
        return result;
    }

    @Override
    public UpdateTargetType getUpdateTargetType() {
        UpdateTargetType result = null;
        UpdateFeature updateFeature = this.getFeature(UpdateFeature.class);
        if (updateFeature != null) {
            result = updateFeature.getUpdateTargetType();
        }
        return result;
    }

    @Override
    public void setUpdateTargetType(@NotNull UpdateTargetType type) {
        UpdateFeature updateFeature = this.getFeature(UpdateFeature.class);
        if (updateFeature != null) {
            updateFeature.setUpdateTargetType(type);
        }
    }

    @Override
    public UpdateTargetDefinition getUpdateTargetDefinition() {
        UpdateTargetDefinition result = null;
        UpdateFeature updateFeature = this.getFeature(UpdateFeature.class);
        if (updateFeature != null) {
            result = updateFeature.getUpdateTargetDefinition();
        }
        return result;
    }

    @Override
    public UpdateObject createUpdateObject() {
        UpdateObjectImpl result = null;
        Project project = this.getProject();
        if (project != null) {
            TypeDescription notificationServiceType = TaskManagementServiceHelper.createTaskManagementService();
            result = new UpdateObjectImpl(project, notificationServiceType);
        }
        return result;
    }

    @Override
    public UpdateDefinition createUpdateDefinition(@NotNull UpdateType type) {
        UpdateDefinitionImpl result = type == UpdateType.UPDATE_OUTCOME ? new OutcomeUpdateDefinitionImpl(this) : (type == UpdateType.UPDATE_PRIORITY ? new PriorityUpdateDefinitionImpl(this) : (type == UpdateType.REASSIGN ? new ReassignUpdateDefinitionImpl(this) : new DefaultUpdateDefinitionImpl(this)));
        return result;
    }

    @Override
    public UpdateTargetDefinition createUpdateTargetDefinition(@NotNull UpdateTargetType type) {
        UpdateTargetDefinitionImpl result = null;
        if (type == UpdateTargetType.USER_TASK) {
            result = new UserTaskUpdateTargetDefinitionImpl(this);
        } else if (type == UpdateTargetType.ALL_USER_TASKS) {
            result = new AllUserTasksUpdateTargetDefinitionImpl(this);
        } else if (type == UpdateTargetType.TASK_ID) {
            result = new TaskIdUpdateTargetDefinitionImpl(this);
        }
        return result;
    }

    @Override
    public boolean isInputDataAssociationEnabled() {
        return this.getFeature(InputDataAssociationFeature.class) != null;
    }

    @Override
    public boolean isOutputDataAssociationEnabled() {
        return this.getFeature(OutputDataAssociationFeature.class) != null;
    }

    @Override
    public LogHandlerSet getLogHandlerSet() {
        LogHandlerSet result = null;
        LoggableFeature logHandlerSetFeature = this.getFeature(LoggableFeature.class);
        if (logHandlerSetFeature != null) {
            result = logHandlerSetFeature.getLogHandlerSet();
        }
        return result;
    }

    @Override
    public Sequence<LogHandlerTrigger> getAvailableLogHandlerTriggers() {
        Sequence result = null;
        if (this.isLoggable()) {
            ArrayList<LogHandlerTrigger> list = new ArrayList<LogHandlerTrigger>();
            if (this.getLoopCharacteristicsType() == LoopCharacteristicsType.LOOP) {
                list.add(LogHandlerTrigger.BEFORE_ITERATION);
            } else if (this.getLoopCharacteristicsType() == LoopCharacteristicsType.MULTIINSTANCE) {
                list.add(LogHandlerTrigger.AFTER_INSTANCE_EXECUTION);
                list.add(LogHandlerTrigger.BEFORE_INSTANCE_EXECUTION);
            } else {
                if (this.getInputDataAssociationSet() != null) {
                    list.add(LogHandlerTrigger.BEFORE_INPUT_DATA_ASSOCIATION);
                    list.add(LogHandlerTrigger.AFTER_INPUT_DATA_ASSOCIATION);
                }
                if (this.getOutputDataAssociationSet() != null) {
                    list.add(LogHandlerTrigger.BEFORE_OUTPUT_DATA_ASSOCIATION);
                    list.add(LogHandlerTrigger.AFTER_OUTPUT_DATA_ASSOCIATION);
                }
            }
            result = CollectionUtils.asSequence(list);
        }
        return result;
    }

    @Override
    public DataDeclarationContainer getLogHandlerContext(@NotNull LogHandlerTrigger trigger) {
        DataDeclarationContainer result = null;
        if (this.isLoggable()) {
            if (trigger == LogHandlerTrigger.BEFORE_INPUT_DATA_ASSOCIATION && this.getInputDataAssociationSet() != null) {
                result = this.getInputDataAssociationSet().getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
            }
            if (trigger == LogHandlerTrigger.AFTER_INPUT_DATA_ASSOCIATION && this.getInputDataAssociationSet() != null) {
                result = this.getInputDataAssociationSet().getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
            } else if (trigger == LogHandlerTrigger.BEFORE_OUTPUT_DATA_ASSOCIATION && this.getOutputDataAssociationSet() != null) {
                result = this.getOutputDataAssociationSet().getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
            } else if (trigger == LogHandlerTrigger.AFTER_OUTPUT_DATA_ASSOCIATION && this.getOutputDataAssociationSet() != null) {
                result = this.getOutputDataAssociationSet().getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
            } else if (trigger == LogHandlerTrigger.BEFORE_ITERATION && this.getLoopCharacteristicsType() == LoopCharacteristicsType.LOOP) {
                result = this.getLoopCharacteristics().getLoopCharacteristicsContainer();
            } else if ((trigger == LogHandlerTrigger.BEFORE_INSTANCE_EXECUTION || trigger == LogHandlerTrigger.AFTER_INSTANCE_EXECUTION) && this.getLoopCharacteristicsType() == LoopCharacteristicsType.MULTIINSTANCE) {
                result = this.getLoopCharacteristics().getLoopCharacteristicsContainer();
            }
            if (result == null) {
                result = new EmptyDataDeclarationContainer(this.getProject());
            }
        }
        return result;
    }

    @Override
    public LogHandlerSet createLogHandlerSet() {
        return new LogHandlerSetImpl(this);
    }

    @Override
    public boolean isLoggable() {
        return this.getFeature(LoggableFeature.class) != null;
    }

    @Override
    public boolean hasDataAssociations() {
        return this.isInputDataAssociationEnabled() && !this.getInputDataAssociationSet().getDataAssociations().isEmpty() || this.isOutputDataAssociationEnabled() && !this.getOutputDataAssociationSet().getDataAssociations().isEmpty();
    }

    @Override
    public boolean isDraft() {
        boolean result = false;
        IsDraftFeature feature = this.getFeature(IsDraftFeature.class);
        if (feature != null) {
            result = feature.getValue();
        }
        return result;
    }

    @Override
    public void setDraft(boolean isDraft) {
        if (this.isDraft() == isDraft) {
            return;
        }
        IsDraftFeature feature = this.getFeature(IsDraftFeature.class);
        if (feature != null) {
            feature.setValue(isDraft);
        }
    }

    @Override
    public boolean mustIgnoreArguments() {
        return !this.isNotificationTask() && !this.isUpdateTask() && !this.isSubprocess();
    }

    @Override
    public boolean isDraftable() {
        return this.getFeature(IsDraftFeature.class) != null;
    }

    @Override
    public boolean isDataAssociationsEnabled() {
        return this.getFeature(InputDataAssociationFeature.class) != null || this.getFeature(OutputDataAssociationFeature.class) != null;
    }

    @Override
    public void clearDataAssociations() {
        DataAssociationSet outputs;
        DataAssociationSet inputs = this.getInputDataAssociationSet();
        if (inputs != null) {
            inputs.clearDataAssociations();
        }
        if ((outputs = this.getOutputDataAssociationSet()) != null) {
            outputs.clearDataAssociations();
        }
    }

    @Override
    public DataAssociationSet createDataAssociationSet(boolean isInput) {
        return isInput ? InputDataAssociationSet.create(this) : OutputDataAssociationSet.create(this);
    }

    @Override
    public boolean isInputServicePropertiesEnabled() {
        return this.getFeature(InputServicePropertySetFeature.class) != null;
    }

    @Override
    public boolean isOutputServicePropertiesEnabled() {
        return this.getFeature(OutputServicePropertySetFeature.class) != null;
    }

    @Override
    public boolean hasServiceProperties() {
        return this.isInputServicePropertiesEnabled() && !this.getInputServicePropertySet().getServiceProperties().isEmpty() || this.isOutputServicePropertiesEnabled() && !this.getOutputServicePropertySet().getServiceProperties().isEmpty();
    }

    @Override
    public void clearServiceProperties() {
        ServicePropertySet outputs;
        ServicePropertySet inputs = this.getInputServicePropertySet();
        if (inputs != null) {
            inputs.clearServiceProperties();
        }
        if ((outputs = this.getOutputServicePropertySet()) != null) {
            outputs.clearServiceProperties();
        }
    }

    @Override
    public ServicePropertySet createServicePropertySet(boolean isInput) {
        return new ServicePropertySetImpl(this, isInput);
    }

    @Override
    public boolean isServicePropertiesEnabled() {
        return this.isInputServicePropertiesEnabled() || this.isOutputServicePropertiesEnabled();
    }

    @Override
    public boolean isConversational() {
        return this.getFeature(ConversationalFeature.class) != null;
    }

    @Override
    public ConversationalType getConversationalType() {
        ConversationalType result = null;
        if (this.isConversational()) {
            if (this.isStart()) {
                NodeContainer parentObject = this.getParentObject();
                result = parentObject != null && Subprocess.class.isAssignableFrom(parentObject.getRawClass()) && ((Subprocess)parentObject).isTriggeredByEvent() ? ConversationalType.ONE_WAY_RECEIVER : ConversationalType.ONE_WAY_START;
            } else if (this.isEnd()) {
                result = ConversationalType.ONE_WAY_END;
            } else if (this.isServiceTask()) {
                result = ConversationalType.TWO_WAY_SENDER;
            } else if (this.isThrowEvent() || this.isSendTask()) {
                result = ConversationalType.ONE_WAY_SENDER;
            } else if (this.isCatchEvent() && !this.isStart() || this.isReceiveTask()) {
                result = ConversationalType.ONE_WAY_RECEIVER;
            }
        }
        return result;
    }

    @Override
    public Conversation getConversation() {
        Conversation result = null;
        ConversationalFeature feature = this.getFeature(ConversationalFeature.class);
        if (feature != null) {
            result = feature.getConversation();
        }
        return result;
    }

    @Override
    public void setConversation(Conversation conversation) {
        ConversationalFeature feature = this.getFeature(ConversationalFeature.class);
        if (feature != null) {
            feature.setConversation(conversation);
        }
    }

    @Override
    public ConversationalDefinition getConversationalDefinition() {
        ConversationalDefinition result = null;
        ConversationalFeature feature = this.getFeature(ConversationalFeature.class);
        if (feature != null) {
            result = feature.getConversationalDefinition();
        }
        return result;
    }

    @Override
    @NotNull
    public ConversationalDefinition createDefinition(@NotNull ConversationType type) {
        ConversationalDefinitionImpl result = type == ConversationType.DEFINE_INTERFACE ? new DefineInterfaceConversationalDefinitionImpl(this) : (type == ConversationType.USE_INTERFACE ? new UseInterfaceConversationalDefinitionImpl(this) : (type == ConversationType.SERVICE_CALL ? new ServiceCallConversationalDefinitionImpl(this) : new ProcessCallConversationalDefinitionImpl(this)));
        return result;
    }

    @Override
    public void clearCorrelations() {
        CorrelationItemsContainer outputs;
        CorrelationItemsContainer inputs = this.getInputCorrelationsContainer();
        if (inputs != null) {
            inputs.clearCorrelationItems();
        }
        if ((outputs = this.getOutputCorrelationsContainer()) != null) {
            outputs.clearCorrelationItems();
        }
    }

    protected static void copy(FlowNode source, FlowNode target) {
        target.getFeatures().copyFrom(source.getFeatures());
        target.setLabelMap(source.getLabelMap().clone());
        target.setDescription(source.getDescriptionMap().clone());
        if (source.isEvent() && source.asAnyNode(Event.class).getEventTriggerType().equals(EventTriggerType.TIMER)) {
            ((TimerEventDefinition)target.asAnyNode(Event.class).getEventDefinition()).setOptionalFeatures(((TimerEventDefinition)source.asAnyNode(Event.class).getEventDefinition()).getOptionalFeatures());
        }
    }

    protected void updateFeatures(EventTriggerType eventTriggerType) {
        Features oldFeatures = this.features;
        this.removeModificationListener(oldFeatures);
        assert (this.getProcess() instanceof ProcessContent) : "model implementation should be process content.";
        this.features = FeaturesByBPMNType.get(this, this.getBpmnType());
        EventTriggerTypeFeature triggerTypeFeature = this.features.getFeature(EventTriggerTypeFeature.class);
        if (triggerTypeFeature != null && eventTriggerType != null) {
            triggerTypeFeature.setValue(eventTriggerType);
        }
        if (eventTriggerType != null) {
            this.features.extendFeatures(FeaturesByEventTrigger.get(this, eventTriggerType));
        }
        this.features.copyFrom(oldFeatures);
        this.addModificationListener(this.features);
    }

    private static void dumpFeature(Feature f) {
        if (f.isSet()) {
            FeatureSet set = (FeatureSet)f;
            for (Feature f1 : set.getFeatures()) {
                ActivityImpl.dumpFeature(f1);
            }
        } else {
            System.out.println(" n=" + f.getName() + " c=" + f.getClass() + " v=" + f.getValue());
        }
    }

    private DataDeclarationContainer createEventDefinitionPayloadContainer(@NotNull ProjectObject parent, @NotNull EventDefinition eventDefinition, @NotNull EventTriggerType type, @NotNull AccessType accessType) {
        DataDeclarationContainer result = null;
        if (type == EventTriggerType.SIGNAL) {
            SignalEventDefinition signal = eventDefinition.as(SignalEventDefinition.class);
            SignalObject signalObject = signal.getSignal();
            if (signalObject != null) {
                CatalogType payloadType = signalObject.getEventPayloadType();
                result = this.createSingleDeclarationContainer(parent, "payload", payloadType, accessType);
            }
        } else if (type == EventTriggerType.ERROR) {
            ErrorEventDefinition error = eventDefinition.as(ErrorEventDefinition.class);
            if (error.isCatchAll() || error.isCatchAllSystemExceptions()) {
                result = this.createCatchAllErrorsArgumentContainer();
            } else {
                ErrorObject errorObject = error.getError();
                if (errorObject != null) {
                    result = this.createErrorArgumentsContainer(errorObject, accessType);
                }
            }
        }
        return result;
    }

    private DataDeclarationContainer createCatchAllErrorsArgumentContainer() {
        return new ImmutableDataDeclarationContainer(this.getProject()){

            @Override
            public Sequence<DataDeclaration> getLocalDeclarations() {
                ArrayList<DataDeclaration> declarations = new ArrayList<DataDeclaration>();
                Sequence attributes = CatchAllHelper.getCatchAllAttributes();
                for (AttributeTypeDescription attribute : attributes) {
                    try {
                        String name = attribute.getName();
                        TypeDescription typeDescription = attribute.getType();
                        CatalogType type = CatalogTypeImpl.get((TypeRef)typeDescription);
                        DataDeclaration dataDeclaration = this.createDeclaration(name, type, AccessType.OUT);
                        declarations.add(dataDeclaration);
                    }
                    catch (ProjectException e) {
                        e.printStackTrace();
                    }
                }
                return CollectionUtils.asSequence(declarations);
            }
        };
    }

    private DataDeclarationContainer createErrorArgumentsContainer(final @NotNull ErrorObject error, final @NotNull AccessType accessType) {
        return new ImmutableDataDeclarationContainer(error.getProject()){

            @Override
            public Sequence<DataDeclaration> getLocalDeclarations() {
                ArrayList<DataDeclaration> declarations = new ArrayList<DataDeclaration>();
                Map<String, CatalogType> attributes = error.getErrorInfoAttributes();
                for (Map.Entry<String, CatalogType> entry : attributes.entrySet()) {
                    try {
                        DataDeclaration dataDeclaration = this.createDeclaration(entry.getKey(), entry.getValue(), accessType);
                        declarations.add(dataDeclaration);
                    }
                    catch (ProjectException e) {
                        e.printStackTrace();
                    }
                }
                return CollectionUtils.asSequence(declarations);
            }
        };
    }

    private DataDeclarationContainer createSingleDeclarationContainer(@NotNull ProjectObject parent, final @NotNull String name, final @NotNull CatalogType type, final @NotNull AccessType accessType) {
        return new ImmutableDataDeclarationContainer(parent){

            @Override
            public Sequence<DataDeclaration> getLocalDeclarations() {
                DataDeclaration declaration = null;
                try {
                    declaration = this.createDeclaration(name, type, accessType);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
                return declaration != null ? CollectionUtils.singletonSequence(declaration) : CollectionUtils.emptySequence();
            }
        };
    }

    private DataDeclarationContainer createPayloadContainer(@NotNull Map<String, CatalogType> errorAttribues, @NotNull AccessType accessType) {
        ProcessArgumentContainer result = new ProcessArgumentContainer(this);
        for (Map.Entry<String, CatalogType> entry : errorAttribues.entrySet()) {
            try {
                DataDeclaration dataDeclaration = result.createDeclaration(entry.getKey(), entry.getValue(), accessType);
                result.addDeclaration(dataDeclaration);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void clearLogHandlers() {
        LogHandlerSet logHandlerSet = this.getLogHandlerSet();
        if (logHandlerSet != null) {
            logHandlerSet.clearLogHandlers();
        }
    }

    private void updateEventDefinition(EventTriggerType type) {
        if (type != null) {
            switch (type) {
                case MESSAGE: {
                    this.definition = new MessageEventDefinitionImpl(this);
                    break;
                }
                case TIMER: {
                    this.definition = new TimerEventDefinitionImpl(this);
                    break;
                }
                case ERROR: {
                    this.definition = new ErrorEventDefinitionImpl(this);
                    break;
                }
                case SIGNAL: {
                    this.definition = new SignalEventDefinitionImpl(this);
                    break;
                }
                case TERMINATE: {
                    this.definition = new TerminateEventDefinitionImpl(this);
                    break;
                }
                default: {
                    this.definition = null;
                    break;
                }
            }
        } else {
            this.definition = null;
        }
    }

    private int getOffsetInLane() {
        return ModelUtils.isHorizontal(this.getProcess()) ? this.getY() : this.getX();
    }

    private int getParentOffsetInLane() {
        int result;
        NodeContainer parent = this.getParentObject();
        if (parent instanceof Positional) {
            Positional positional = (Positional)((Object)parent);
            result = ModelUtils.isHorizontal(this.getProcess()) ? positional.getY() - positional.getHeight() / 2 : positional.getX() - positional.getWidth() / 2;
        } else {
            result = 0;
        }
        return result;
    }

    private void updateActivityType(BpmnType type, EventTriggerType triggerType) {
        this.setActivityType(type, triggerType);
    }

    private class ParticipantReferenceAdapter
    implements ParticipantReference {
        private ParticipantReferenceAdapter() {
        }

        @Override
        @Nullable
        public String getId() {
            return this.getId(ActivityImpl.this.getProcess());
        }

        @Override
        @Nullable
        public String getId(Process process) {
            String baseServiceId = this.getBaseServiceId();
            String result = null;
            if (ActivityImpl.this.isConversational()) {
                Conversational conversational = ActivityImpl.this.asAnyNode(Conversational.class);
                boolean inbound = conversational.getConversation().getConversationType().isInbound();
                OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)ActivityImpl.this);
                result = inbound ? operationReference.getServiceReference().getServiceName() : operationReference.getServiceReference().getReferenceName();
            } else if (baseServiceId != null) {
                result = baseServiceId + ".reference";
            }
            return result;
        }

        private String getBaseServiceId() {
            String result;
            if (ActivityImpl.this.getParticipant() != null) {
                ObjectTypeDescription otd = ActivityImpl.this.getParticipant().getObjectType();
                if (Boolean.valueOf(otd.getProperty("is.callback")).booleanValue()) {
                    otd = otd.getParent().asObject();
                }
                result = otd.getText();
            } else {
                result = null;
            }
            return result;
        }
    }

    private class OperationReferenceAdapter
    implements OperationReferenceExtended {
        private Boolean isTwoWay = null;

        private OperationReferenceAdapter() {
        }

        @Override
        public String getName() {
            String result = null;
            if (ActivityImpl.this.isConversational()) {
                OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)ActivityImpl.this);
                result = operationReference.getName();
            }
            return result;
        }

        @Override
        public QName getInputType() {
            throw new UnsupportedOperationException("Dont use this method any more.");
        }

        @Override
        public QName getOutputType() {
            throw new UnsupportedOperationException("Dont use this method any more.");
        }

        @Override
        public QName getFaultCodeError() {
            throw new UnsupportedOperationException("Dont use this method any more.");
        }

        @Override
        public QName getFaultMessageType() {
            throw new UnsupportedOperationException("Dont use this method any more.");
        }

        @Override
        public boolean allowsWrappedArguments() {
            boolean result = false;
            if (ActivityImpl.this.isConversational()) {
                OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)ActivityImpl.this);
                result = operationReference.allowsWrappedArguments();
            }
            return result;
        }

        @Override
        public String findArgumentPartName(String argumentName) {
            String result = argumentName;
            if (ActivityImpl.this.isConversational()) {
                OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)ActivityImpl.this);
                result = operationReference.findArgumentPartName(argumentName);
            }
            return result;
        }

        @Override
        public boolean isTwoWay() {
            throw new UnsupportedOperationException("Dont use this method any more.");
        }

        @Override
        public QName getPortType() {
            QName result = null;
            if (ActivityImpl.this.isConversational()) {
                OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)ActivityImpl.this);
                result = operationReference.getPortType();
            }
            return result;
        }
    }

    private static class TypeDescriptionInfo {
        private MethodTypeDescription methodTypeDescription;
        private WsdlTypeDescription xmlObjectTypeDescription;

        private TypeDescriptionInfo() {
        }

        public MethodTypeDescription getMethodTypeDescription() {
            return this.methodTypeDescription;
        }

        public void setMethodTypeDescription(MethodTypeDescription methodTypeDescription) {
            this.methodTypeDescription = methodTypeDescription;
        }

        public WsdlTypeDescription getXmlObjectTypeDescription() {
            return this.xmlObjectTypeDescription;
        }

        public void setXmlObjectTypeDescription(WsdlTypeDescription wsdlType) {
            this.xmlObjectTypeDescription = wsdlType;
        }
    }

    public static class ActivityLocaleStringMap
    extends ModificationAwareLocaleStringMap {
        private transient FlowNode node;
        private BpmnType type;
        private static final long serialVersionUID = -329454869600275845L;

        protected ActivityLocaleStringMap(FlowNode node) {
            super(node);
            this.node = node;
            this.type = node.getBpmnType();
        }

        public FlowNode getActivity() {
            return this.node;
        }

        @Override
        public LocaleStringMap clone() {
            return super.clone();
        }

        protected static ActivityLocaleStringMap create(ActivityImpl activityImpl) {
            return new ActivityLocaleStringMap(activityImpl);
        }
    }
}

