/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bamdata;

import oracle.bpm.bamdata.BAMResourceInfo;
import oracle.bpm.bamdata.BAMResourceRunningInfo;
import oracle.bpm.bamdata.ResourceRunningInfo;
import oracle.bpm.bamdata.Run;

public class ResourceInfo
implements BAMResourceInfo {
    private ResourceRunningInfo[] dataByCategory;
    private String name;
    private ResourceRunningInfo runningInfo;
    static final long serialVersionUID = -2890409224115238742L;
    static final long serialCheck = -3292691669247267295L;

    protected ResourceInfo(Run run, String name, int capacity, String[] categories, double cost) {
        this.name = name;
        this.runningInfo = new ResourceRunningInfo(run, capacity, cost);
        this.dataByCategory = new ResourceRunningInfo[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            this.dataByCategory[i] = new ResourceRunningInfo(run, capacity, cost);
        }
    }

    @Override
    public BAMResourceRunningInfo[] getDataByCategory() {
        return this.dataByCategory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Run getRun() {
        return this.runningInfo.getRun();
    }

    @Override
    public BAMResourceRunningInfo getRunningInfo() {
        return this.runningInfo;
    }

    public ResourceRunningInfo getRunningInfoImpl() {
        return this.runningInfo;
    }

    public void reset() {
        this.runningInfo.reset();
        for (int i = 0; i < this.dataByCategory.length; ++i) {
            ResourceRunningInfo info = this.dataByCategory[i];
            info.reset();
        }
    }

    protected ResourceRunningInfo getCategoryRunningInfo(int category) {
        return this.dataByCategory[category];
    }
}

