/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.Event;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.ArrayList;
import java.util.Random;
import oracle.bpm.collections.PriorityQueue;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.model.processes.FindInPath;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;

public class SplitSimulationActivityImpl
extends SimulationFlowNodeImpl {
    protected SplitSimulationActivityImpl(FlowNode node) {
        super(node);
    }

    @Override
    public void scheduleMove(long eventTime, long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        this.scheduleParent(currentTime, token, eventQueue);
        this.scheduleNormalTransitions(currentTime, token, eventQueue, random);
        this.scheduleOthers(currentTime, token, eventQueue, random);
    }

    @Override
    protected long getNextIPT(Token token, long currentTime, Random random) {
        return currentTime;
    }

    protected void scheduleNormalTransitions(long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        Sequence<SequenceFlow> list = ModelUtils.getOutgoingSequenceFlows(this.getFlowNode());
        FlowNode join = ModelUtils.findFlowNode(this.getFlowNode().getProcess(), this.getAssociatedNodeId());
        assert (join != null) : "The gateways are not balanced! Missing join for " + this.getFlowNode().getId();
        for (SequenceFlow sequenceFlow : list) {
            SequenceFlowImpl transition = (SequenceFlowImpl)sequenceFlow;
            boolean schedule = false;
            if (transition.isUnconditional()) {
                schedule = true;
            } else if (transition.isConditional()) {
                double prob = random.nextDouble();
                boolean bl = schedule = prob <= this.getTransitionProbability(transition, 0.0);
            }
            if (!schedule) continue;
            FlowNode from = sequenceFlow.getTarget();
            Token createdToken = this.belongToSameFlow(from, join) ? Token.create(token, currentTime, false) : Token.create(currentTime, token.getCategory(), token.getProjectSimulation(), token.getModel(), token.getProcessInfo());
            Event event = Event.createMoveEvent(createdToken, currentTime, this.getFlowNode(), transition.getTarget(), transition);
            eventQueue.offer(event);
        }
    }

    protected void scheduleOthers(long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        ArrayList<SequenceFlow> list = new ArrayList<SequenceFlow>();
        this.addOtherTransitions(list);
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            SequenceFlowImpl transition;
            double prob = random.nextDouble();
            if (!(prob <= this.getTransitionProbability(transition = (SequenceFlowImpl)list.get(i), 0.0))) continue;
            Event event = Event.createMoveEvent(Token.create(token, currentTime, false), currentTime, this.getFlowNode(), transition.getTarget(), transition);
            eventQueue.offer(event);
        }
    }

    private void scheduleParent(long currentTime, Token token, PriorityQueue<Event> eventQueue) {
        SequenceFlow transition = this.getDynamicTransition(this.getAssociatedNodeId());
        Event event = Event.createImmediateMoveEvent(token, currentTime, this.getFlowNode(), transition.getTarget(), transition);
        eventQueue.offer(event);
    }

    private String getAssociatedNodeId() {
        NodeAssociationFeature joinFeature = this.getFlowNode().getFeature(NodeAssociationFeature.class);
        return joinFeature.getValue();
    }

    private boolean belongToSameFlow(FlowNode source, FlowNode target) {
        if (source.getId().equals(target.getId())) {
            return true;
        }
        FindInPath findInPath = new FindInPath(source, target);
        return findInPath.exists();
    }
}

