/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.NormalDistribution;
import fuego.simulation.SimulationDefaults;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.msg.ProjectMsg;

public class ProjectSimulationBuilder {
    public static ModelSimulation createSimulationModel(Process process, SimulationModelData simulationModelData) throws ProjectException {
        Project project = process.getProject();
        String modelId = process.getId();
        ModelSimulation modelSimulation = project.createModelSimulation(modelId, simulationModelData.getId());
        modelSimulation.setUseMaxInstances(simulationModelData.getUseMaxInstances());
        modelSimulation.setMaxInstances(simulationModelData.getMaxCount());
        for (ActivityInfo activityInfo : simulationModelData.getActivities()) {
            String id = activityInfo.getUserTask().getId();
            SimulationFlowNode simulationNode = modelSimulation.findSimulationFlowNode(id);
            simulationNode.setCost(activityInfo.getCostValue());
            simulationNode.setCapacity(activityInfo.getAvailableResources());
            NormalDistribution distribution = (NormalDistribution)simulationNode.getDistribution();
            distribution.setDeviation(activityInfo.getDerivation().getTotalMicroseconds());
            distribution.setMean(activityInfo.getDistributionMean().getTotalMicroseconds());
        }
        return modelSimulation;
    }

    public static ProjectSimulation createSimulationDefinition(Project project, SimulationDefinitionData simulationDefinitionData) throws ProjectException {
        ProjectSimulation newSimulationDefinition = project.getSimulations().createProjectSimulation(simulationDefinitionData.getId());
        newSimulationDefinition.setDuration(simulationDefinitionData.getDuration());
        newSimulationDefinition.setStartTime(simulationDefinitionData.getStartTime());
        newSimulationDefinition.setInflightFinish(simulationDefinitionData.getLetInflight());
        return newSimulationDefinition;
    }

    public static ModelSimulation createModel(Process process, SimulationModelData simulationModelData) throws ProjectException {
        Project project = process.getProject();
        String modelId = process.getId();
        ModelSimulation modelSimulation = project.createModelSimulation(modelId, simulationModelData.getId());
        modelSimulation.setUseMaxInstances(simulationModelData.getUseMaxInstances());
        modelSimulation.setMaxInstances(simulationModelData.getMaxCount());
        for (ActivityInfo activityInfo : simulationModelData.getActivities()) {
            String id = activityInfo.getUserTask().getId();
            SimulationFlowNode simulationNode = modelSimulation.findSimulationFlowNode(id);
            simulationNode.setCost(activityInfo.getCostValue());
            simulationNode.setCapacity(activityInfo.getAvailableResources());
            NormalDistribution distribution = (NormalDistribution)simulationNode.getDistribution();
            distribution.setDeviation(activityInfo.getDerivation().getTotalMicroseconds());
            distribution.setMean(activityInfo.getDistributionMean().getTotalMicroseconds());
        }
        project.getSimulations().addModelSimulation(modelId, modelSimulation);
        return modelSimulation;
    }

    public static ProjectSimulation createSimulationDefinition(Process process, SimulationDefinitionData simulationDefinitionData) throws ProjectException {
        ProjectSimulation newSimulationDefinition = process.getProject().getSimulations().createAndAddProjectSimulation(simulationDefinitionData.getId());
        newSimulationDefinition.setDuration(simulationDefinitionData.getDuration());
        newSimulationDefinition.setStartTime(simulationDefinitionData.getStartTime());
        newSimulationDefinition.setInflightFinish(simulationDefinitionData.getLetInflight());
        return newSimulationDefinition;
    }

    public static void store(ProjectObject projectObject) throws ProjectException {
        Project project = projectObject.getProject();
        ProjectRepository repository = project.getRepository();
        if (repository.isOpen(project)) {
            ProjectWriter projectWriter = project.getWriter();
            projectWriter.write(projectObject);
        }
    }

    public static ProjectSimulation createSimulationAndDefinition(Process process, SimulationDefinitionData simulationDefinitionData, SimulationModelData simulationModelData) throws ProjectException {
        ProjectSimulation simulationDefinition = ProjectSimulationBuilder.createSimulationDefinition(process, simulationDefinitionData);
        ModelSimulation modelSimulation = ProjectSimulationBuilder.createModel(process, simulationModelData);
        simulationDefinition.addModelSimulation(modelSimulation);
        ProjectSimulationBuilder.store(simulationDefinition);
        ProjectSimulationBuilder.store(modelSimulation);
        return simulationDefinition;
    }

    public static class SimulationModelData {
        List<ActivityInfo> activities;
        String id;
        Integer maxCount;
        Boolean useMaxInstances;

        public SimulationModelData(String id, Boolean useMaxInstances, Integer maxCount, List<ActivityInfo> activities) {
            this.id = id;
            this.useMaxInstances = useMaxInstances;
            this.maxCount = maxCount;
            this.activities = activities;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Boolean getUseMaxInstances() {
            return this.useMaxInstances;
        }

        public void setUseMaxInstances(Boolean useMaxInstances) {
            this.useMaxInstances = useMaxInstances;
        }

        public Integer getMaxCount() {
            return this.maxCount;
        }

        public void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        public List<ActivityInfo> getActivities() {
            return this.activities;
        }

        public void setActivities(List<ActivityInfo> activities) {
            this.activities = activities;
        }
    }

    public static class SimulationDefinitionData {
        Interval duration;
        String id;
        Boolean letInflight;
        Time startTime;

        public SimulationDefinitionData(String id, Interval duration, Time startTime, Boolean letInflight) {
            this.id = id;
            this.duration = duration;
            this.startTime = startTime;
            this.letInflight = letInflight;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Interval getDuration() {
            return this.duration;
        }

        public void setDuration(Interval duration) {
            this.duration = duration;
        }

        public Time getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Time startTime) {
            this.startTime = startTime;
        }

        public Boolean getLetInflight() {
            return this.letInflight;
        }

        public void setLetInflight(Boolean letInflight) {
            this.letInflight = letInflight;
        }
    }

    public static class ActivityInfo {
        private Integer availableResources = SimulationDefaults.AVAILABLE_RESOURCES;
        private Double costValue = SimulationDefaults.COST;
        private Interval derivation = SimulationDefaults.DEVIATION;
        private Interval distributionMean = SimulationDefaults.MEAN;
        private UserTask userTask;
        public static MsgList list = MsgList.create(ProjectMsg.ACTIVITY, ProjectMsg.DISTRIBUTION_MEAN, ProjectMsg.STANDARD_DERIVATION, ProjectMsg.AVAILABLE_RESOURCES, ProjectMsg.BASE_COST);

        public ActivityInfo(UserTask userTask) {
            this.userTask = userTask;
        }

        public static MsgList getList() {
            return list;
        }

        public UserTask getUserTask() {
            return this.userTask;
        }

        public Interval getDistributionMean() {
            return this.distributionMean;
        }

        public Interval getDerivation() {
            return this.derivation;
        }

        public Integer getAvailableResources() {
            return this.availableResources;
        }

        public Double getCostValue() {
            return this.costValue;
        }

        public Object get(int column) {
            switch (column) {
                case 0: {
                    return this.userTask.getDefaultLabel();
                }
                case 1: {
                    return this.distributionMean;
                }
                case 2: {
                    return this.derivation;
                }
                case 3: {
                    return this.availableResources;
                }
                case 4: {
                    return this.costValue;
                }
            }
            return null;
        }

        public void set(int column, Object value) {
            switch (column) {
                case 1: {
                    this.distributionMean = (Interval)value;
                    break;
                }
                case 2: {
                    this.derivation = (Interval)value;
                    break;
                }
                case 3: {
                    this.availableResources = (Integer)value;
                    break;
                }
                case 4: {
                    this.costValue = (Double)value;
                }
            }
        }
    }
}

