/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.DistributionContainer;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.SimulationSequenceFlowImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.ModelSimulationProcess;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.ModelEvent;
import oracle.bpm.project.model.simulation.ModelListener;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

public final class ModelSimulationImpl
extends ResourceObjectImpl
implements DistributionContainer,
ModelListener,
ModelSimulation,
ResourceObject {
    private List<Distribution> calculatedDistributions = new ArrayList<Distribution>();
    private AbstractDistribution distribution;
    private List<ModelListener> listeners = Collections.synchronizedList(new ArrayList());
    private int maxInstances = 200;
    private Process model;
    private String modelId;
    private String name;
    private final Map<String, SimulationFlowNode> otherActivities;
    private Project project;
    private ProjectSimulation projectSimulationModel;
    private final Map<String, SimulationFlowNode> simulationActivities;
    private final Map<String, SimulationSequenceFlow> simulationTransitions;
    private boolean useMaxInstances = false;

    private ModelSimulationImpl(@NotNull Project fuegoProject, @NotNull String name) {
        super(fuegoProject);
        this.project = fuegoProject;
        this.name = name;
        this.simulationActivities = new HashMap<String, SimulationFlowNode>();
        this.simulationTransitions = new HashMap<String, SimulationSequenceFlow>();
        this.otherActivities = new HashMap<String, SimulationFlowNode>();
        this.distribution = AbstractDistribution.create(DistributionType.NORMAL);
    }

    private ModelSimulationImpl(@NotNull Project fuegoProject, @NotNull String modelId, @NotNull String name, boolean init) {
        this(fuegoProject, name);
        this.modelId = modelId;
        if (init) {
            this.createInfo();
        }
    }

    public static ModelSimulation createEmptyModelSimulation(@NotNull Project fuegoProject, @NotNull String modelId, @NotNull String name) {
        return new ModelSimulationImpl(fuegoProject, modelId, name, false);
    }

    public static ModelSimulation createEmptyModelSimulation(@NotNull Project fuegoProject, @NotNull String name) {
        return new ModelSimulationImpl(fuegoProject, name);
    }

    public static ModelSimulation createModelSimulation(@NotNull Project fuegoProject, @NotNull String modelId, @NotNull String name) {
        return new ModelSimulationImpl(fuegoProject, modelId, name, true);
    }

    @Override
    public void setProjectSimulation(ProjectSimulation projectSimulationModel) {
        this.projectSimulationModel = projectSimulationModel;
    }

    @Override
    public void setDistribution(Distribution distribution) {
        if (!this.distribution.equals(distribution)) {
            AbstractDistribution oldValue = this.distribution;
            this.distribution = (AbstractDistribution)distribution;
            this.events().objectChanged("distribution", oldValue, distribution);
        }
    }

    @Override
    public AbstractDistribution getDistribution() {
        return this.distribution;
    }

    @Override
    public void setMaxInstances(int maxInstances) {
        if (this.maxInstances != maxInstances) {
            this.maxInstances = maxInstances;
            this.fireSimulationModelChangeEvent();
        }
    }

    @Override
    public int getMaxInstances() {
        return this.maxInstances;
    }

    @Override
    public void setId(String id) {
        this.name = id;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public SimulationSequenceFlow findSimulationSequenceFlow(String transitionId) {
        return this.simulationTransitions.get(transitionId);
    }

    @Override
    public Collection<SimulationSequenceFlow> getSimulationSequenceFlows() {
        return Collections.unmodifiableCollection(this.simulationTransitions.values());
    }

    @Override
    public void removeSequenceFlow(SimulationSequenceFlow simulationSequenceFlow) throws ProjectException {
        String transitionId = simulationSequenceFlow.getId();
        if (!this.simulationTransitions.containsKey(transitionId)) {
            throw new ProjectException(simulationSequenceFlow, ProjectMsg.SIMULATION_TRANSITION_NOT_PRESENT);
        }
        this.events().preObjectRemoved(simulationSequenceFlow, (ProjectObject)this);
        this.simulationTransitions.remove(transitionId);
        this.events().postObjectRemoved(simulationSequenceFlow, (ProjectObject)this);
        ((SimulationSequenceFlowImpl)simulationSequenceFlow).setModelSimulation(null);
    }

    @Override
    public void setUseMaxInstances(boolean useMaxInstances) {
        if (useMaxInstances != this.useMaxInstances) {
            this.useMaxInstances = useMaxInstances;
            this.fireSimulationModelChangeEvent();
        }
    }

    @Override
    public boolean getUseMaxInstances() {
        return this.useMaxInstances;
    }

    @Override
    public Collection<SimulationFlowNode> getSimulationFlowNodes() {
        return this.simulationActivities.values();
    }

    @Override
    public SimulationFlowNode findSimulationFlowNode(String activityId) {
        SimulationFlowNode activity = this.simulationActivities.get(activityId);
        if (activity == null) {
            activity = this.otherActivities.get(activityId);
        }
        return activity;
    }

    @Override
    public SimulationFlowNode[] getAllBeginFlowNodes() {
        ArrayList<SimulationFlowNode> nodes = new ArrayList<SimulationFlowNode>();
        Sequence<StartEvent> events = ModelUtils.getAllStartEvents(this.getProcess());
        for (StartEvent s : events) {
            nodes.add(this.findFlowNodeAndCreateIfNotExists(s.getId()));
        }
        return nodes.toArray(new SimulationFlowNode[nodes.size()]);
    }

    @Override
    public SimulationFlowNode getBeginFlowNode() {
        return this.findFlowNodeAndCreateIfNotExists(ModelUtils.getStartEvent(this.getProcess()).getId());
    }

    @Override
    public SimulationFlowNode getAnyEndFlowNode() {
        return this.findFlowNodeAndCreateIfNotExists(ModelUtils.getAnyEndEvent(this.getProcess()).getId());
    }

    @Override
    public SimulationFlowNode createSimulationFlowNode(String activityId) {
        SimulationFlowNodeImpl simulationActivity = null;
        FlowNode fuegoNode = this.getProcess().findDescendant(FlowNode.class, activityId);
        if (fuegoNode != null) {
            simulationActivity = SimulationFlowNodeImpl.create(fuegoNode);
        }
        return simulationActivity;
    }

    @Override
    public void addSimulationFlowNode(SimulationFlowNode simulationActivity) throws ProjectException {
        if (this.simulationActivities.containsKey(simulationActivity.getId()) || this.otherActivities.containsKey(simulationActivity.getId())) {
            throw new ProjectException(simulationActivity, ProjectMsg.SIMULATION_MODEL_HAS_ACTIVITY);
        }
        FlowNode fuegoNode = this.getProcess().findNode(simulationActivity.getId());
        if (fuegoNode != null) {
            ((SimulationFlowNodeImpl)simulationActivity).setModelSimulation(this);
            this.events().preObjectAdded(simulationActivity, (ProjectObject)this);
            this.simulationActivities.put(simulationActivity.getId(), simulationActivity);
            simulationActivity.addListener(this);
            this.events().postObjectAdded(simulationActivity, (ProjectObject)this);
        }
    }

    @Override
    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public SimulationSequenceFlow createSimulationSequenceFlow(String transitionId) {
        return new SimulationSequenceFlowImpl(this.getProject(), transitionId);
    }

    @Override
    public void addSimulationSequenceFlow(SimulationSequenceFlow simulationSequenceFlow) throws ProjectException {
        if (this.simulationTransitions.containsKey(simulationSequenceFlow.getId())) {
            throw new ProjectException(simulationSequenceFlow, ProjectMsg.SIMULATION_MODEL_HAS_TRANSITION);
        }
        this.doAddTransition((SimulationSequenceFlowImpl)simulationSequenceFlow);
    }

    @Override
    public void addCalculatedDistribution(Distribution distribution) {
        this.calculatedDistributions.add(distribution);
        this.events().objectChanged("calculatedDistribution", null, distribution);
    }

    @Override
    public void removeCalculatedDistribution(Distribution distribution) {
        if (this.calculatedDistributions.remove(distribution)) {
            this.events().objectChanged("calculatedDistribution", distribution, null);
        }
    }

    public Distribution getCalculatedDistributionForType(DistributionType distributionType) {
        for (Distribution otherDistribution : this.calculatedDistributions) {
            if (!otherDistribution.getType().equals(distributionType)) continue;
            return otherDistribution;
        }
        return null;
    }

    @Override
    public Process getProcess() {
        Project project;
        if (this.model == null && (project = this.getProject()) != null) {
            this.model = project.findProcess(this.modelId);
        }
        return this.model;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void capacityChanged(ModelEvent e) {
        this.fireCapacityChanged(e);
        this.fireSimulationModelChangeEvent();
    }

    @Override
    public void childChanged(SimulationFlowNode child) {
        this.fireSimulationModelChangeEvent();
    }

    public void createInfo() {
        for (FlowNode node : this.getProcess().getFlowNodes()) {
            if (this.findSimulationFlowNode(node.getId()) != null) continue;
            SimulationFlowNodeImpl simulationActivityImpl = SimulationFlowNodeImpl.create(node);
            try {
                this.addSimulationFlowNode(simulationActivityImpl);
                simulationActivityImpl.addListener(this);
            }
            catch (ProjectException ignored) {}
        }
        this.addTransitions(this.getProcess().getSequenceFlows());
    }

    public void addTransitions(Sequence<SequenceFlow> transitions) {
        for (SequenceFlow transition : transitions) {
            String transitionId = transition.getId();
            if (this.findSimulationSequenceFlow(transitionId) != null) continue;
            try {
                SimulationSequenceFlowImpl simulationTransition = new SimulationSequenceFlowImpl(this.getProject(), transitionId);
                if (transition.isConditionalFlow()) {
                    simulationTransition.setProbability(0.0);
                }
                this.doAddTransition(simulationTransition);
            }
            catch (ProjectException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void removeSimulationFlowNode(SimulationFlowNode simulationActivity) throws ProjectException {
        this.events().preObjectRemoved(simulationActivity, (ProjectObject)this);
        this.simulationActivities.remove(simulationActivity.getId());
        simulationActivity.removeListener(this);
        this.events().postObjectRemoved(simulationActivity, (ProjectObject)this);
        ((SimulationFlowNodeImpl)simulationActivity).setModelSimulation(null);
    }

    @Override
    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return this.getId();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MODEL_SIMULATION;
    }

    @Override
    public Path getPath() {
        return Path.SIMULATIONS.create(this.name);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject().getSimulations().getModelSimulationsContainer().findChild(ModelSimulationProcess.class, this.getProcess().getId());
    }

    public ProjectSimulation getCurrentProjectSimulation() {
        return this.projectSimulationModel;
    }

    @Override
    public Distribution[] getCalculatedDistributions() {
        return this.calculatedDistributions.toArray(new Distribution[this.calculatedDistributions.size()]);
    }

    @Override
    @NotNull
    public SimulationSequenceFlow asSimulationSequenceFlow(@NotNull SequenceFlow transition) {
        String transitionId = transition.getId();
        SimulationSequenceFlow result = this.findSimulationSequenceFlow(transitionId);
        if (result == null) {
            try {
                result = this.doAddTransition(new SimulationSequenceFlowImpl(this.getProject(), transitionId));
            }
            catch (ProjectException e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    @Override
    public int getPosition() {
        return -1;
    }

    @Override
    public ProjectObject copy() {
        ModelSimulationImpl newModelSimulation = (ModelSimulationImpl)super.copy();
        if (newModelSimulation != null) {
            newModelSimulation.setProcess(this.getProcess());
            newModelSimulation.createInfo();
        }
        return newModelSimulation;
    }

    @Override
    public void setProcess(Process process) {
        this.modelId = process.getId();
    }

    @Override
    public SimulationFlowNode findFlowNodeAndCreateIfNotExists(String flowNodeId) {
        SimulationFlowNode simulationActivity = this.findSimulationFlowNode(flowNodeId);
        if (simulationActivity == null) {
            simulationActivity = this.createSimulationFlowNode(flowNodeId);
            try {
                this.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException projectException) {
                // empty catch block
            }
        }
        return simulationActivity;
    }

    private void fireSimulationModelChangeEvent() {
        ProjectEventSet set = new ProjectEventSet();
        set.add(ProjectEvent.CHANGE(this));
        this.events().processPostEvents(set);
    }

    private SimulationSequenceFlowImpl doAddTransition(SimulationSequenceFlowImpl simulationTransition) throws ProjectException {
        simulationTransition.setModelSimulation(this);
        this.events().preObjectAdded(simulationTransition, (ProjectObject)this);
        this.simulationTransitions.put(simulationTransition.getId(), simulationTransition);
        this.events().postObjectAdded(simulationTransition, (ProjectObject)this);
        return simulationTransition;
    }

    private void fireCapacityChanged(ModelEvent e) {
        for (ModelListener listener : this.listeners) {
            listener.capacityChanged(e);
        }
    }
}

