/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.AbstractDistribution;
import java.util.Random;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.model.simulation.DistributionType;

public class ExponentialDistribution
extends AbstractDistribution {
    private int events;
    private Interval interval;
    private static final int DEFAULT_NUMBER_OF_EVENTS = 10;
    private static final Interval DEFAULT_INTERVAL = Interval.valueOf("1h");

    public ExponentialDistribution(int events, Interval interval) {
        super(DistributionType.EXPONENTIAL);
        this.setEvents(events);
        this.setInterval(interval);
    }

    public static ExponentialDistribution create() {
        return ExponentialDistribution.create(10, DEFAULT_INTERVAL);
    }

    public static ExponentialDistribution create(int events, Interval interval) {
        return new ExponentialDistribution(events, interval);
    }

    public static void main(String[] args) {
        ExponentialDistribution distribution = ExponentialDistribution.create(10, Interval.valueOf(10L));
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            System.out.println(Interval.valueOf((double)distribution.next(random)));
        }
    }

    @Override
    public long getAvgValue() {
        return this.interval.getTotalMicroseconds() / (long)this.events;
    }

    public void setEvents(int events) {
        this.events = events;
        this.fireDistributionChanged();
    }

    public void setEvents(String events) {
        this.setEvents(Integer.valueOf(events));
    }

    public int getEvents() {
        return this.events;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
        this.fireDistributionChanged();
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void setIntervalValue(String value) {
        this.interval = Interval.valueOf(value);
    }

    public String getIntervalValue() {
        return this.interval.toString();
    }

    @Override
    public long next(Random random) {
        double rand = 0.0;
        while (rand == 0.0) {
            rand = random.nextDouble();
        }
        double expRand = -Math.log(rand);
        double scale = (double)this.interval.getTotalMicroseconds() / (double)this.events;
        return (long)(expRand * scale);
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + this.events;
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExponentialDistribution other = (ExponentialDistribution)obj;
        if (this.events != other.events) {
            return false;
        }
        return !(this.interval == null ? other.interval != null : !this.interval.equals(other.interval));
    }
}

