/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.ChangeSequenceFlowRoutingDataCommand;
import oracle.bpm.project.command.design.MoveFlowNodeCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class TranslateLaneCommand
extends MultipleCommand {
    private int offset;
    private int previous;

    public TranslateLaneCommand(@NotNull Lane lane, @NotNull Point offset) {
        super(lane);
        this.previous = lane.getOffset();
        this.offset = this.getOffsetForLocation(offset);
        this.build();
    }

    public TranslateLaneCommand(@NotNull Lane lane, int offset) {
        super(lane);
        this.previous = lane.getOffset();
        this.offset = offset;
        this.build();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.getAffectedObject().getId()).getString();
    }

    @Override
    public Lane getAffectedObject() {
        return (Lane)super.getAffectedObject();
    }

    private void build() throws ExecutionException {
        final Lane lane = this.getAffectedObject();
        Sequence<FlowNode> activities = lane.getActivities();
        for (FlowNode flowNode : activities) {
            this.addCommand(new MoveFlowNodeCommand(flowNode, this.getNewLocationForFlowNode(flowNode), 1));
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingSequenceFlows()) {
                int y;
                Point point;
                if (!activities.contains((Object)sequenceFlow.getTarget()) || (point = sequenceFlow.getControlPoint()) == null || (y = point.getY()) <= lane.getOffset() || y >= lane.getOffset() + lane.getSize()) continue;
                this.addCommand(new ChangeSequenceFlowRoutingDataCommand(sequenceFlow, sequenceFlow.getRoutingMode(), this.getNewLocationForSequenceFlow(sequenceFlow)));
            }
        }
        this.addCommand(new ProjectCommand(new ProjectObject[0]){

            @Override
            public String getName() {
                return null;
            }

            public Object execute() throws ExecutionException {
                lane.setOffset(TranslateLaneCommand.this.offset);
                return null;
            }

            @Override
            public void undo() {
                lane.setOffset(TranslateLaneCommand.this.previous);
            }
        });
    }

    private Point getNewLocationForSequenceFlow(SequenceFlow sequenceFlow) {
        Point point = sequenceFlow.getControlPoint();
        int delta = this.offset - this.previous;
        return ModelUtils.isHorizontal(this.getProcess()) ? point.translate(0, delta) : point.translate(delta, 0);
    }

    private Point getNewLocationForFlowNode(@NotNull FlowNode flowNode) {
        int delta = this.offset - this.previous;
        return ModelUtils.isHorizontal(this.getProcess()) ? flowNode.getLocation().translate(0, delta) : flowNode.getLocation().translate(delta, 0);
    }

    private int getOffsetForLocation(@NotNull Point location) {
        return ModelUtils.isHorizontal(this.getProcess()) ? location.getY() : location.getX();
    }

    private Process getProcess() {
        return this.getAffectedObject().getProcess();
    }
}

