/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.Process;

public class ToggleCounterCommand
extends ProjectCommand {
    private Counter counter;

    public ToggleCounterCommand(Counter counter) {
        super(counter.getProcess());
        this.counter = counter;
    }

    public String toString() {
        return super.toString() + this.counter;
    }

    public Object execute() throws ExecutionException {
        this.toggle();
        return null;
    }

    @Override
    public void undo() {
        this.toggle();
    }

    public void toggle() {
        try {
            if (this.getProcess().contains(this.counter)) {
                this.getProcess().removeCounter(this.counter);
            } else {
                this.getProcess().addCounter(this.counter);
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }

    public Process getProcess() {
        return (Process)this.getAffectedObject();
    }

    @Override
    public String getName() {
        return null;
    }
}

