/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.BusinessRuleTaskFeature;
import oracle.bpm.project.model.features.ScriptTaskFeature;
import oracle.bpm.project.model.features.UserTaskFeature;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;

public class ResetActivityImplementationCommand
extends ProjectCommand {
    private FlowNode node;

    public ResetActivityImplementationCommand(@NotNull FlowNode activity) {
        super(activity);
        this.node = activity;
    }

    public static void reset(FlowNode activity) {
        new ResetActivityImplementationCommand(activity).execute();
    }

    @Override
    public String getName() {
        return "";
    }

    public Object execute() throws ExecutionException {
        try {
            this.reset();
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return null;
    }

    public void reset() throws ProjectException {
        ScriptTaskFeature scriptTask;
        BusinessRuleTaskFeature businessRuleTaskFeature;
        UserTaskFeature userTaskFeature;
        if (this.node.isConversational()) {
            Conversational conversational = this.node.asAnyNode(Conversational.class);
            conversational.setConversation(null);
        }
        if ((userTaskFeature = this.node.getFeature(UserTaskFeature.class)) != null) {
            this.resetUserTask(userTaskFeature);
        }
        if ((businessRuleTaskFeature = this.node.getFeature(BusinessRuleTaskFeature.class)) != null) {
            this.resetBusinessRule(businessRuleTaskFeature);
        }
        if (this.node.isDataAssociationsEnabled()) {
            DataAssociationEnabled dataAssociationEnabled = this.node.asAnyNode(DataAssociationEnabled.class);
            if (dataAssociationEnabled.isInputDataAssociationEnabled()) {
                InputDataAssociationEnabled inputDataAssociationEnabled = dataAssociationEnabled.asAnyNode(InputDataAssociationEnabled.class);
                DataAssociationSet inputDataAssociationSet = inputDataAssociationEnabled.getInputDataAssociationSet();
                this.resetDataAssociationSet(inputDataAssociationSet);
            }
            if (dataAssociationEnabled.isOutputDataAssociationEnabled()) {
                OutputDataAssociationEnabled outputDataAssociationEnabled = dataAssociationEnabled.asAnyNode(OutputDataAssociationEnabled.class);
                DataAssociationSet outputDataAssociationSet = outputDataAssociationEnabled.getOutputDataAssociationSet();
                this.resetDataAssociationSet(outputDataAssociationSet);
            }
        }
        if ((scriptTask = this.node.getFeature(ScriptTaskFeature.class)) != null) {
            this.resetScript(scriptTask);
        }
    }

    private void resetUserTask(UserTaskFeature userTaskFeature) throws ProjectException {
        userTaskFeature.setHumanTask(null);
    }

    private void resetBusinessRule(BusinessRuleTaskFeature businessRuleTaskFeature) throws ProjectException {
        businessRuleTaskFeature.setBusinessRule(null);
    }

    private void resetScript(ScriptTaskFeature scriptTask) throws ProjectException {
        scriptTask.setScript(null);
    }

    private void resetDataAssociationSet(DataAssociationSet dataAssociationSet) {
        dataAssociationSet.clearDataAssociations();
    }
}

