/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import org.jetbrains.annotations.NotNull;

public class RemoveMeasurementCommand
extends ProjectCommand {
    private NodeContainer container;
    private boolean nop;

    public RemoveMeasurementCommand(@NotNull Measurement measurement) {
        super(measurement);
    }

    public Object execute() {
        Measurement measurement = this.getAffectedObject();
        this.container = measurement.getParentObject();
        if (this.container.contains(measurement)) {
            try {
                this.container.removeMeasurement(measurement);
            }
            catch (ProjectException e) {
                throw new ExecutionException((Throwable)((Object)e));
            }
        } else {
            this.nop = true;
        }
        return null;
    }

    @Override
    public void undo() {
        if (!this.nop) {
            try {
                this.container.addChild(this.getAffectedObject());
            }
            catch (ProjectException e) {
                throw new ExecutionException((Throwable)((Object)e));
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getAffectedObject().getDefaultLabel();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Measurement getAffectedObject() {
        return (Measurement)super.getAffectedObject();
    }
}

