/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.TranslateLaneCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class MoveLaneCommand
extends MultipleCommand {
    public MoveLaneCommand(@NotNull Lane lane, @NotNull Point offset) {
        super(lane);
        this.build(this.getOffsetForLocation(offset));
    }

    public MoveLaneCommand(@NotNull Lane lane, int offset) {
        super(lane);
        this.build(offset);
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.getAffectedObject().getId()).getString();
    }

    @Override
    public Lane getAffectedObject() {
        return (Lane)super.getAffectedObject();
    }

    private void build(int location) {
        Lane lane = this.getAffectedObject();
        Lane last = LaneUtils.getLastLane(this.getProcess());
        Lane target = LaneUtils.getLane(this.getProcess(), location);
        if (target == lane || target == null && lane == last) {
            return;
        }
        List<Lane> lanes = this.createLanes();
        if (target != null) {
            int sourceIndex = lanes.indexOf(lane);
            int targetIndex = lanes.indexOf(target);
            Collections.swap(lanes, sourceIndex, targetIndex);
        } else {
            lanes.remove(lane);
            lanes.add(lane);
        }
        int offset = 0;
        for (Lane affected : lanes) {
            if (affected.getOffset() != offset) {
                this.addCommand(new TranslateLaneCommand(affected, offset));
            }
            offset += affected.getSize();
        }
    }

    private List<Lane> createLanes() {
        ArrayList<Lane> copy = new ArrayList<Lane>();
        for (Lane lane : this.getProcess().getLanes()) {
            copy.add(lane);
        }
        return copy;
    }

    private int getOffsetForLocation(@NotNull Point location) {
        return ModelUtils.isHorizontal(this.getProcess()) ? location.getY() : location.getX();
    }

    private Process getProcess() {
        return this.getAffectedObject().getProcess();
    }
}

