/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.InsertActivityInTransitionCommand;
import oracle.bpm.project.command.design.MoveObjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.Nullable;

public class MoveFlowNodeCommand
extends MultipleCommand {
    private FlowNode flowNode;
    private int grid;
    private Point location;
    private boolean relocate;
    @Nullable
    private SequenceFlow transition;

    public MoveFlowNodeCommand(FlowNode flowNode, Point location, int grid) {
        this(flowNode, location, grid, null);
    }

    public MoveFlowNodeCommand(FlowNode flowNode, Point location, int grid, @Nullable SequenceFlow sequenceFlow) {
        this(flowNode, location, grid, sequenceFlow, false);
    }

    public MoveFlowNodeCommand(FlowNode flowNode, Point location, int grid, @Nullable SequenceFlow transition, boolean relocate) {
        super(flowNode);
        this.flowNode = flowNode;
        this.location = location;
        this.transition = transition;
        this.relocate = relocate;
        this.grid = grid;
        this.build();
    }

    public Point getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.getFlowNode().getLabelMap().getString()).getString();
    }

    private FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Nullable
    private SequenceFlow getTransition() {
        return this.transition;
    }

    private void build() {
        SequenceFlow sequenceFlow;
        this.addCommand(new MoveObjectCommand(this.getFlowNode(), this.getLocation(), this.grid));
        Point delta = this.location.sub(this.getFlowNode().getLocation());
        if (this.getFlowNode().isActivity()) {
            Activity activity = this.getFlowNode().asAnyNode(Activity.class);
            for (BoundaryEvent boundary : activity.getActivityBoundaryEvents()) {
                this.addCommand(new MoveFlowNodeCommand(boundary, boundary.getLocation().add(delta), this.grid));
            }
        }
        if ((sequenceFlow = this.getTransition()) != null && ModelUtils.canBeInsertedInTransition(this.getFlowNode(), sequenceFlow, this.relocate)) {
            this.addCommand(new InsertActivityInTransitionCommand(this.getFlowNode(), sequenceFlow));
        }
    }
}

