/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.changeset.ModelChangeSet;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.algorithms.KoreanLayoutAlgorithm;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class LayoutModelCommand
extends ProjectCommand {
    private ModelChangeSet changes;
    private boolean checkFirst;
    private final int grid;
    private final boolean optimize;

    public LayoutModelCommand(@NotNull Process process, boolean optimize) {
        this(process, optimize, true);
    }

    public LayoutModelCommand(@NotNull Process process, boolean optimize, boolean checkFirst) {
        this(process, 1, optimize, checkFirst);
    }

    public LayoutModelCommand(@NotNull Process process, int grid, boolean optimize) {
        this(process, grid, optimize, true);
    }

    public LayoutModelCommand(@NotNull Process process, int grid, boolean optimize, boolean checkFirst) {
        super(process);
        this.optimize = optimize;
        this.grid = grid;
        this.checkFirst = checkFirst;
    }

    public static Msg getMsg() {
        return ProjectCommandMsg.LAYOUT_MODEL;
    }

    @Override
    public String getName() {
        return LayoutModelCommand.getMsg().getString();
    }

    public Object execute() throws ExecutionException {
        try {
            if (ModelUtils.isHorizontal(this.getAffectedObject()) && (!this.checkFirst || this.checkLayoutable())) {
                this.calculateChanges();
                this.changes = this.changes.apply(this.getAffectedObject());
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            if (this.changes != null) {
                this.changes.apply(this.getAffectedObject());
                this.changes = null;
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public Process getAffectedObject() {
        return (Process)super.getAffectedObject();
    }

    public Sequence<ModelChangeSet.ModelChange> getModelChanges() throws ProjectException {
        this.calculateChanges();
        return this.changes.getModelChanges();
    }

    public boolean checkLayoutable() {
        return KoreanLayoutAlgorithm.checkLayoutable(this.getAffectedObject());
    }

    private void calculateChanges() throws ProjectException {
        if (this.changes == null) {
            KoreanLayoutAlgorithm algorithm = new KoreanLayoutAlgorithm(this.getAffectedObject(), this.grid, this.optimize);
            this.changes = algorithm.calculateChanges();
        }
    }
}

