/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;

public class InsertActivityInTransitionCommand
extends MultipleCommand {
    private FlowNode associatedNode;
    private FlowNode node;
    private SequenceFlow transition;

    public InsertActivityInTransitionCommand(FlowNode fuegoNode, SequenceFlow closestTransition) {
        this(fuegoNode, null, closestTransition);
    }

    public InsertActivityInTransitionCommand(FlowNode fuegoNode, FlowNode associatedNode, SequenceFlow closestTransition) {
        super(fuegoNode);
        this.node = fuegoNode;
        this.associatedNode = associatedNode == null ? fuegoNode : associatedNode;
        this.transition = closestTransition;
        this.buildMultipleCommand();
    }

    @Override
    public String getName() {
        return null;
    }

    public FlowNode getActivity() {
        return this.node;
    }

    private void buildMultipleCommand() {
        FlowNode newTarget = this.getActivity();
        this.addCommand(new ChangeTransitionTargetCommand(this.transition, newTarget));
        NodeAssociationFeature nodeAssociationFeature = this.getActivity().getFeature(NodeAssociationFeature.class);
        FlowNode sourceNode = this.associatedNode;
        if (this.associatedNode == null && nodeAssociationFeature != null) {
            sourceNode = nodeAssociationFeature.getAssociatedNode();
        }
        FlowNode target = this.transition.getTarget();
        if (sourceNode != null) {
            this.addCommand(new AddTransitionCommand(sourceNode.getParentObject(), sourceNode, target));
        }
    }
}

