/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddLaneCommand;
import oracle.bpm.project.command.design.AddMeasurementCommand;
import oracle.bpm.project.command.design.AddNoteCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.command.design.InsertActivityInTransitionCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AssociatedNodeFeature;
import oracle.bpm.project.model.features.CurveTransitionFeature;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.Nullable;

public abstract class CopyPasteHelper {
    private transient Collection<FlowElement> copiedElements;
    private Rectangle copiedElementsRectangle;
    private String copiedObjectsId;
    private transient HashBiMap<String, String> idsMap;
    private boolean inTransition;
    private Map<String, FlowNode> newNodesByOldId = new HashMap<String, FlowNode>();
    private Map<String, SequenceFlow> newTransitionByOldId = new HashMap<String, SequenceFlow>();
    private static final String SUBPROCESS = "Subprocess";
    private static final Dimension DEFAULT_SUBPROCESS_SIZE = Dimension.valueOf((int)350, (int)200);
    private static final int NEW_SUBPROCESS_ACTIVITY_AUX_SIZE = 85;

    public static Collection<FlowElement> normalizeForCopy(Collection<FlowElement> elements) {
        TreeSet<FlowElement> normalizedObjects = new TreeSet<FlowElement>(new Comparator<FlowElement>(){

            @Override
            public int compare(FlowElement o1, FlowElement o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        normalizedObjects.addAll(elements);
        CopyPasteHelper.normalizeActivitiesForCopy(normalizedObjects);
        CopyPasteHelper.normalizeBoundedEventsForCopy(normalizedObjects);
        CopyPasteHelper.normalizeSequenceFlowsForCopy(normalizedObjects);
        CopyPasteHelper.normalizeMeasurementsForCopy(normalizedObjects);
        return normalizedObjects;
    }

    public static Collection<FlowElement> normalizeForCut(Collection<FlowElement> objects) {
        Collection<FlowElement> normalizedObjects = CopyPasteHelper.normalizeForCopy(objects);
        CopyPasteHelper.normalizeActivities(normalizedObjects);
        return normalizedObjects;
    }

    public static Sequence<FlowNode> getAllActivities(Collection<FlowElement> normalizedObjects) {
        return CollectionUtils.selectInstanceOf((Sequence)CollectionUtils.asSequence(new ArrayList<FlowElement>(normalizedObjects)), FlowNode.class);
    }

    public static Sequence<SequenceFlow> getTransitions(Collection<FlowElement> normalizedObjects) {
        return CollectionUtils.selectInstanceOf((Sequence)CollectionUtils.asSequence(new ArrayList<FlowElement>(normalizedObjects)), SequenceFlow.class);
    }

    public Collection<FlowElement> getCopiedElements() {
        if (this.copiedElements == null) {
            String[] ids = this.copiedObjectsId.split(",");
            this.copiedElements = this.getCopiedElements(ids);
        }
        return this.copiedElements;
    }

    public void clearCopiedElements() {
        this.copiedElements = null;
        this.clearIdsMap();
        this.inTransition = false;
    }

    public void addToIdsMap(String newId, String oldId) {
        if (this.idsMap == null) {
            this.idsMap = new HashBiMap();
        }
        if (!this.idsMap.containsKey((Object)newId)) {
            this.idsMap.forcePut((Object)newId, (Object)oldId);
        }
    }

    public String getOldId(String newId) {
        return (String)this.idsMap.get((Object)newId);
    }

    public String getNewId(String oldId) {
        return this.idsMap != null ? (String)this.idsMap.inverse().get((Object)oldId) : null;
    }

    public void setCopiedElementsRectangle(Collection<? extends FlowElement> copiedObjects) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        int elemHeight = 85;
        int elemWidth = 85;
        for (FlowElement flowElement : copiedObjects) {
            if (!(flowElement instanceof Positional) || flowElement instanceof FlowNode && ModelUtils.isBoundaryEvent((FlowNode)flowElement)) continue;
            Positional positional = (Positional)((Object)flowElement);
            int elemX = positional.getX();
            int elemY = positional.getY();
            if (flowElement instanceof Subprocess && !flowElement.getFeature(IsCollapsedFeature.class).getValue().booleanValue()) {
                elemHeight += positional.getHeight();
                elemWidth += positional.getWidth();
            }
            maxX = elemX + elemWidth > maxX ? elemX + elemWidth : maxX;
            maxY = elemY + elemHeight > maxY ? elemY + elemHeight : maxY;
            minX = elemX < minX ? elemX : minX;
            minY = elemY < minY ? elemY : minY;
        }
        this.copiedElementsRectangle = new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public void copyNodes(String csvNodesIds) {
        String[] ids = csvNodesIds.split(",");
        this.copiedElements = this.getCopiedElements(ids);
        this.setCopiedObjectsIds();
    }

    public void copyElements(Collection<FlowElement> collection) {
        this.copiedElements = collection;
        this.setCopiedObjectsIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteElements(String modelId, Point clickLocation) {
        MultipleCommand pasteCommand = new MultipleCommand(new ProjectObject[0]);
        try {
            List<FlowElement> realCopiedElements;
            boolean singleMeasurement;
            NodeContainer container = this.getNodeContainer(modelId);
            ArrayList<FlowElement> finalCopies = new ArrayList<FlowElement>();
            ArrayList<SequenceFlow> newTransitions = new ArrayList<SequenceFlow>();
            ArrayList<SequenceFlow> reconnections = new ArrayList<SequenceFlow>();
            ArrayList<TextAnnotation> textsAnnotations = new ArrayList<TextAnnotation>();
            ArrayList<Measurement> measurements = new ArrayList<Measurement>();
            List<FlowNode> storedNodes = this.getNodes(this.getCopiedElements());
            this.setCopiedElementsRectangle(this.getCopiedElements());
            boolean singleNode = storedNodes.size() == 1;
            Sequence<Measurement> copiedMeasurements = CopyPasteHelper.getAllMeasurements(this.getCopiedElements());
            boolean bl = singleMeasurement = CollectionUtils.size(copiedMeasurements) == 1;
            if (singleNode || singleMeasurement) {
                realCopiedElements = this.realCopyElements(this.getCopiedElements(), container, clickLocation, pasteCommand, false);
                FlowElement node = realCopiedElements.get(0);
                finalCopies.addAll(realCopiedElements);
                SequenceFlow transition = container.findSequenceFlow(modelId);
                if (transition != null) {
                    this.inTransition = true;
                    if (singleNode) {
                        FlowNode flowNode = (FlowNode)node;
                        InsertActivityInTransitionCommand transitionCommand = new InsertActivityInTransitionCommand(flowNode, transition);
                        transitionCommand.execute();
                        pasteCommand.addCommand(transitionCommand);
                        newTransitions.add((SequenceFlow)flowNode.getOutgoingSequenceFlows().iterator().next());
                        reconnections.add((SequenceFlow)flowNode.getIncomingSequenceFlows().iterator().next());
                    } else {
                        ((Measurement)node).setTransition(modelId);
                        ((Measurement)node).setLocation(clickLocation.add(0, 50));
                    }
                }
            } else {
                SequenceFlow transition = this.getCurrentProcess().findDescendant(SequenceFlow.class, modelId);
                if (transition != null) {
                    this.inTransition = true;
                    clickLocation = clickLocation.add(0, this.copiedElementsRectangle.getHeight() / 3);
                    realCopiedElements = this.realCopyElements(this.getCopiedElements(), container, clickLocation, pasteCommand, false);
                    List<FlowNode> realCopiedNodes = this.getNodes(realCopiedElements);
                    this.regenerateNodeStructure(clickLocation, realCopiedNodes, storedNodes, container);
                    List<FlowNode> reconnectionNodes = this.getReconnectionNodes(realCopiedNodes);
                    if (!reconnectionNodes.isEmpty()) {
                        SequenceFlow finalReconnection = container.createSequenceFlow(reconnectionNodes.get(1), transition.getTarget());
                        AddTransitionCommand finalReconnectionCmd = new AddTransitionCommand(finalReconnection);
                        finalReconnectionCmd.execute();
                        pasteCommand.addCommand(finalReconnectionCmd);
                        ChangeTransitionTargetCommand initialReconnectionCmd = new ChangeTransitionTargetCommand(transition, reconnectionNodes.get(0));
                        initialReconnectionCmd.execute();
                        pasteCommand.addCommand(initialReconnectionCmd);
                        reconnections.add(transition);
                        newTransitions.add(finalReconnection);
                    } else {
                        this.setNodesNewPosition(realCopiedNodes, clickLocation);
                        this.regenerateNodeStructure(clickLocation, realCopiedNodes, storedNodes, container);
                    }
                    finalCopies.addAll(realCopiedElements);
                    newTransitions.addAll(this.getSequenceFlows(realCopiedElements));
                } else {
                    realCopiedElements = this.realCopyElements(this.getCopiedElements(), container, clickLocation, pasteCommand, false);
                    this.regenerateNodeStructure(clickLocation, this.getNodes(realCopiedElements), storedNodes, container);
                    finalCopies.addAll(realCopiedElements);
                    newTransitions.addAll(this.getSequenceFlows(realCopiedElements));
                }
            }
            List<Object> newLanes = container.is(Process.class) ? this.generateNewLanes(this.getNodes(finalCopies), (Process)container, pasteCommand) : Collections.emptyList();
            textsAnnotations.addAll(this.getTextAnnotations(realCopiedElements));
            measurements.addAll(this.getMeasurements(realCopiedElements));
            if (!(finalCopies.isEmpty() && newTransitions.isEmpty() && reconnections.isEmpty() && newLanes.isEmpty() && textsAnnotations.isEmpty() && measurements.isEmpty())) {
                this.addExecutedCommand(pasteCommand);
                this.syncWithClient(this.getNodes(finalCopies), newTransitions, reconnections, newLanes, textsAnnotations, measurements);
            }
            this.inTransition = false;
        }
        catch (ProjectException e) {
            this.addErrorMessage((Exception)((Object)e));
        }
        finally {
            if (this.idsMap != null) {
                this.idsMap.clear();
            }
        }
    }

    protected abstract void addExecutedCommand(MultipleCommand var1);

    protected abstract void addErrorMessage(Exception var1);

    protected abstract NodeContainer getCurrentProcess();

    protected abstract void syncWithClient(List<FlowNode> var1, List<SequenceFlow> var2, List<SequenceFlow> var3, List<Lane> var4, List<TextAnnotation> var5, List<Measurement> var6) throws ProjectException;

    private static void normalizeActivities(Collection<FlowElement> normalizedObjects) {
        Sequence<FlowNode> allActivities = CopyPasteHelper.getAllActivities(normalizedObjects);
        Sequence<Lane> allLanes = CopyPasteHelper.getAllLanes(normalizedObjects);
        for (FlowNode allActivity : allActivities) {
            if (allLanes.contains((Object)allActivity.getLane())) {
                normalizedObjects.remove(allActivity);
                continue;
            }
            if (allActivities.contains((Object)allActivity.getParentScope())) {
                normalizedObjects.remove(allActivity);
                continue;
            }
            if (!ModelUtils.isAnyJoin(allActivity)) continue;
            normalizedObjects.remove(allActivity);
        }
    }

    private static void normalizeSequenceFlowsForCopy(TreeSet<FlowElement> normalizedObjects) {
        Sequence<FlowNode> allActivities = CopyPasteHelper.getAllActivities(normalizedObjects);
        Sequence<SequenceFlow> seqFlows = CopyPasteHelper.getTransitions(normalizedObjects);
        for (SequenceFlow seqFlow : seqFlows) {
            if (allActivities.contains((Object)seqFlow.getSource()) && allActivities.contains((Object)seqFlow.getTarget())) continue;
            normalizedObjects.remove(seqFlow);
        }
    }

    private static void normalizeActivitiesForCopy(TreeSet<FlowElement> normalizedObjects) {
        Sequence splitActivities = CollectionUtils.asSequence(normalizedObjects).select((Predicate)new Predicate<FlowElement>(){

            public boolean check(FlowElement value) {
                return value instanceof FlowNode && ModelUtils.isAnySplit((FlowNode)value);
            }
        });
        ArrayList<Gateway> addedNodes = new ArrayList<Gateway>();
        for (FlowElement splitActivity : splitActivities) {
            Gateway gateway = ((FlowNode)splitActivity).asAnyNode(Gateway.class);
            Gateway mergingGateway = gateway.getMergingGateway();
            if (mergingGateway == null) continue;
            addedNodes.add(mergingGateway);
        }
        Iterator<FlowElement> iterator = normalizedObjects.iterator();
        while (iterator.hasNext()) {
            FlowElement normalizedObject = iterator.next();
            ProjectObject parentObject = normalizedObject.getParentObject();
            if (!(normalizedObject instanceof FlowNode) || !(parentObject instanceof Subprocess) || !normalizedObjects.contains(parentObject)) continue;
            iterator.remove();
        }
        normalizedObjects.addAll(addedNodes);
    }

    private static void normalizeMeasurementsForCopy(TreeSet<FlowElement> normalizedObjects) {
        Sequence<Measurement> allMeasurements = CopyPasteHelper.getAllMeasurements(normalizedObjects);
        Sequence<SequenceFlow> seqFlows = CopyPasteHelper.getTransitions(normalizedObjects);
        if (CollectionUtils.size(allMeasurements) > 1) {
            for (Measurement measurement : allMeasurements) {
                if (seqFlows.contains((Object)measurement.getTransition())) continue;
                normalizedObjects.remove(measurement);
            }
        }
    }

    private static void normalizeBoundedEventsForCopy(TreeSet<FlowElement> normalizedObjects) {
        Sequence boundaries = CollectionUtils.select((Iterable)CollectionUtils.asSequence(normalizedObjects), (Predicate)new Predicate<FlowElement>(){

            public boolean check(FlowElement value) {
                return value instanceof FlowNode && ModelUtils.isBoundaryEvent((FlowNode)value);
            }
        });
        ArrayList<FlowElement> toBeDeleted = new ArrayList<FlowElement>();
        for (FlowElement event : boundaries) {
            Activity activity = ((BoundaryEvent)event).getBoundaryActivity();
            if (normalizedObjects.contains(activity)) continue;
            toBeDeleted.add(event);
        }
        for (FlowElement event : toBeDeleted) {
            normalizedObjects.remove(event);
        }
    }

    private static Sequence<Lane> getAllLanes(Collection<FlowElement> normalizedObjects) {
        return CollectionUtils.selectInstanceOf((Sequence)CollectionUtils.asSequence(new ArrayList<FlowElement>(normalizedObjects)), Lane.class);
    }

    private static Sequence<Measurement> getAllMeasurements(Collection<FlowElement> normalizedObjects) {
        return CollectionUtils.selectInstanceOf((Sequence)CollectionUtils.asSequence(new ArrayList<FlowElement>(normalizedObjects)), Measurement.class);
    }

    private void setNodesNewPosition(List<FlowNode> realCopiedNodes, Point newLocation) {
        for (FlowNode node : realCopiedNodes) {
            node.setLocation(newLocation);
        }
    }

    private List<FlowNode> getReconnectionNodes(Collection<FlowNode> copiedNodes) {
        ArrayList<FlowNode> nodesToConnect = new ArrayList<FlowNode>(2);
        int nodesWithNoIncoming = 0;
        int nodesWithNoOutgoing = 0;
        FlowNode firstNode = null;
        FlowNode lastNode = null;
        for (FlowNode node : copiedNodes) {
            if (node.getOutgoingSequenceFlows().isEmpty() && node.getOutgoingConditionalFlows().isEmpty()) {
                if (++nodesWithNoOutgoing > 1) {
                    return nodesToConnect;
                }
                lastNode = node;
                continue;
            }
            if (!node.getIncomingSequenceFlows().isEmpty()) continue;
            if (++nodesWithNoIncoming > 1) {
                return nodesToConnect;
            }
            firstNode = node;
        }
        if (nodesWithNoIncoming == 1 && nodesWithNoOutgoing == 1) {
            nodesToConnect.add(firstNode);
            nodesToConnect.add(lastNode);
        }
        return nodesToConnect;
    }

    private List<Lane> generateNewLanes(List<FlowNode> nodes, Process process, MultipleCommand pasteCommand) {
        ArrayList<Lane> newLanes = new ArrayList<Lane>();
        for (FlowNode node : nodes) {
            if (node.getLane() != null) continue;
            Lane newLane = process.createLane(ModelUtils.generateLaneId(process));
            LaneUtils.setOffsetAfterLastLane(newLane);
            newLanes.add(newLane);
            int size = 100 + node.getY() - newLane.getOffset();
            AddLaneCommand addLaneCommand = new AddLaneCommand(newLane, newLane.getOffset(), size, false);
            addLaneCommand.execute();
            pasteCommand.addCommand(addLaneCommand);
        }
        return newLanes;
    }

    private List<FlowElement> getCopiedElements(String[] ids) {
        Collection<FlowElement> copiedElements = new ArrayList<FlowElement>();
        if (this.getCurrentProcess() != null) {
            LinkedList<BoundaryEvent> boundaries = new LinkedList<BoundaryEvent>();
            for (String id : ids) {
                FlowElement flowElement = this.getCurrentProcess().findDescendant(FlowElement.class, id);
                if (flowElement == null) continue;
                copiedElements.add(flowElement);
                if (!flowElement.is(BoundaryEvent.class)) continue;
                boundaries.add((BoundaryEvent)flowElement);
            }
            copiedElements = CopyPasteHelper.normalizeForCopy(copiedElements);
            for (BoundaryEvent boundary : boundaries) {
                if (!copiedElements.contains(boundary) || copiedElements.contains(((SequenceFlow)boundary.getOutgoingSequenceFlows().iterator().next()).getTarget())) continue;
                copiedElements.remove(boundary);
            }
        }
        return new ArrayList<FlowElement>(copiedElements);
    }

    private List<SequenceFlow> copySequenceFlows(List<FlowNode> copiedNodes, Subprocess subprocessCopy) throws ProjectException {
        ArrayList<SequenceFlow> copiedSequenceFlows = new ArrayList<SequenceFlow>();
        for (FlowNode copiedNode : copiedNodes) {
            SequenceFlow copy;
            for (SequenceFlow sequenceFlow : copiedNode.getIncomingSequenceFlows()) {
                if (!this.containsNode(copiedNodes, sequenceFlow.getSource())) continue;
                copy = subprocessCopy.createSequenceFlow();
                copy.applyFrom(sequenceFlow);
                copy.setTarget(copiedNode);
                copy.setSource(this.findNodeById(copiedNodes, copy.getSource().getId()));
                if (this.containsTransition(copiedSequenceFlows, copy)) continue;
                copiedSequenceFlows.add(copy);
            }
            for (SequenceFlow sequenceFlow : copiedNode.getOutgoingSequenceFlows()) {
                if (!this.containsNode(copiedNodes, sequenceFlow.getTarget())) continue;
                copy = subprocessCopy.createSequenceFlow();
                copy.applyFrom(sequenceFlow);
                copy.setSource(copiedNode);
                copy.setTarget(this.findNodeById(copiedNodes, copy.getTarget().getId()));
                if (this.containsTransition(copiedSequenceFlows, copy)) continue;
                copiedSequenceFlows.add(copy);
            }
            for (SequenceFlow sequenceFlow : copiedNode.getOutgoingConditionalFlows()) {
                if (!this.containsNode(copiedNodes, sequenceFlow.getTarget())) continue;
                copy = subprocessCopy.createSequenceFlow();
                copy.applyFrom(sequenceFlow);
                copy.setTarget(this.findNodeById(copiedNodes, copy.getTarget().getId()));
                if (this.containsTransition(copiedSequenceFlows, copy)) continue;
                copiedSequenceFlows.add(copy);
            }
        }
        return copiedSequenceFlows;
    }

    private boolean containsNode(List<? extends FlowNode> copiedNodes, FlowNode source) {
        boolean result = false;
        for (FlowNode flowNode : copiedNodes) {
            if (!flowNode.getId().equals(source.getId())) continue;
            result = true;
            break;
        }
        return result;
    }

    private FlowNode findNodeById(List<FlowNode> copiedNodes, String nodeId) {
        FlowNode result = null;
        for (FlowNode currentNode : copiedNodes) {
            if (!currentNode.getId().equals(nodeId)) continue;
            result = currentNode;
            break;
        }
        return result;
    }

    private List<SequenceFlow> getSequenceFlows(Collection<FlowElement> realCopies) {
        ArrayList<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();
        for (FlowElement element : realCopies) {
            if (!element.is(SequenceFlow.class)) continue;
            sequenceFlows.add((SequenceFlow)element);
        }
        return sequenceFlows;
    }

    private List<TextAnnotation> getTextAnnotations(Collection<FlowElement> realCopies) {
        ArrayList<TextAnnotation> textAnnotations = new ArrayList<TextAnnotation>();
        for (FlowElement element : realCopies) {
            if (!element.is(TextAnnotation.class)) continue;
            textAnnotations.add((TextAnnotation)element);
        }
        return textAnnotations;
    }

    private List<Measurement> getMeasurements(Collection<FlowElement> realCopies) {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        for (FlowElement element : realCopies) {
            if (!element.is(Measurement.class)) continue;
            measurements.add((Measurement)element);
        }
        return measurements;
    }

    private List<FlowNode> getNodes(Collection<FlowElement> realCopies) {
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        for (FlowElement element : realCopies) {
            if (!element.is(FlowNode.class)) continue;
            nodes.add((FlowNode)element);
        }
        return nodes;
    }

    private List<FlowElement> getChildFlowElements(Subprocess subprocess) {
        ArrayList<FlowElement> elements = new ArrayList<FlowElement>();
        for (ProjectObject child : subprocess.getChildren()) {
            if (!child.is(FlowElement.class)) continue;
            elements.add((FlowElement)child);
        }
        return elements;
    }

    private void setCopiedObjectsIds() {
        StringBuilder csv = new StringBuilder();
        for (FlowElement copy : this.getCopiedElements()) {
            csv.append(copy.getId());
            csv.append(",");
        }
        if (csv.length() > 0) {
            this.copiedObjectsId = csv.substring(0, csv.length() - 1);
        }
    }

    private void clearIdsMap() {
        if (this.idsMap != null) {
            this.idsMap.clear();
        }
    }

    private void copySubprocessChildren(Subprocess storedSubprocess, Subprocess subprocessCopy) {
        ArrayList<FlowElement> nodeCopies = new ArrayList<FlowElement>();
        try {
            FlowNode nodeCopy;
            for (FlowNode node : storedSubprocess.getFlowNodes()) {
                if (node instanceof Subprocess) {
                    Subprocess storedNewSubprocess = (Subprocess)node;
                    nodeCopy = storedSubprocess.copy();
                    Subprocess subprocessSonCopy = (Subprocess)nodeCopy;
                    subprocessSonCopy.setLocation(storedNewSubprocess.getLocation());
                    subprocessSonCopy.setWidth(storedNewSubprocess.getWidth());
                    subprocessSonCopy.setHeight(storedNewSubprocess.getHeight());
                    this.setCollapsed(subprocessSonCopy, this.isCollapsed(storedNewSubprocess));
                    this.copySubprocessChildren(storedNewSubprocess, subprocessSonCopy);
                } else {
                    nodeCopy = node.copy();
                    nodeCopy.setLocation(node.getLocation());
                }
                nodeCopies.add(nodeCopy);
            }
            for (FlowNode node : storedSubprocess.getBoundaryEvents()) {
                nodeCopy = node.copy();
                nodeCopies.add(nodeCopy);
            }
            nodeCopies.addAll(this.copySequenceFlows(this.getNodes(nodeCopies), subprocessCopy));
            for (FlowElement child : nodeCopies) {
                String originalId = child.getId();
                subprocessCopy.addChild(child);
                child.setId(originalId);
            }
        }
        catch (ProjectException e) {
            this.addErrorMessage((Exception)((Object)e));
        }
    }

    private void recreateSubprocess(Subprocess subprocessCopy, Subprocess storedSubprocess, Point clickLocation, MultipleCommand pasteCommand) throws ProjectException {
        List<FlowElement> storedChildren = this.getChildFlowElements(storedSubprocess);
        this.realCopyElements(storedChildren, subprocessCopy, clickLocation, pasteCommand, true);
    }

    private NodeContainer getNodeContainer(String modelId) {
        SequenceFlow transition;
        NodeContainer nodeContainer = modelId == null ? this.getCurrentProcess() : ((transition = this.getCurrentProcess().findDescendant(SequenceFlow.class, modelId)) == null ? (NodeContainer)this.getCurrentProcess().findDescendant(Subprocess.class, modelId) : transition.getParentObject());
        return nodeContainer;
    }

    private Point getNewLocation(Point clickLocation, Point originalLocation) {
        Point originPoint = this.copiedElementsRectangle.getCenter();
        Point targetPoint = clickLocation.add(this.copiedElementsRectangle.getWidth() / 2, this.copiedElementsRectangle.getHeight() / 2);
        Dimension delta = originalLocation.delta(originPoint);
        return targetPoint.translate(delta);
    }

    private void regenerateNodeStructure(Point clickLocation, List<FlowNode> realCopiedNodes, List<FlowNode> storedNodes, NodeContainer container) {
        Point originPoint = this.copiedElementsRectangle.getCenter();
        Point targetPoint = container.is(Subprocess.class) && this.inTransition ? new Point(((Subprocess)container).getWidth() / 2 + 45, ((Subprocess)container).getHeight() / 2 + 30) : clickLocation.add(this.copiedElementsRectangle.getWidth() / 2, this.copiedElementsRectangle.getHeight() / 2);
        for (final FlowNode realCopiedNode : realCopiedNodes) {
            Point currentStoredPoint = ((FlowNode)CollectionUtils.select(storedNodes, (Predicate)new Predicate<FlowNode>(){

                public boolean check(@Nullable FlowNode value) {
                    return realCopiedNode.getId().equals(CopyPasteHelper.this.getNewId(value.getId()));
                }
            }).iterator().next()).getLocation();
            Dimension delta = currentStoredPoint.delta(originPoint);
            realCopiedNode.setLocation(targetPoint.translate(delta));
        }
    }

    private boolean containsTransition(List<SequenceFlow> newTransitions, SequenceFlow newTransition) {
        boolean result = false;
        for (SequenceFlow transition : newTransitions) {
            if (!transition.getSource().equals(newTransition.getSource()) || !transition.getTarget().equals(newTransition.getTarget())) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<FlowElement> realCopyElements(Collection<FlowElement> storedElements, NodeContainer nodeContainer, Point clickLocation, MultipleCommand pasteCommand, boolean ignoreClick) throws ProjectException {
        LinkedList<FlowElement> nodesCopies = new LinkedList<FlowElement>();
        List<FlowElement> realCopiedNodes = this.realCopyNodes((Iterable<FlowNode>)CollectionUtils.select(this.getNodes(storedElements), (Predicate)new Predicate<FlowNode>(){

            public boolean check(@Nullable FlowNode flowNode) {
                return !ModelUtils.isBoundaryEvent(flowNode);
            }
        }), nodeContainer, clickLocation, pasteCommand, ignoreClick);
        List<FlowElement> realCopiedBoundaries = this.realCopyNodes((Iterable<FlowNode>)CollectionUtils.select(this.getNodes(storedElements), (Predicate)new Predicate<FlowNode>(){

            public boolean check(@Nullable FlowNode flowNode) {
                return ModelUtils.isBoundaryEvent(flowNode);
            }
        }), nodeContainer, clickLocation, pasteCommand, ignoreClick);
        List<SequenceFlow> realCopiedSequenceFlows = this.realCopySequenceFlows(this.getSequenceFlows(storedElements), nodeContainer, pasteCommand);
        List<TextAnnotation> realCopiedTextAnnotations = this.realCopyTextAnnotations(this.getTextAnnotations(storedElements), nodeContainer, pasteCommand, clickLocation);
        List<Measurement> realCopiedMeasurements = this.realCopyMeasurements(this.getMeasurements(storedElements), nodeContainer, pasteCommand, clickLocation, ignoreClick);
        nodesCopies.addAll(realCopiedNodes);
        nodesCopies.addAll(realCopiedBoundaries);
        nodesCopies.addAll(realCopiedSequenceFlows);
        nodesCopies.addAll(realCopiedTextAnnotations);
        nodesCopies.addAll(realCopiedMeasurements);
        return nodesCopies;
    }

    private List<FlowElement> realCopyNodes(Iterable<FlowNode> nodesToCopy, NodeContainer nodeContainer, Point clickLocation, MultipleCommand pasteCommand, boolean ignoreClick) throws ProjectException {
        LinkedList<FlowElement> nodesCopies = new LinkedList<FlowElement>();
        for (FlowNode storedNode : nodesToCopy) {
            FlowNode boundaryTarget;
            Activity foundActivity;
            Iterator iterator;
            AddActivityCommand command;
            FlowNode realCopyNode = (FlowNode)this.realCopyNode(storedNode, nodeContainer);
            if (storedNode.is(Subprocess.class)) {
                realCopyNode.setId(ModelUtils.nextNameForSubprocess(nodeContainer, storedNode.getName()));
                realCopyNode.setWidth(storedNode.getWidth());
                realCopyNode.setHeight(storedNode.getHeight());
                realCopyNode.setLocation(clickLocation);
                this.setCollapsed((Subprocess)realCopyNode, this.isCollapsed((Subprocess)storedNode));
                nodesCopies.add(realCopyNode);
                command = new AddActivityCommand(realCopyNode, clickLocation);
                command.execute();
                pasteCommand.addCommand(command);
                realCopyNode.clear();
                this.recreateSubprocess((Subprocess)realCopyNode, (Subprocess)storedNode, clickLocation, pasteCommand);
            } else {
                command = new AddActivityCommand(realCopyNode, ignoreClick ? storedNode.getLocation() : clickLocation);
                command.execute();
                pasteCommand.addCommand(command);
                nodesCopies.add(realCopyNode);
            }
            if (storedNode.is(BoundaryEvent.class) && (iterator = storedNode.getOutgoingSequenceFlows().iterator()).hasNext() && (foundActivity = nodeContainer.findActivity(this.getNewId((boundaryTarget = ((SequenceFlow)iterator.next()).getTarget()).getId()))) != null) {
                SequenceFlow flow = nodeContainer.createSequenceFlow(realCopyNode, foundActivity);
                AddTransitionCommand transitionCommand = new AddTransitionCommand(flow);
                transitionCommand.execute();
                pasteCommand.addCommand(transitionCommand);
            }
            this.addToIdsMap(realCopyNode.getId(), storedNode.getId());
        }
        return nodesCopies;
    }

    private void setCollapsed(Subprocess realCopy, boolean isCollapsed) {
        realCopy.getFeature(IsCollapsedFeature.class).setValue(isCollapsed);
    }

    private Boolean isCollapsed(Subprocess storedNewSubprocess) {
        return storedNewSubprocess.getFeature(IsCollapsedFeature.class).getValue();
    }

    private List<SequenceFlow> realCopySequenceFlows(List<SequenceFlow> storedSequenceFlows, NodeContainer nodeContainer, MultipleCommand pasteCommand) throws ProjectException {
        LinkedList<SequenceFlow> copies = new LinkedList<SequenceFlow>();
        for (SequenceFlow storedElement : storedSequenceFlows) {
            if (storedElement.getSource().is(BoundaryEvent.class)) continue;
            SequenceFlow realCopy = nodeContainer.createSequenceFlow();
            realCopy.applyFrom(storedElement);
            realCopy.setSource(nodeContainer.findDescendant(FlowNode.class, this.getNewId(realCopy.getSource().getId())));
            realCopy.setTarget(nodeContainer.findDescendant(FlowNode.class, this.getNewId(realCopy.getTarget().getId())));
            Point newControlPointDelta = storedElement.getControlPoint().sub(storedElement.getSource().getLocation());
            Point newControlPoint = realCopy.getSource().getLocation().add(newControlPointDelta);
            realCopy.getFeature(CurveTransitionFeature.class).setControlPoint(newControlPoint);
            AddTransitionCommand command = new AddTransitionCommand(realCopy);
            command.execute();
            pasteCommand.addCommand(command);
            this.addToIdsMap(realCopy.getId(), storedElement.getId());
            copies.add(realCopy);
        }
        return copies;
    }

    private List<TextAnnotation> realCopyTextAnnotations(List<TextAnnotation> storedSequenceFlows, NodeContainer nodeContainer, MultipleCommand pasteCommand, Point clickLocation) throws ProjectException {
        LinkedList<TextAnnotation> copies = new LinkedList<TextAnnotation>();
        for (TextAnnotation storedElement : storedSequenceFlows) {
            TextAnnotation realCopy = nodeContainer.createTextAnnotation(ModelUtils.nextIdForTextAnnotation(nodeContainer));
            realCopy.applyFrom(storedElement);
            String oldNodeId = storedElement.getFeature(AssociatedNodeFeature.class).getValue();
            if (oldNodeId == null) {
                oldNodeId = storedElement.getFeature(AssociatedNodeFeature.class).getPrevValue();
            }
            realCopy.setTarget(nodeContainer.findDescendant(FlowNode.class, this.getNewId(oldNodeId)));
            copies.add(realCopy);
            AddNoteCommand command = new AddNoteCommand(realCopy, this.getNewLocation(clickLocation, storedElement.getLocation()));
            command.execute();
            pasteCommand.addCommand(command);
        }
        return copies;
    }

    private List<Measurement> realCopyMeasurements(List<Measurement> copiedMeasurements, NodeContainer nodeContainer, MultipleCommand pasteCommand, Point clickLocation, boolean ignoreClick) throws ProjectException {
        LinkedList<Measurement> copies = new LinkedList<Measurement>();
        for (Measurement storedElement : copiedMeasurements) {
            Measurement realCopy = nodeContainer.createMeasurement(ModelUtils.nextNameForMeasurement(storedElement.getProcess(), storedElement.getId()));
            realCopy.applyFrom(storedElement);
            String oldNodeId = storedElement.getTransitionId();
            SequenceFlow sequenceFlow = nodeContainer.findSequenceFlow(this.getNewId(oldNodeId));
            realCopy.setTransition(sequenceFlow);
            copies.add(realCopy);
            AddMeasurementCommand command = new AddMeasurementCommand(realCopy, sequenceFlow, ignoreClick ? storedElement.getLocation() : this.getNewLocation(clickLocation, storedElement.getLocation()));
            command.execute();
            pasteCommand.addCommand(command);
        }
        return copies;
    }

    private FlowElement realCopyNode(FlowNode toPasteFlowNode, NodeContainer nodeContainer) throws ProjectException {
        FlowNode finalCopy;
        if (toPasteFlowNode instanceof NodeContainer) {
            Subprocess subprocessToCopy = (Subprocess)toPasteFlowNode;
            finalCopy = nodeContainer.createSubprocess(subprocessToCopy.isTriggeredByEvent());
            finalCopy.applyFrom(subprocessToCopy);
        } else if (toPasteFlowNode.isActivity()) {
            finalCopy = nodeContainer.createActivity();
            finalCopy.applyFrom(toPasteFlowNode);
        } else if (toPasteFlowNode.isGateway()) {
            String associatedNodeId;
            Gateway toPasteGateway = (Gateway)toPasteFlowNode;
            switch (toPasteGateway.getBpmnType()) {
                case EVENT_BASED_GATEWAY: {
                    finalCopy = nodeContainer.createEventBasedGateway();
                    break;
                }
                case EXCLUSIVE_GATEWAY: {
                    finalCopy = nodeContainer.createExclusiveGateway();
                    break;
                }
                case INCLUSIVE_GATEWAY: {
                    finalCopy = nodeContainer.createInclusiveGateway();
                    break;
                }
                case PARALLEL_GATEWAY: {
                    finalCopy = nodeContainer.createParallelGateway();
                    break;
                }
                default: {
                    finalCopy = nodeContainer.createComplexGateway();
                }
            }
            Gateway gateway = (Gateway)finalCopy;
            gateway.applyFrom(toPasteFlowNode);
            NodeAssociationFeature association = gateway.getFeature(NodeAssociationFeature.class);
            if (association != null && (associatedNodeId = this.getNewId(association.getAssociatedNodeId())) != null) {
                association.setAssociatedNode(associatedNodeId);
                association.getAssociatedNode().getFeature(NodeAssociationFeature.class).setAssociatedNode(gateway.getId());
            }
        } else {
            Event event = (Event)toPasteFlowNode;
            EventTriggerType eventTriggerType = event.getEventTriggerType();
            switch (toPasteFlowNode.getBpmnType()) {
                case START_EVENT: {
                    finalCopy = nodeContainer.createStartEvent(eventTriggerType);
                    break;
                }
                case END_EVENT: {
                    finalCopy = nodeContainer.createEndEvent(eventTriggerType);
                    break;
                }
                case BOUNDARY_EVENT: {
                    BoundaryEvent boundaryEvent = (BoundaryEvent)toPasteFlowNode;
                    finalCopy = nodeContainer.createBoundaryEvent(eventTriggerType, nodeContainer.findActivity(this.getNewId(boundaryEvent.getFeature(NodeAssociationFeature.class).getAssociatedNodeId())));
                    break;
                }
                case CATCH_INTERMEDIATE_EVENT: {
                    finalCopy = nodeContainer.createIntermediateCatchEvent(eventTriggerType);
                    break;
                }
                default: {
                    finalCopy = nodeContainer.createIntermediateThrowEvent(eventTriggerType);
                }
            }
            ((Event)finalCopy).applyFrom(toPasteFlowNode);
            if (toPasteFlowNode.getBpmnType() == BpmnType.BOUNDARY_EVENT) {
                ((BoundaryEvent)finalCopy).setBoundaryActivity(nodeContainer.findActivity(this.getNewId(toPasteFlowNode.getFeature(NodeAssociationFeature.class).getAssociatedNodeId())));
            }
        }
        return finalCopy;
    }
}

