/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import org.jetbrains.annotations.NotNull;

public class CopyFlowNodeCommand
extends ProjectCommand {
    private FlowNode originalTarget;
    private final FlowNode source;
    private final FlowNode target;

    public CopyFlowNodeCommand(@NotNull FlowNode source, @NotNull FlowNode target) {
        super(source.getProcess());
        this.originalTarget = target.copy();
        this.source = source;
        this.target = target;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGES_IN(this.source.getDefaultLabel()).getString();
    }

    public Object execute() {
        try {
            this.target.applyFrom(this.source);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return this.target;
    }

    @Override
    public void undo() {
        try {
            this.target.applyFrom(this.originalTarget);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }
}

