/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.EnumMap;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.processes.BpmnSequenceFlowType;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class ChangeSequenceFlowTypeCommand
extends ProjectCommand {
    private final BpmnSequenceFlowType original;
    private final BpmnSequenceFlowType type;
    private static final EnumMap<BpmnSequenceFlowType, ChangeSequenceFlowType> CHANGES = new EnumMap(BpmnSequenceFlowType.class);

    public ChangeSequenceFlowTypeCommand(@NotNull SequenceFlow sequenceFlow, @NotNull BpmnSequenceFlowType type) {
        super(sequenceFlow);
        this.type = type;
        this.original = sequenceFlow.getSequenceFlowType();
    }

    public static void change(@NotNull SequenceFlow sequenceFlow, @NotNull BpmnSequenceFlowType type) {
        ChangeSequenceFlowType change = CHANGES.get((Object)type);
        change.to(sequenceFlow);
    }

    @Override
    public String getName() {
        return this.type.toString();
    }

    public Object execute() {
        ChangeSequenceFlowTypeCommand.change(this.getAffectedObject(), this.type);
        return null;
    }

    @Override
    public void undo() {
        ChangeSequenceFlowTypeCommand.change(this.getAffectedObject(), this.original);
    }

    @Override
    public SequenceFlow getAffectedObject() {
        return (SequenceFlow)super.getAffectedObject();
    }

    static {
        CHANGES.put(BpmnSequenceFlowType.NORMAL, new ChangeSequenceFlowType(){

            @Override
            public void to(@NotNull SequenceFlow sequenceFlow) {
                sequenceFlow.toNormalFlow();
            }
        });
        CHANGES.put(BpmnSequenceFlowType.CONDITIONAL, new ChangeSequenceFlowType(){

            @Override
            public void to(@NotNull SequenceFlow sequenceFlow) {
                sequenceFlow.toConditionalFlow();
            }
        });
    }

    private static interface ChangeSequenceFlowType {
        public void to(@NotNull SequenceFlow var1);
    }
}

