/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class ChangeMeasurementTargetCommand
extends ProjectCommand {
    private Measurement affected;
    private Measurement measurement;
    private SequenceFlow previous;
    private SequenceFlow target;

    public ChangeMeasurementTargetCommand(@NotNull Measurement measurement, SequenceFlow target) {
        super(measurement);
        this.measurement = measurement;
        this.target = target;
    }

    public Object execute() throws ExecutionException {
        try {
            this.previous = this.measurement.getTransition();
            NodeContainer one = this.measurement.getParentObject();
            NodeContainer two = this.target.getParentObject();
            this.affected = this.measurement;
            if (!one.equals(two)) {
                Measurement copy = two.createMeasurement(one.getId());
                copy.applyFrom(this.measurement);
                this.affected = copy;
                this.affected.setLocation(this.target.getSource().getLocation().add(this.target.getTarget().getLocation()).div(2).translate(50, 50));
                one.removeChild(this.measurement);
                two.addChild(copy);
            }
            this.affected.setTransition(this.target);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            NodeContainer one = this.affected.getParentObject();
            NodeContainer two = this.previous.getParentObject();
            if (!one.equals(two)) {
                one.removeChild(this.affected);
                two.addChild(this.measurement);
            }
            this.measurement.setTransition(this.previous);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGE_TARGET_TRANSITION.getString();
    }
}

