/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.command.Command;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.organization.Role;
import org.jetbrains.annotations.NotNull;

public final class ChangeLocalizablePropertyCommand
extends ProjectCommand {
    private final Locale locale;
    private final LocaleStringMap map;
    private final String oldText;
    private final String text;

    public ChangeLocalizablePropertyCommand(@NotNull LocaleStringMap map, @NotNull String text, @NotNull Locale locale) {
        super(null);
        this.locale = locale;
        this.map = map;
        this.text = text;
        this.oldText = map.getString(locale);
    }

    public static Command changeRoleLabel(Role element, String value, Locale locale) {
        return new ChangeLocalizablePropertyCommand(element.getLabelMap(), value, locale);
    }

    public static Command changeLabel(Localizable element, String value, Locale locale) {
        return new ChangeLocalizablePropertyCommand(element.getLabelMap(), value, locale);
    }

    public static Command changeDescription(Localizable element, String value, Locale locale) {
        return new ChangeLocalizablePropertyCommand(element.getDescriptionMap(), value, locale);
    }

    @Override
    public String getName() {
        return null;
    }

    public Object execute() {
        this.map.put(this.locale, this.text);
        return this.getAffectedObject();
    }

    @Override
    public void undo() {
        this.map.put(this.locale, this.oldText);
    }
}

