/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import org.jetbrains.annotations.NotNull;

public class ChangeHumanTaskTypeCommand
extends ProjectCommand {
    private final HumanTaskType original;
    private final HumanTaskType type;

    public ChangeHumanTaskTypeCommand(@NotNull UserTask userTask, @NotNull HumanTaskType type) {
        super(userTask);
        this.type = type;
        this.original = userTask.getHumanTaskType();
    }

    @Override
    public String getName() {
        return this.type.getString();
    }

    public Object execute() {
        this.change(this.getAffectedObject(), this.type);
        return null;
    }

    @Override
    public void undo() {
        this.change(this.getAffectedObject(), this.original);
    }

    public void change(@NotNull UserTask activity, @NotNull HumanTaskType type) {
        activity.setHumanTaskType(type);
    }

    @Override
    public UserTask getAffectedObject() {
        return (UserTask)super.getAffectedObject();
    }
}

