/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.EnumMap;
import oracle.bpm.collections.Sequence;
import oracle.bpm.log.Log;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class ChangeActivityTypeCommand
extends ProjectCommand {
    private final BpmnType original;
    private final BpmnType type;
    private static final EnumMap<BpmnType, ChangeActivityType> CHANGES = new EnumMap(BpmnType.class);

    public ChangeActivityTypeCommand(@NotNull Activity activity, @NotNull BpmnType type) {
        super(activity);
        this.type = type;
        this.original = activity.getBpmnType();
    }

    public static Iterable<BpmnType> getAllPosibleChanges() {
        return CHANGES.keySet();
    }

    public static void change(@NotNull Activity activity, @NotNull BpmnType type) {
        ChangeActivityType change = CHANGES.get((Object)type);
        change.to(activity);
    }

    @Override
    public String getName() {
        return this.type.getString();
    }

    public Object execute() {
        ChangeActivityTypeCommand.change(this.getAffectedObject(), this.type);
        return null;
    }

    @Override
    public void undo() {
        ChangeActivityType change = CHANGES.get((Object)this.original);
        if (change != null) {
            change.to(this.getAffectedObject());
        } else {
            Log.logWarning((Throwable)((Object)new ProjectException(this.getAffectedObject(), Msg.QUOTE((String)("Cannot revert from type " + (Object)((Object)this.type) + " to original " + (Object)((Object)this.original))))));
        }
    }

    @Override
    public Activity getAffectedObject() {
        return (Activity)super.getAffectedObject();
    }

    private static void checkActivityGuide(Activity activity) {
        ActivityGuide guide = activity.getProject().getActivityGuide();
        if (guide != null) {
            Sequence<Milestone> milestones = guide.getChildrenByType(Milestone.class);
            for (Milestone milestone : milestones) {
                Sequence<MilestoneActivity> milestoneActivities = milestone.getChildrenByType(MilestoneActivity.class);
                ArrayList<MilestoneActivity> toRemove = new ArrayList<MilestoneActivity>();
                for (MilestoneActivity milestoneActivity : milestoneActivities) {
                    if (!milestoneActivity.getActivity().getId().equals(activity.getId())) continue;
                    toRemove.add(milestoneActivity);
                }
                for (MilestoneActivity milestoneActivity : toRemove) {
                    try {
                        milestone.removeMilestoneActivity(milestoneActivity);
                    }
                    catch (ProjectException e) {
                        Log.logSevere((Throwable)((Object)e));
                    }
                }
            }
        }
    }

    static {
        CHANGES.put(BpmnType.ABSTRACT_ACTIVITY, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toAbstract();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.USER_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toUserTask();
            }
        });
        CHANGES.put(BpmnType.SERVICE_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toServiceTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.CALL_ACTIVITY, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toCallActivity();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.BUSINESS_RULE_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toBusinessRuleTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.MANUAL_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toManualTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.RECEIVE_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toReceiveTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.SEND_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toSendTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.SCRIPT_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toScriptTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.NOTIFICATION_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toNotificationTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
        CHANGES.put(BpmnType.UPDATE_TASK, new ChangeActivityType(){

            @Override
            public void to(@NotNull Activity activity) {
                activity.toUpdateTask();
                ChangeActivityTypeCommand.checkActivityGuide(activity);
            }
        });
    }

    private static interface ChangeActivityType {
        public void to(@NotNull Activity var1);
    }
}

