/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class AddMeasurementCommand
extends ProjectCommand {
    private final Point destination;

    public AddMeasurementCommand(@NotNull Measurement measurement, @NotNull SequenceFlow transition, @NotNull Point destination) {
        super(measurement);
        this.destination = destination;
        measurement.setTransition(transition);
    }

    @Override
    public Measurement getAffectedObject() {
        return (Measurement)super.getAffectedObject();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.getAffectedObject().getDefaultLabel()).getString();
    }

    public Object execute() throws ExecutionException {
        try {
            Measurement measurement = this.getAffectedObject();
            measurement.setLocation(this.destination);
            NodeContainer nodeContainer = measurement.getParentObject();
            nodeContainer.addMeasurement(measurement);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            Measurement measurement = this.getAffectedObject();
            measurement.getParentObject().removeChild(measurement);
        }
        catch (ProjectException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }
}

