/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public class AddDataDeclarationCommand
extends ProjectCommand {
    private DataDeclaration dataDeclaration;

    public AddDataDeclarationCommand(@NotNull DataDeclarationContainer nodeContainer, @NotNull DataDeclaration dataObject) {
        super(nodeContainer);
        this.dataDeclaration = dataObject;
    }

    public Object execute() {
        try {
            this.getNodeContainer().addDeclaration(this.dataDeclaration);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return this.dataDeclaration;
    }

    @Override
    public void undo() {
        try {
            DataDeclarationContainer nodeContainer = this.getNodeContainer();
            if (nodeContainer.findLocalDeclaration(this.dataDeclaration.getId()) != null) {
                this.getNodeContainer().removeDeclaration(this.dataDeclaration);
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.dataDeclaration.getId()).getString();
    }

    private DataDeclarationContainer getNodeContainer() {
        return (DataDeclarationContainer)this.getAffectedObject();
    }
}

