/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import org.jetbrains.annotations.NotNull;

public class AddCorrelationKeyCommand
extends ProjectCommand {
    private CorrelationKey correlationKey;

    public AddCorrelationKeyCommand(@NotNull CorrelationKeyContainer correlationKeyContainer, @NotNull CorrelationKey correlationKey) {
        super(correlationKeyContainer);
        this.correlationKey = correlationKey;
    }

    public Object execute() {
        try {
            this.getCorrelationKeyContainer().addCorrelationKey(this.correlationKey);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return this.correlationKey;
    }

    @Override
    public void undo() {
        try {
            CorrelationKeyContainer nodeContainer = this.getCorrelationKeyContainer();
            if (nodeContainer.findChild(Conversation.class, this.correlationKey.getId()) != null) {
                this.getCorrelationKeyContainer().removeCorrelationKey(this.correlationKey);
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.correlationKey.getId()).getString();
    }

    private CorrelationKeyContainer getCorrelationKeyContainer() {
        return (CorrelationKeyContainer)this.getAffectedObject();
    }
}

