/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.view;

import fuego.papi.InstanceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.web.view.ViewResultColumn;

public class ViewResultRow {
    private ViewResultColumn[] cols;
    private Map<String, ViewResultColumn> colsMap;
    private List<ViewResultColumn> externalCols;
    private InstanceInfo info;
    private String stamp;

    public ViewResultRow() {
    }

    public ViewResultRow(ViewResultColumn[] cols) {
        this.colsMap = new HashMap<String, ViewResultColumn>();
        this.externalCols = new ArrayList<ViewResultColumn>();
        this.setColumns(cols);
    }

    public void setColumns(ViewResultColumn[] cols) {
        this.cols = cols;
        this.colsMap.clear();
        this.externalCols.clear();
        for (ViewResultColumn col : cols) {
            this.colsMap.put(col.getId(), col);
            if (!col.isExternal()) continue;
            this.externalCols.add(col);
        }
    }

    public ViewResultColumn[] getColumns() {
        return this.cols;
    }

    public int getColumnCount() {
        return this.cols.length;
    }

    public void setInstanceStamp(String stamp) {
        this.stamp = stamp;
    }

    public String getStamp() {
        return this.stamp;
    }

    public void setInstanceInfo(InstanceInfo info) {
        this.info = info;
    }

    public InstanceInfo getInfo() {
        return this.info;
    }

    public ViewResultColumn getColumn(String id) {
        return this.colsMap.get(id);
    }

    public ViewResultColumn[] getExternalColumns() {
        ViewResultColumn[] result = new ViewResultColumn[this.externalCols.size()];
        return this.externalCols.toArray(result);
    }
}

