/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.view;

import fuego.papi.BatchOperationException;
import fuego.papi.InstanceInfo;
import fuego.papi.InstanceStamp;
import fuego.papi.OperationException;
import fuego.papi.Ordering;
import fuego.papi.Presentation;
import fuego.papi.ProcessServiceSession;
import fuego.papi.VarDefinition;
import fuego.papi.View;
import fuego.papi.collections.InstanceInfoList;
import fuego.papi.exception.InvalidVariableIdException;
import java.util.Locale;
import oracle.bpm.lang.Void;
import oracle.bpm.web.view.ViewResult;
import oracle.bpm.web.view.ViewResultColumn;
import oracle.bpm.web.view.ViewResultRow;

public class ViewHelper {
    public static ViewResult execute(ProcessServiceSession session, String viewId) throws OperationException, BatchOperationException {
        return ViewHelper.execute(session, session.viewGet(viewId));
    }

    public static ViewResult execute(ProcessServiceSession session, View view) throws OperationException, BatchOperationException {
        ViewResult result = new ViewResult();
        Locale locale = session.participantLocale();
        Presentation presentation = session.presentationGet(view.getPresentation());
        Presentation.Column[] columns = presentation.getColumns();
        ViewResultColumn[] viewColumns = new ViewResultColumn[columns.length];
        Ordering ordering = presentation.getOrdering();
        for (int i = 0; i < viewColumns.length; ++i) {
            ViewResultColumn viewCol = new ViewResultColumn();
            Presentation.Column column = columns[i];
            VarDefinition varDefinition = column.getVarDefinition();
            viewCol.setId(varDefinition.getId());
            String label = column.getLabel(locale);
            viewCol.setValue(label);
            viewCol.setLabel(label);
            viewCol.setWidth(column.getSize());
            viewCol.setSorting(ordering.contains(column.getId()));
            viewCol.setExternal(varDefinition.isExternal());
            viewColumns[i] = viewCol;
        }
        result.setHeaders(viewColumns);
        InstanceInfoList instanceInfos = session.viewGetInstances(view.getId());
        int size = instanceInfos.size();
        ViewResultRow[] rows = new ViewResultRow[size];
        int colsCount = viewColumns.length;
        for (int i = 0; i < size; ++i) {
            InstanceInfo info = (InstanceInfo)instanceInfos.get(i);
            ViewResultColumn[] cols = new ViewResultColumn[colsCount];
            for (int x = 0; x < columns.length; ++x) {
                ViewResultColumn column = new ViewResultColumn();
                Object value = Void.getInstance();
                try {
                    value = info.getExternalVariable(columns[x].getId());
                }
                catch (InvalidVariableIdException exception) {
                    // empty catch block
                }
                column.setHeader(viewColumns[x].getAsString());
                column.setId(viewColumns[x].getId());
                column.setValue(columns[x].getFormattedValue(value, locale));
                column.setSorting(viewColumns[x].isSorting());
                column.setWidth(viewColumns[x].getWidth());
                column.setExternal(viewColumns[x].isExternal());
                column.setLabel(viewColumns[x].getLabel());
                cols[x] = column;
            }
            ViewResultRow row = new ViewResultRow(cols);
            row.setInstanceStamp(InstanceStamp.create((String)info.getId(), (String)info.getActivityName()).getId());
            row.setInstanceInfo(info);
            rows[i] = row;
        }
        result.setRows(rows);
        return result;
    }
}

