/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.view;

import fuego.papi.utils.AuditTrail;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AuditTrailPath {
    private final List<String> auditActivities = new ArrayList<String>();
    private boolean hasInstance = false;

    private AuditTrailPath() {
    }

    public static AuditTrailPath buildPath(List<AuditTrail.AuditNode> nodes, String activityName) {
        AuditTrailPath path = new AuditTrailPath();
        ArrayList<AuditTrailPath> threadNodesPaths = new ArrayList<AuditTrailPath>();
        boolean isLastPath = false;
        for (AuditTrail.AuditNode node : nodes) {
            if (path.hasInstance && !isLastPath) break;
            switch (node.getType()) {
                case 2: {
                    path.auditActivities.add(node.getActivityName());
                    isLastPath = path.hasInstance = node.getActivityName().equals(activityName);
                    if ((node.getActivityType() & 0x81) == 129) {
                        AuditTrailPath.buildChildPath(AuditTrailPath.reorderNodes(node.getChildren()), activityName, path);
                    }
                    if ((node.getActivityType() & 0x10001) != 65537) break;
                    AuditTrailPath.buildChildPath(node.getChildren(), activityName, path);
                    break;
                }
                case 1: {
                    AuditTrailPath threadPath = AuditTrailPath.buildPath(node.getChildren(), activityName);
                    path.hasInstance = threadPath.hasInstance;
                    if (threadPath.hasInstance) {
                        threadNodesPaths.clear();
                    }
                    threadNodesPaths.add(threadPath);
                }
            }
        }
        for (AuditTrailPath threadNodesPath : threadNodesPaths) {
            path.auditActivities.addAll(threadNodesPath.auditActivities);
        }
        return path;
    }

    public List<String> getAuditActivities() {
        return this.auditActivities;
    }

    private static void buildChildPath(List<AuditTrail.AuditNode> nodes, String activityName, AuditTrailPath path) {
        AuditTrailPath groupPath = AuditTrailPath.buildPath(nodes, activityName);
        path.auditActivities.addAll(groupPath.auditActivities);
        path.hasInstance = groupPath.hasInstance;
    }

    private static List<AuditTrail.AuditNode> reorderNodes(List<AuditTrail.AuditNode> nodes) {
        AuditTrail.AuditNode[] orderedNodes = new AuditTrail.AuditNode[nodes.size()];
        int orderedIndex = 0;
        int notOrderedIndex = nodes.size() - 1;
        for (AuditTrail.AuditNode node : nodes) {
            List childrens = node.getChildren();
            int splitCount = 0;
            int joinCount = 0;
            boolean finishInJoin = false;
            if (childrens != null) {
                for (AuditTrail.AuditNode children : childrens) {
                    if (AuditTrailPath.isJoinActivity(children)) {
                        ++joinCount;
                        continue;
                    }
                    if (!AuditTrailPath.isSplitActivity(children)) continue;
                    ++splitCount;
                }
                finishInJoin = childrens.size() > 0 && AuditTrailPath.isJoinActivity((AuditTrail.AuditNode)childrens.get(childrens.size() - 1));
            }
            orderedNodes[finishInJoin && splitCount - joinCount == 0 ? notOrderedIndex-- : orderedIndex++] = node;
        }
        return Arrays.asList(orderedNodes);
    }

    private static boolean isSplitActivity(AuditTrail.AuditNode children) {
        return children.getActivityType() == 129 || children.getActivityType() == 385;
    }

    private static boolean isJoinActivity(AuditTrail.AuditNode node) {
        return node.getActivityType() == 513;
    }
}

