/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.papi;

import fuego.papi.ApplicationsView;
import fuego.papi.BatchOperationException;
import fuego.papi.InstancesView;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.View;
import fuego.papi.ViewType;
import fuego.papi.exception.ViewNotFoundException;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.log.Log;
import oracle.bpm.web.authentication.UserOptions;
import oracle.bpm.web.authentication.WebPrincipal;

public class ViewUtils {
    public static InstancesView getInboxInstancesView(WebPrincipal principal, ProcessServiceSession processSession) throws OperationException, BatchOperationException {
        InstancesView ret = null;
        UserOptions userOptions = principal.getUserOptions();
        String defaultViewId = userOptions.getDefaultInboxViewId();
        if (defaultViewId != null) {
            try {
                ret = (InstancesView)processSession.viewGet(defaultViewId);
            }
            catch (ViewNotFoundException exeception) {
                // empty catch block
            }
        }
        StringList viewIds = processSession.viewsGetIds();
        if (ret == null) {
            for (String viewId : viewIds) {
                if (!viewId.equals("unified_inbox")) continue;
                ret = (InstancesView)processSession.viewGet("unified_inbox");
                break;
            }
        }
        if (ret == null && viewIds.size() > 0) {
            for (String viewId : viewIds) {
                View view = processSession.viewGet(viewId);
                if (!ViewType.INSTANCES.equals((Object)view.getType())) continue;
                ret = (InstancesView)view;
                break;
            }
        }
        if (ret == null) {
            Log.logDebug((String)"Could not load a default inbox view.");
        }
        if (ret != null && !ret.getId().equals(defaultViewId)) {
            userOptions.setDefaultInboxViewId(defaultViewId);
        }
        return ret;
    }

    public static ApplicationsView getApplicationsView(WebPrincipal principal, ProcessServiceSession processSession) throws OperationException, BatchOperationException {
        ApplicationsView ret = null;
        UserOptions userOptions = principal.getUserOptions();
        String defaultApplicationViewId = userOptions.getDefaultApplicationsViewId();
        if (defaultApplicationViewId != null) {
            try {
                ret = (ApplicationsView)processSession.viewGet(defaultApplicationViewId);
            }
            catch (ViewNotFoundException exeception) {
                // empty catch block
            }
        }
        StringList viewIds = processSession.viewsGetIds();
        if (ret == null) {
            for (String viewId : viewIds) {
                if (!viewId.equals("applications")) continue;
                ret = (ApplicationsView)processSession.viewGet("applications");
                break;
            }
        }
        if (ret == null && viewIds.size() > 0) {
            for (String viewId : viewIds) {
                View view = processSession.viewGet(viewId);
                if (!ViewType.APPLICATIONS.equals((Object)view.getType())) continue;
                ret = (ApplicationsView)view;
                break;
            }
        }
        if (ret == null) {
            Log.logDebug((String)"Could not load a default applications view.");
        }
        if (ret != null && !ret.getId().equals(defaultApplicationViewId)) {
            userOptions.setDefaultApplicationsViewId(defaultApplicationViewId);
        }
        return ret;
    }
}

