/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.papi;

import fuego.papi.Activity;
import fuego.papi.Arguments;
import fuego.papi.Execution;
import fuego.papi.GlobalExecution;
import fuego.papi.InstanceInfo;
import fuego.papi.InstanceStamp;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.TaskExecution;
import fuego.papi.exception.ActivityTimeoutException;
import fuego.papi.exception.ActivityUserTimeoutException;
import fuego.papi.exception.CannotLockInstanceException;
import fuego.papi.exception.InstanceAlreadySelectedException;
import fuego.papi.exception.InstanceAlreadySuspendedException;
import fuego.papi.exception.InstanceConcurrentExecutionException;
import fuego.papi.exception.InstanceNotAvailableException;
import fuego.papi.exception.InstanceNotInActivityException;
import fuego.papi.exception.InstanceNotRunningException;
import fuego.papi.exception.InstanceNotSuspendedException;
import fuego.papi.exception.InstanceSentException;
import fuego.papi.exception.InstanceSuspendedException;
import fuego.papi.exception.NotUniqueTransitionException;
import fuego.papi.exception.TaskAlreadySelectedException;
import fuego.papi.exception.TaskCompletedException;
import fuego.papi.exception.TaskFailedException;
import fuego.papi.exception.TaskNotUnselectedException;
import fuego.papi.exception.TaskSelectedByOtherException;
import fuego.papi.exception.TaskTimeoutException;
import fuego.papi.exception.TaskUserTimeoutException;
import java.util.Locale;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.web.authentication.WebPrincipal;
import oracle.bpm.web.exception.InvalidItemExecutionException;
import oracle.bpm.web.exception.ItemAlreadyExecutedException;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.InteractiveExecution;
import oracle.bpm.web.execution.InteractiveExecutionManager;
import oracle.bpm.web.execution.exception.TimeStampExpiredException;
import oracle.bpm.web.execution.exception.UnexpectedExecutionException;
import oracle.bpm.web.execution.impl.WebExecutionIdentifier;
import oracle.bpm.web.execution.impl.WebExecutionManager;
import oracle.bpm.web.execution.impl.WebInteractiveExecution;
import oracle.bpm.web.execution.impl.WebRedirector;
import oracle.bpm.web.papi.ActionType;
import oracle.bpm.web.papi.ErrorHandler;
import oracle.bpm.web.papi.ExecutionContext;
import oracle.bpm.web.papi.ExecutionUUIDBuilder;

public class TaskExecutor {
    private ErrorHandler errorHandler;
    private InteractiveExecutionManager interactiveExecutionManager;
    private WebRedirector redirector;

    public TaskExecutor(ErrorHandler errorHandler, InteractiveExecutionManager iem, WebRedirector redirector) {
        this.errorHandler = errorHandler;
        this.interactiveExecutionManager = iem;
        this.redirector = redirector;
    }

    public void execute(ActionType action, ExecutionContext execContext) throws ComponentExecutionException, UnexpectedExecutionException {
        if (Log.isDebugging()) {
            Log.logDebug((String)("ExecutionDispatcher.actionId: " + (Object)((Object)action)));
        }
        try {
            if (action.equals((Object)ActionType.RUN_APPLICATION_TASK)) {
                this.runApplicationTask(execContext);
            } else if (action.equals((Object)ActionType.RUN_INSTANCE_TASK)) {
                this.runInstanceTask(execContext);
            } else if (action.equals((Object)ActionType.RESULT)) {
                this.processResult(execContext);
            } else if (action.equals((Object)ActionType.REDIRECT)) {
                this.processRedirect(execContext);
            } else assert (false) : "Unsupported action";
        }
        catch (NotUniqueTransitionException notUniqueException) {
            this.errorHandler.handleException(execContext, notUniqueException);
        }
        catch (InstanceSentException clie) {
            this.errorHandler.ignoreException(execContext, clie);
        }
        catch (TaskUserTimeoutException timeOutException) {
            this.errorHandler.handleException(execContext, timeOutException);
        }
        catch (TaskTimeoutException taskTimeOutException) {
            this.errorHandler.handleException(execContext, taskTimeOutException);
        }
        catch (CannotLockInstanceException cannotLockInstance) {
            this.errorHandler.handleException(execContext, cannotLockInstance);
        }
        catch (TaskFailedException taskFailedException) {
            this.errorHandler.handleException(execContext, taskFailedException);
        }
        catch (ItemAlreadyExecutedException itemAlreadyExecuted) {
            this.errorHandler.handleException(execContext, itemAlreadyExecuted);
        }
        catch (TimeStampExpiredException timeStampExpired) {
            this.errorHandler.handleException(execContext, timeStampExpired);
        }
        catch (InstanceAlreadySelectedException instanceAlreadySelected) {
            this.errorHandler.handleException(execContext, instanceAlreadySelected);
        }
        catch (InstanceAlreadySuspendedException instanceAlreadySuspended) {
            this.errorHandler.handleException(execContext, instanceAlreadySuspended);
        }
        catch (InstanceConcurrentExecutionException instanceConcurrent) {
            this.errorHandler.handleException(execContext, instanceConcurrent);
        }
        catch (InstanceNotAvailableException instanceNotAvailable) {
            this.errorHandler.handleException(execContext, instanceNotAvailable);
        }
        catch (InstanceNotInActivityException instanceNotInActivity) {
            this.errorHandler.handleException(execContext, instanceNotInActivity);
        }
        catch (InstanceNotRunningException instanceNotRunning) {
            this.errorHandler.handleException(execContext, instanceNotRunning);
        }
        catch (InstanceNotSuspendedException instanceNotSuspended) {
            this.errorHandler.handleException(execContext, instanceNotSuspended);
        }
        catch (InstanceSuspendedException instanceSuspended) {
            this.errorHandler.handleException(execContext, instanceSuspended);
        }
        catch (TaskSelectedByOtherException taskSelectedByOther) {
            this.errorHandler.handleException(execContext, taskSelectedByOther);
        }
        catch (TaskAlreadySelectedException taskAlreadySelected) {
            this.errorHandler.handleException(execContext, taskAlreadySelected);
        }
        catch (TaskCompletedException taskCompleted) {
            this.errorHandler.handleException(execContext, taskCompleted);
        }
        catch (TaskNotUnselectedException taskNotUnselected) {
            this.errorHandler.handleException(execContext, taskNotUnselected);
        }
        catch (ActivityTimeoutException activityTimeout) {
            this.errorHandler.handleException(execContext, activityTimeout);
        }
        catch (ActivityUserTimeoutException activityUserTimeout) {
            this.errorHandler.handleException(execContext, activityUserTimeout);
        }
        catch (OperationException operationException) {
            this.errorHandler.handleException(execContext, operationException);
        }
        catch (InvalidItemExecutionException invalidItemExecution) {
            this.errorHandler.handleException(execContext, invalidItemExecution);
        }
        catch (ComponentExecutionException exception) {
            throw exception;
        }
        catch (Throwable e) {
            throw new UnexpectedExecutionException(e);
        }
    }

    private void processRedirect(ExecutionContext execContext) throws Throwable {
        ExternalContext context = execContext.getExternalContext();
        WebExecutionManager manager = (WebExecutionManager)this.getInteractiveExecutionManager();
        if (!manager.isExecutionAborted(context)) {
            WebInteractiveExecution currentExecution;
            ExecutionIdentifier execId = manager.retrieveExecutionIdentifier(context);
            assert (execId != null) : "executionIdentifier can not be null";
            if (Log.isDebugging()) {
                Log.logDebug((String)("Executor.execId: " + execId));
            }
            if ((currentExecution = (WebInteractiveExecution)this.getInteractiveExecutionManager().find(execId, execContext.getExternalContext())) == null) {
                throw new ItemAlreadyExecutedException();
            }
            try {
                String redirect = execContext.getForwardComponent();
                if (Log.isDebugging()) {
                    Log.logDebug((String)("Executor.getForwardComponent: " + redirect));
                }
                if (redirect != null) {
                    this.redirector.redirect(redirect, context);
                    return;
                }
                assert (false) : "Fail during redirect action, could not find a redirect action";
            }
            catch (Throwable t) {
                if (Log.isDebugging()) {
                    Log.logDebug((String)"ExectuionDispatcher.processRedirect-> processing exception");
                }
                if (Log.isDebugging()) {
                    Log.logDebug((Throwable)t);
                }
                currentExecution.process(t);
            }
        } else {
            this.redirector.redirect(manager.getExecutionAbortedUrl(context), context);
        }
    }

    private void processResult(ExecutionContext execContext) throws Throwable {
        InteractiveExecution currentExecution;
        WebExecutionManager manager = (WebExecutionManager)this.getInteractiveExecutionManager();
        ExternalContext context = execContext.getExternalContext();
        ExecutionIdentifier execId = manager.retrieveExecutionIdentifier(context);
        if (Log.isDebugging()) {
            Log.logDebug((String)("ExecutionDispatcher.processResult(): " + execId));
        }
        if ((currentExecution = this.getInteractiveExecutionManager().find(execId, execContext.getExternalContext())) == null) {
            throw new ItemAlreadyExecutedException();
        }
        currentExecution.process();
    }

    private InteractiveExecutionManager getInteractiveExecutionManager() {
        return this.interactiveExecutionManager;
    }

    private void runApplicationTask(ExecutionContext executionContext) throws Throwable {
        WebInteractiveExecution currentExecution;
        ExternalContext externalContext = executionContext.getExternalContext();
        WebExecutionManager manager = (WebExecutionManager)this.getInteractiveExecutionManager();
        String executionUUID = ExecutionUUIDBuilder.buildForApplicationTask(executionContext);
        if (executionUUID != null && (currentExecution = (WebInteractiveExecution)manager.find(executionUUID, externalContext)) != null) {
            currentExecution.retry();
            return;
        }
        ExecutionIdentifier execId = manager.retrieveExecutionIdentifier(externalContext);
        if (execId != null && (currentExecution = (WebInteractiveExecution)manager.find(execId, externalContext)) != null) {
            currentExecution.retry();
            return;
        }
        assert (executionContext.getActivityId() != null) : "Activity id must not be null";
        Activity activity = this.loadActivity(executionContext, executionContext.getActivityId());
        if (activity == null) {
            throw new IllegalArgumentException("Could not find an activityId='" + executionContext.getActivityId() + "'.");
        }
        Arguments arguments = executionContext.getCILArgumentsFromRequest(externalContext);
        ProcessServiceSession pss = this.getProcessServiceSession(executionContext);
        GlobalExecution execution = pss.activityPostApplication(activity, arguments);
        if (!pss.isOpened()) {
            if (Log.isDebugging()) {
                Log.logDebug((String)"ExecutionDispatcher.runInstanceTask: Process Service session closed. Ignore execution request");
            }
            return;
        }
        WebExecutionIdentifier id = WebExecutionIdentifier.create((String)executionUUID, (Activity)activity, (String)activity.getLabel(Locale.ENGLISH));
        if (Log.isDebugging()) {
            Log.logDebug((String)("ExecutionDispatcher.runApplicationTask: Global Excecution ->" + execution));
        }
        currentExecution = (WebInteractiveExecution)manager.createExecution((ExecutionIdentifier)id, (Execution)execution, externalContext);
        if (Log.isDebugging()) {
            Log.logDebug((String)("ExecutionDispatcher.customRunTask(): " + id));
        }
        currentExecution.process();
    }

    private void runInstanceTask(ExecutionContext executionContext) throws Throwable {
        TaskExecution taskExecution;
        String taskLabel;
        String execIdent;
        ExecutionIdentifier execId;
        boolean isGlobalActivity;
        String executionUUID;
        ExternalContext externalContext = executionContext.getExternalContext();
        WebInteractiveExecution currentExecution = null;
        WebExecutionManager manager = (WebExecutionManager)this.getInteractiveExecutionManager();
        Activity activity = null;
        if (executionContext.getActivityId() != null && !"".equals(executionContext.getActivityId().trim())) {
            activity = this.loadActivity(executionContext, executionContext.getActivityId());
        }
        if ((executionUUID = ExecutionUUIDBuilder.buildForInstanceTask(isGlobalActivity = activity != null && activity.hasInstanceAccess(), executionContext)) != null && (currentExecution = (WebInteractiveExecution)manager.find(executionUUID, externalContext)) != null) {
            currentExecution.retry();
            return;
        }
        String userConfirmedAction = executionContext.getUserConfirmedAction();
        if (userConfirmedAction != null && userConfirmedAction.equals("forceExecution")) {
            WebInteractiveExecution oldExecution;
            if (Log.isDebugging()) {
                Log.logDebug((String)"ExecutionDispatcher.runInstanceTask() aborting previous execution...");
            }
            if ((oldExecution = (WebInteractiveExecution)manager.find(execId = WebExecutionIdentifier.loadFrom((String)(execIdent = executionContext.getOldExecutionIdentifier())), externalContext)) != null) {
                if (Log.isDebugging()) {
                    Log.logDebug((String)("runInstanceTask: aborting execution -> " + oldExecution));
                }
                oldExecution.abort();
            }
        } else if (userConfirmedAction != null && userConfirmedAction.equals("resume")) {
            if (Log.isDebugging()) {
                Log.logDebug((String)"ExecutionDispatcher.runInstanceTask(): resuming previous execution...");
            }
            execIdent = executionContext.getOldExecutionIdentifier();
            execId = WebExecutionIdentifier.loadFrom((String)execIdent);
            if (Log.isDebugging()) {
                Log.logDebug((String)("ExecutionDispatcher.runInstanceTask(): resuming -> " + execIdent));
            }
            if ((currentExecution = (WebInteractiveExecution)manager.find(execId, externalContext)) == null) {
                throw new InvalidItemExecutionException(InvalidItemExecutionException.ITEM_CANT_BE_RESUMED);
            }
        } else {
            ExecutionIdentifier execId2 = manager.retrieveExecutionIdentifier(externalContext);
            if (execId2 != null) {
                currentExecution = (WebInteractiveExecution)manager.find(execId2, externalContext);
            }
        }
        if (currentExecution != null) {
            if (Log.isDebugging()) {
                Log.logDebug((String)"ExecutionDispatcher.runInstanceTask(): currentExecution  retry ...");
            }
            currentExecution.retry();
            return;
        }
        InstanceInfo instanceInfo = this.getInstanceInfoFromStamp(executionContext, executionContext.getInstanceStampId());
        if (instanceInfo == null) {
            throw new IllegalArgumentException("Could not get the parameter instanceStampId.");
        }
        if (Log.isDebugging()) {
            Log.logDebug((String)("ExecutionDispatcher.runInstanceTask(): " + instanceInfo.getId() + " itemid: " + executionContext.getItemId()));
        }
        ProcessServiceSession pss = this.getProcessServiceSession(executionContext);
        Locale userLocale = executionContext.getExternalContext().getProperties().getLocale();
        if (isGlobalActivity) {
            taskLabel = activity.getTask(0).getLabel(userLocale);
            taskExecution = pss.activityPost(activity, instanceInfo, null);
        } else {
            activity = instanceInfo.getActivity();
            taskLabel = activity.getLabel(userLocale);
            taskExecution = pss.activityPost(instanceInfo.getActivity(), instanceInfo, executionContext.getItemId(), null);
        }
        WebExecutionIdentifier execId3 = WebExecutionIdentifier.create((String)executionUUID, (Activity)activity, (String)taskLabel);
        currentExecution = (WebInteractiveExecution)manager.createExecution((ExecutionIdentifier)execId3, (Execution)taskExecution, externalContext);
        if (!pss.isOpened()) {
            if (Log.isDebugging()) {
                Log.logDebug((String)"ExecutionDispatcher.runInstanceTask(): Process Service session closed. Ignore execution request");
            }
            return;
        }
        currentExecution.process();
        if (Log.isDebugging()) {
            Log.logDebug((String)"ExecutionDispatcher.runInstanceTask: exit");
        }
    }

    private InstanceInfo getInstanceInfoFromStamp(ExecutionContext context, String instanceStampId) throws OperationException {
        ProcessServiceSession pss = this.getProcessServiceSession(context);
        InstanceStamp is = InstanceInfo.getStamp((String)instanceStampId);
        return pss.processGetInstance(is.getInstanceId(), is.getActivityName());
    }

    private ProcessServiceSession getProcessServiceSession(ExecutionContext context) {
        WebPrincipal principal = context.getWebPrincipal();
        return principal.getProcessServiceSession();
    }

    private Activity loadActivity(ExecutionContext context, String activityId) throws OperationException {
        ProcessServiceSession processServiceSession = this.getProcessServiceSession(context);
        return processServiceSession.processGet(Activity.getProcessId((String)activityId)).getActivity(activityId);
    }
}

