/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.papi;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Properties;
import oracle.bpm.web.WebEnvironment;
import oracle.bpm.web.msg.WebMsg;

public abstract class PapiEnvironment
extends WebEnvironment {
    private ServletContext context;
    public static final String PROPERTY_PREFIX = "fuego.";
    public static final String DIRECTORY_ID_PROPERTY_SUFFIX = ".DIRECTORY_ID";
    public static final String DEFAULT_DIRECTORY_FILE = "/WEB-INF/directory.xml";
    public static final String DEFAULT_DIRECTORY_RESOURCE = "/conf/directory.xml";
    public static final String FEDERATION_CONFIG_RESOURCE = "/conf/federation.properties";

    public PapiEnvironment(ServletContext context) {
        super(context);
        this.context = context;
    }

    public void initConnectionProperties(java.util.Properties papiProperties) {
        boolean configFederation;
        InputStream is = this.context.getResourceAsStream(FEDERATION_CONFIG_RESOURCE);
        boolean bl = configFederation = is != null;
        if (configFederation) {
            try {
                Log.logInfo((Msg)WebMsg.INITIALIZING_FEDERATED_PROCESS_SERVICE);
                Properties federationProperties = new Properties();
                federationProperties.load(is);
                papiProperties.putAll((Map<?, ?>)federationProperties);
            }
            catch (IOException e) {
                configFederation = false;
                Log.logWarning((Msg)WebMsg.FEDERATION_INITIALIZATION_FAILED, (Throwable)e);
            }
        }
        if (!configFederation) {
            String directoryId = this.getProperty(this.directoryIdPropertyName(), "default");
            papiProperties.put("fuego.directory.id", directoryId);
            try {
                URL directoryResourceURL = this.context.getResource(DEFAULT_DIRECTORY_RESOURCE);
                if (directoryResourceURL != null) {
                    papiProperties.put("fuego.directory.url", directoryResourceURL.toString());
                }
                if ((directoryResourceURL = this.context.getResource(DEFAULT_DIRECTORY_FILE)) != null) {
                    papiProperties.put("fuego.directory.url", directoryResourceURL.toString());
                }
            }
            catch (MalformedURLException e) {
                Log.logDebug((Throwable)e);
            }
            Log.logInfo((Msg)WebMsg.INITIALIZING_PROCESS_SERVICE_WITH_DEFAULT_DIRECTORY_ID);
        }
    }

    protected String directoryIdPropertyName() {
        return PROPERTY_PREFIX + this.getApplicationId() + DIRECTORY_ID_PROPERTY_SUFFIX;
    }
}

