/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.jsp;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class JSTLConstantsAdapter<T>
extends HashMap<String, T> {
    private boolean initialised = false;
    static final long serialVersionUID = -7765316896981575901L;

    public JSTLConstantsAdapter(Class c) {
        for (Field field : c.getDeclaredFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isFinal(modifier) || Modifier.isPrivate(modifier)) continue;
            try {
                this.put(field.getName(), field.get(this));
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        this.initialised = true;
    }

    @Override
    public void clear() {
        if (this.initialised) {
            throw new UnsupportedOperationException("Cannot modify this map");
        }
        super.clear();
    }

    @Override
    public T put(String key, T value) {
        if (!this.initialised) {
            return super.put(key, value);
        }
        throw new UnsupportedOperationException("Cannot modify this map");
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        if (this.initialised) {
            throw new UnsupportedOperationException("Cannot modify this map");
        }
        super.putAll(m);
    }

    @Override
    public T remove(Object key) {
        if (!this.initialised) {
            return (T)super.remove(key);
        }
        throw new UnsupportedOperationException("Cannot modify this map");
    }
}

