/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import oracle.bpm.web.filter.compression.HexString;
import oracle.bpm.web.filter.compression.RequestTable;

public class SnifferOutputStream
extends ServletOutputStream {
    protected boolean compressing = false;
    protected int count = 0;
    protected int debug = 0;
    protected ServletOutputStream output = null;
    protected String uri_d = null;

    public SnifferOutputStream(ServletOutputStream output, int debug, String uri, boolean compressing) throws IOException {
        this.output = output;
        this.count = 0;
        this.compressing = compressing;
        this.uri_d = uri;
        this.debug = debug;
    }

    public void close() throws IOException {
        if (this.uri_d != null) {
            RequestTable.setCompressedSizeForURI(this.uri_d, this.count, this.compressing);
        }
        this.flush();
        this.output.close();
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": Sniffer: wrote : (" + this.count + ") bytes");
        }
        this.count = 0;
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void reset() {
        this.count = 0;
    }

    public void write(int b) throws IOException {
        this.output.write(b);
        ++this.count;
        if (this.debug > 5) {
            long tnow = new Date().getTime();
            String st = new Timestamp(tnow).toString();
            System.err.println(Thread.currentThread() + st + " Sniffer: writing byte: (" + b + ")");
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
        this.count += len;
        if (this.debug > 5) {
            long tnow = new Date().getTime();
            String st = new Timestamp(tnow).toString();
            System.err.println(Thread.currentThread() + st + " Sniffer: writing " + len + " bytes \n" + HexString.dump(b, len));
        }
    }
}

