/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.util.Enumeration;
import java.util.Hashtable;

public class RequestTable {
    private static Hashtable<String, Entry> table_d = null;
    private static int compressionThreshold_d = 0;

    public static synchronized void setCompressedSizeForURI(String uri, int size, boolean compressing) {
        Entry e = RequestTable.getTable().get(uri);
        if (e != null) {
            e.setCompressedSize(size);
            e.setCompressing(compressing);
        }
    }

    public static void setCompressionThreshold(int t) {
        compressionThreshold_d = t;
    }

    public static synchronized void setInvocationTimesForURI(String uri) {
        Entry e = RequestTable.getTable().get(uri);
        if (e != null) {
            e.incrementInvocationTimes();
        }
    }

    public static synchronized void setOriginalSizeForURI(String uri, int size) {
        Entry e = RequestTable.getTable().get(uri);
        if (e != null) {
            e.setOriginalSize(size);
        } else {
            e = new Entry(uri);
            e.setOriginalSize(size);
            RequestTable.getTable().put(uri, e);
        }
    }

    public static String dumpHTMLTable() {
        Entry entry;
        long totalOriginalSize = 0L;
        long totalCompressedSize = 0L;
        String table = "";
        table = table + "<B>Aggregated Statistics at the bottom of the table</B><BR>";
        table = table + "<B>Compression Filter is trying to compress requests greater than '" + compressionThreshold_d + "' bytes</B><BR><BR>";
        table = table + "<TABLE BORDER=1>";
        table = table + "<TR BGCOLOR=\"CYAN\">";
        table = table + "<TH>URI<TH>Original Size (bytes)" + "<TH>Compressed Size (bytes)" + "<TH>Compressed ?" + "<TH>Could Compress ?" + "<TH>Compression Ratio %" + "<TH>Invocation Times" + "<TH>Min Time (MilliSecs)" + "<TH>Average Time (MilliSecs)" + "<TH>Max Time (MilliSecs)";
        Enumeration<Entry> e = RequestTable.getTable().elements();
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            if (entry.getCompressedSize() >= entry.getOriginalSize() || entry.getCompressedSize() == 0) continue;
            table = table + "<TR>";
            table = table + "<TD>" + entry.getURI() + "<TD>" + entry.getOriginalSize() + "<TD>" + entry.getCompressedSize() + "<TD>" + entry.getCompressing() + "<TD>" + (entry.getCompressedSize() < entry.getOriginalSize() && entry.getCompressedSize() != 0) + "<TD>" + (entry.getCompressedSize() < entry.getOriginalSize() && entry.getCompressedSize() != 0 ? String.valueOf(entry.compressionRatio()) : "-") + "<TD>" + entry.getInvocationTimes() + "<TD>" + entry.getMinimumInvocationTime() + "<TD>" + entry.getAverageInvocationTime() + "<TD>" + entry.getMaximumInvocationTime();
            totalOriginalSize += (long)entry.getOriginalSize();
            totalCompressedSize += (long)entry.getCompressedSize();
        }
        e = RequestTable.getTable().elements();
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            if (entry.getCompressedSize() < entry.getOriginalSize() && entry.getCompressedSize() != 0) continue;
            table = table + "<TR>";
            table = table + "<TD>" + entry.getURI() + "<TD>" + entry.getOriginalSize() + "<TD>" + entry.getCompressedSize() + "<TD>" + entry.getCompressing() + "<TD>" + (entry.getCompressedSize() < entry.getOriginalSize() && entry.getCompressedSize() != 0) + "<TD>" + (entry.getCompressedSize() != 0 ? String.valueOf(entry.compressionRatio()) : "-") + "<TD>" + entry.getInvocationTimes() + "<TD>" + entry.getMinimumInvocationTime() + "<TD>" + entry.getAverageInvocationTime() + "<TD>" + entry.getMaximumInvocationTime();
            totalOriginalSize += (long)entry.getOriginalSize();
            totalCompressedSize += (long)entry.getCompressedSize();
        }
        table = table + "</TABLE><BR>";
        table = table + "<B>Aggregated Statistics</B><BR><BR>";
        table = table + "<B>Total Bytes To Be Transfered without Compression: (" + totalOriginalSize + ")</B><BR>";
        table = table + "<B>Total Bytes Sent after applying Compression: (" + totalCompressedSize + ")</B><BR>";
        table = table + "<B>Overall Compression Ratio: " + (totalCompressedSize != 0L ? String.valueOf(totalOriginalSize * 100L / totalCompressedSize) : "-") + " %</B><BR>";
        return table;
    }

    public static String dumpTable() {
        String table = "";
        Enumeration<Entry> e = RequestTable.getTable().elements();
        boolean processedElement = false;
        while (e.hasMoreElements()) {
            Entry entry = e.nextElement();
            if (processedElement) {
                table = table + "\n";
            } else {
                processedElement = true;
            }
            table = table + entry.toString();
        }
        return table;
    }

    public static synchronized void reset() {
        table_d = null;
        table_d = new Hashtable();
    }

    public static synchronized void updateTimesWithCurrentInvocationURI(String uri, long time) {
        Entry e = RequestTable.getTable().get(uri);
        if (e != null) {
            e.updateTimesWithCurrentInvocation(time);
        }
    }

    private static Hashtable<String, Entry> getTable() {
        if (table_d == null) {
            table_d = new Hashtable();
        }
        return table_d;
    }

    public static class Entry {
        private long averageTime_d;
        private int compressedSize_d;
        private boolean compressing_d;
        private int invocationTimes_d;
        private long maxTime_d;
        private long minTime_d;
        private int originalSize_d;
        private long totalTimeInvocations_d;
        private String uri_d;

        public Entry(String uri) {
            this.uri_d = uri;
            this.originalSize_d = 0;
            this.compressedSize_d = 0;
            this.invocationTimes_d = 0;
            this.totalTimeInvocations_d = 0L;
            this.minTime_d = 0L;
            this.averageTime_d = 0L;
            this.maxTime_d = 0L;
            this.compressing_d = true;
        }

        public long getAverageInvocationTime() {
            return this.averageTime_d;
        }

        public void setCompressedSize(int size) {
            this.compressedSize_d = size;
        }

        public int getCompressedSize() {
            return this.compressedSize_d;
        }

        public void setCompressing(boolean compressing) {
            this.compressing_d = compressing;
        }

        public boolean getCompressing() {
            return this.compressing_d;
        }

        public int getInvocationTimes() {
            return this.invocationTimes_d;
        }

        public long getMaximumInvocationTime() {
            return this.maxTime_d;
        }

        public long getMinimumInvocationTime() {
            return this.minTime_d;
        }

        public void setOriginalSize(int size) {
            this.originalSize_d = size;
        }

        public int getOriginalSize() {
            return this.originalSize_d;
        }

        public String getURI() {
            return this.uri_d;
        }

        public void incrementInvocationTimes() {
            ++this.invocationTimes_d;
        }

        public String toString() {
            return "URI: (" + this.uri_d + ") - Original Size: (" + this.originalSize_d + ") - Compressed Size: (" + this.compressedSize_d + ") -  Compression Ratio: (" + this.compressionRatio() + ") %";
        }

        public void updateTimesWithCurrentInvocation(long time) {
            this.totalTimeInvocations_d += time;
            if (this.minTime_d == 0L || time < this.minTime_d) {
                this.minTime_d = time;
            }
            if (time > this.maxTime_d) {
                this.maxTime_d = time;
            }
            this.averageTime_d = this.totalTimeInvocations_d / (long)this.invocationTimes_d;
        }

        private int compressionRatio() {
            if (this.compressedSize_d == 0) {
                return 0;
            }
            return this.originalSize_d * 100 / this.compressedSize_d;
        }
    }
}

