/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.File;
import java.io.FileInputStream;

public class HexString {
    static final int CHUNKSIZE = 16;
    static final char[] hexChars = "0123456789ABCDEF".toCharArray();

    HexString() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage : HexString <file>");
            System.exit(1);
        }
        File file = new File(args[0]);
        try {
            int len = (int)file.length();
            byte[] b = new byte[len];
            FileInputStream fis = new FileInputStream(file);
            fis.read(b);
            String str = HexString.dump(b);
            System.out.println(str);
        }
        catch (Exception e1) {
            System.out.println("Exception dumping file " + args[0]);
            e1.printStackTrace();
            System.exit(1);
        }
    }

    public static String dump(byte[] data) {
        return HexString.dump(data, 0, data.length);
    }

    public static String dump(byte[] data, int length) {
        return HexString.dump(data, 0, length);
    }

    public static String dump(byte[] data, int offset, int length) {
        int len;
        StringBuffer sb = new StringBuffer();
        for (int pos = 0; pos < length; pos += len) {
            len = length - pos < 16 ? length - pos : 16;
            HexString.dumpLine(data, offset + pos, len, sb);
        }
        return sb.toString();
    }

    public static void dumpLine(byte[] data, int offset, int length, StringBuffer sb) {
        for (int i = 0; i < 16; ++i) {
            if (i < length) {
                HexString.hexify(data[offset + i], sb);
                sb.append(" ");
            } else {
                sb.append("   ");
            }
            if (i != 7) continue;
            sb.append("  ");
        }
        sb.append("; ");
        char[] c = new char[length];
        for (int j = 0; j < length; ++j) {
            c[j] = HexString.printable(data[offset + j]);
        }
        sb.append(c, 0, length);
        sb.append("\n");
    }

    public static String hexify(int val) {
        StringBuffer sb = new StringBuffer();
        HexString.hexify(val, sb);
        return sb.toString();
    }

    public static void hexify(int val, StringBuffer sb) {
        sb.append(hexChars[val / 16 & 0xF]);
        sb.append(hexChars[val & 0xF]);
    }

    private static char printable(byte c) {
        if (c > 32 && c < 128) {
            return (char)c;
        }
        return '.';
    }
}

