/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import oracle.bpm.web.filter.compression.CompressionResponseStream;

public class CompressionResponseWrapper
extends HttpServletResponseWrapper {
    protected int bufferSize = 0;
    protected String contentType = null;
    protected HttpServletResponse originalResponse = null;
    protected ServletOutputStream servletOutputStream = null;
    protected PrintWriter theWriter = null;
    protected String uri_d = null;
    private FilterConfig config = null;
    private int debugLevel = 0;
    protected static final String info = "CompressionServletResponseWrapper";

    public CompressionResponseWrapper(HttpServletResponse response, String uri, FilterConfig filterConfig) {
        super(response);
        this.originalResponse = response;
        this.uri_d = uri;
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": CompressionServletResponseWrapper constructor gets called");
        }
        this.config = filterConfig;
    }

    public void setCompressionBufferSize(int bufferSize) {
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": setCompressionBufferSize to " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public void setContentLength(int i) {
    }

    public void setContentType(String type) {
        this.contentType = type;
        this.originalResponse.setContentType(type);
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": setting ContentType to " + this.contentType);
        }
    }

    public void addHeader(String header, String value) {
        this.originalResponse.addHeader(header, value);
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": adding Header  [" + header + " : " + value + "]");
        }
    }

    public void setHeader(String header, String value) {
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": setting Header  [" + header + " : " + value + "]");
        }
        this.originalResponse.setHeader(header, value);
    }

    public void setDebugLevel(int debug) {
        this.debugLevel = debug;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.theWriter != null) {
            throw new IllegalStateException("The method getWriter has already been called!");
        }
        if (this.servletOutputStream == null) {
            this.servletOutputStream = this.buildOutputStream();
        }
        if (this.debugLevel > 4) {
            StringBuffer debug = new StringBuffer();
            debug.append(Thread.currentThread());
            debug.append(" : The stream is set to ");
            debug.append(this.servletOutputStream);
            debug.append(" in getOutputStream()");
            System.err.println(debug.toString());
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.theWriter != null) {
            return this.theWriter;
        }
        if (this.servletOutputStream != null) {
            throw new IllegalStateException("The method getOutputStream has already been called!");
        }
        this.servletOutputStream = this.buildOutputStream();
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": The stream is set to " + this.servletOutputStream + " in getWriter");
        }
        this.theWriter = this.buildWriter();
        return this.theWriter;
    }

    public void finishResponse() {
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": finishingResponse@ CompressionServletResponseWrapper");
        }
        try {
            if (this.theWriter != null) {
                if (this.debugLevel > 2) {
                    System.err.println(Thread.currentThread() + ": Closing writer @ finishingResponse@ CompressionServletResponseWrapper");
                }
                this.theWriter.close();
                this.theWriter = null;
                this.servletOutputStream = null;
            } else if (this.servletOutputStream != null) {
                this.servletOutputStream.close();
                this.servletOutputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": flush buffer @ CompressionServletResponseWrapper");
        }
        if (this.servletOutputStream != null && !((CompressionResponseStream)this.servletOutputStream).closed()) {
            if (this.debugLevel > 3) {
                System.err.println(Thread.currentThread() + ": flushing writer or stream  buffer @ CompressionServletResponseWrapper");
            }
            if (this.theWriter != null) {
                this.theWriter.flush();
            } else {
                this.servletOutputStream.flush();
            }
        }
    }

    private PrintWriter buildWriter() throws UnsupportedEncodingException {
        String charEncoding = this.originalResponse.getCharacterEncoding();
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": The char encoding is " + charEncoding);
        }
        PrintWriter theWriter = charEncoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.servletOutputStream, charEncoding)) : new PrintWriter((OutputStream)this.servletOutputStream);
        return theWriter;
    }

    private ServletOutputStream buildOutputStream() throws IOException {
        CompressionResponseStream compressionStream = new CompressionResponseStream(this.originalResponse, this.uri_d, this.config);
        compressionStream.setDebugLevel(this.debugLevel);
        compressionStream.setBuffer(this.bufferSize);
        if (this.debugLevel > 2) {
            System.err.println(Thread.currentThread() + ": building OutputStream");
        }
        return compressionStream;
    }
}

