/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.FilterConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.web.filter.compression.CounterStream;
import oracle.bpm.web.filter.compression.HexString;
import oracle.bpm.web.filter.compression.SnifferOutputStream;

public class CompressionResponseStream
extends ServletOutputStream {
    protected byte[] buffer = null;
    protected int bufferCount = 0;
    protected int bufferSize = 0;
    protected boolean closed = false;
    protected int length = -1;
    protected ServletOutputStream originalStream = null;
    protected OutputStream outputStream = null;
    protected HttpServletResponse response = null;
    protected String uri_d = null;
    private int debug = 0;
    private boolean doZip = true;

    public CompressionResponseStream(HttpServletResponse response, String uri, FilterConfig filterConfig) throws IOException {
        this.response = response;
        this.originalStream = response.getOutputStream();
        this.uri_d = uri;
    }

    public void setDebugLevel(int debug) {
        this.debug = debug;
    }

    public void close() throws IOException {
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": close() @ CompressionResponseStream" + (Object)((Object)this));
        }
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this.outputStream != null) {
            this.flushToOutput();
            this.outputStream.close();
            this.outputStream = null;
        } else if (this.bufferCount > 0) {
            if (this.debug > 5) {
                System.err.println(Thread.currentThread() + ": output.write (at close) (\n" + HexString.dump(this.buffer, this.bufferCount) + ")");
            }
            this.originalStream.write(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
        this.originalStream.close();
        this.closed = true;
    }

    public boolean closed() {
        return this.closed;
    }

    public void flush() throws IOException {
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": flush() @ CompressionResponseStream" + (Object)((Object)this));
        }
        if (this.closed) {
            System.err.println(Thread.currentThread() + ": Exception at " + (Object)((Object)this) + " Th: " + Thread.currentThread());
            throw new IOException("CompressionResponseStream: Cannot flush a closed output stream");
        }
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public void write(int b) throws IOException {
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": write " + b + " in CompressionResponseStream ");
        }
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushToOutput();
        }
        this.buffer[this.bufferCount++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": write, bufferCount = " + this.bufferCount + " len = " + len + " off = " + off);
        }
        if (this.debug > 9) {
            System.err.println(Thread.currentThread() + ": write(\n" + HexString.dump(b, off, len) + ")");
        }
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (len == 0) {
            return;
        }
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.flushToOutput();
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.writeToOutput(b, off, len);
    }

    protected void setBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": buffer is set to " + bufferSize);
        }
    }

    private void flushToOutput() throws IOException {
        if (this.bufferCount > 0) {
            if (this.debug > 2) {
                System.err.println(Thread.currentThread() + ": flushing out to outputStream, bufferCount = " + this.bufferCount);
            }
            this.writeToOutput(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
    }

    private void writeToOutput(byte[] b, int off, int len) throws IOException {
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": writeToOutput, len = " + len);
        }
        if (this.debug > 7) {
            System.err.println(Thread.currentThread() + ": writeToOutput(\n" + HexString.dump(b, off, len) + ")");
        }
        if (this.outputStream == null && this.doZip) {
            CounterStream cs = new CounterStream();
            GZIPOutputStream testGz = new GZIPOutputStream((OutputStream)((Object)cs));
            testGz.write(b, off, len);
            testGz.close();
            int count = cs.getCount();
            cs.close();
            if (this.debug > 2) {
                System.err.println(Thread.currentThread() + ": len = " + len + ", compressed len = " + count);
            }
            if (this.debug > 1) {
                System.err.println(Thread.currentThread() + ": Compressing: Creating gzip stream");
            }
            this.outputStream = new GZIPOutputStream((OutputStream)((Object)new SnifferOutputStream(this.originalStream, this.debug, this.uri_d, true)));
        }
        assert (this.outputStream != null) : "outstream cannot be null";
        this.outputStream.write(b, off, len);
    }
}

