/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.web.filter.compression.CompressionResponseWrapper;
import oracle.bpm.web.filter.compression.RequestTable;

public class CompressionFilter
implements Filter {
    private int compressionThreshold = 0;
    private FilterConfig config = null;
    private int debug = 0;
    private boolean enableStatistics = false;
    private Pattern excludePattern;
    private String excludePatternParam;
    private int minThreshold = 128;

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }

    public void destroy() {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.debug > 2) {
            System.err.println(Thread.currentThread() + ": @doFilter");
        }
        if (this.isCompressionAllowed(request) && request instanceof HttpServletRequest) {
            long startTime = 0L;
            if (this.debug > 0) {
                startTime = System.currentTimeMillis();
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (this.debug > 1) {
                System.err.println(Thread.currentThread() + ": requestURI = " + httpServletRequest.getRequestURI());
            }
            String uri = httpServletRequest.getRequestURI();
            if (this.isGzip(httpServletRequest)) {
                if (this.debug > 0) {
                    System.err.println(Thread.currentThread() + ": CompressionFilter: Filtering URI: '" + uri + "'");
                }
                httpServletResponse.addHeader("Content-Encoding", "gzip");
                CompressionResponseWrapper wrappedResponse = new CompressionResponseWrapper(httpServletResponse, this.enableStatistics ? uri : null, this.config);
                wrappedResponse.setDebugLevel(this.debug);
                wrappedResponse.setCompressionBufferSize(this.compressionThreshold);
                if (this.debug > 1) {
                    System.err.println(Thread.currentThread() + ": doFilter gets called with compression");
                }
                try {
                    chain.doFilter(request, (ServletResponse)wrappedResponse);
                }
                finally {
                    wrappedResponse.finishResponse();
                }
                if (this.enableStatistics) {
                    RequestTable.setInvocationTimesForURI(uri);
                    RequestTable.updateTimesWithCurrentInvocationURI(uri, System.currentTimeMillis() - startTime);
                }
            } else {
                if (this.debug > 0) {
                    System.err.println(Thread.currentThread() + ": CompressionFilter: NOT Filtering URI: '" + uri + "'");
                }
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        if (filterConfig != null) {
            String str;
            String excludeSuffixStr = filterConfig.getInitParameter("excludePattern");
            this.excludePattern = Pattern.compile(excludeSuffixStr);
            this.excludePatternParam = filterConfig.getInitParameter("excludePatternParam");
            String value = filterConfig.getInitParameter("debug");
            if (value != null) {
                this.debug = value.toLowerCase().equals("true") ? 1 : Integer.parseInt(value);
                System.err.println(Thread.currentThread() + ": CompressionFilter: Using debug = (" + this.debug + ")");
            } else {
                this.debug = 0;
            }
            value = filterConfig.getInitParameter("enableStatistics");
            if (value != null) {
                if (value.toLowerCase().equals("true")) {
                    this.enableStatistics = true;
                }
                if (this.debug > 0) {
                    System.err.println(Thread.currentThread() + ": CompressionFilter:" + (this.enableStatistics ? "" : " NOT") + " Using enableStatistics");
                }
            }
            if ((str = filterConfig.getInitParameter("compressionThreshold")) != null) {
                this.compressionThreshold = Integer.parseInt(str);
                if (this.compressionThreshold != 0 && this.compressionThreshold < this.minThreshold) {
                    if (this.debug > 0) {
                        System.err.println(Thread.currentThread() + ": compressionThreshold should be either 0 - no compression or >= " + this.minThreshold);
                        System.err.println(Thread.currentThread() + ": compressionThreshold set to " + this.minThreshold);
                    }
                    this.compressionThreshold = this.minThreshold;
                }
            } else {
                this.compressionThreshold = 0;
            }
        } else {
            this.compressionThreshold = 0;
        }
    }

    private boolean isCompressionAllowed(ServletRequest request) {
        boolean result;
        if (this.compressionThreshold == 0) {
            if (this.debug > 1) {
                System.err.println(Thread.currentThread() + ": doFilter gets called, but compressionTreshold is set to 0 - no compression");
            }
            result = false;
        } else if ("false".equals(request.getParameter("gzip"))) {
            if (this.debug > 3) {
                System.err.println(Thread.currentThread() + ":got parameter gzip=false --> don't compress, just chain filter");
            }
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    private boolean isGzip(HttpServletRequest httpServletRequest) {
        boolean result;
        String encodings = httpServletRequest.getHeader("Accept-Encoding");
        if (encodings == null) {
            result = false;
        } else {
            String uri;
            boolean bl = result = encodings.indexOf("gzip") >= 0;
            if (result && (uri = httpServletRequest.getRequestURI()) != null && this.excludePattern != null) {
                String param;
                if (this.excludePattern.matcher(uri).matches()) {
                    result = false;
                } else if (this.excludePatternParam != null && (param = httpServletRequest.getParameter(this.excludePatternParam)) != null && this.excludePattern.matcher(param).matches()) {
                    result = false;
                }
            }
        }
        if (this.debug > 3) {
            if (result) {
                System.err.println(Thread.currentThread() + ": supports compression");
            } else {
                System.err.println(Thread.currentThread() + ":NO support for compresion");
            }
        }
        return result;
    }
}

