/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import oracle.bpm.web.filter.compression.ByteCounterResponseStream;

public class ByteCounterWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse = null;
    protected ServletOutputStream stream = null;
    protected int threshold = 1024;
    protected String uri_d = null;
    protected PrintWriter writer = null;

    public ByteCounterWrapper(HttpServletResponse response, String uri) {
        super(response);
        this.origResponse = response;
        this.uri_d = uri;
    }

    public void setCompressionThreshold(int threshold) {
        this.threshold = threshold;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        ((ByteCounterResponseStream)this.stream).setCommit(true);
        ((ByteCounterResponseStream)this.stream).setBuffer(this.threshold);
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        ((ByteCounterResponseStream)this.stream).setCommit(true);
        ((ByteCounterResponseStream)this.stream).setBuffer(this.threshold);
        this.writer = new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new ByteCounterResponseStream(this.origResponse, this.uri_d);
    }
}

