/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.web.filter.compression.RequestTable;

public class ByteCounterResponseStream
extends ServletOutputStream {
    protected byte[] buffer = null;
    protected int bufferCount = 0;
    protected boolean closed = false;
    protected boolean commit = false;
    protected int count = 0;
    protected int length = -1;
    protected ServletOutputStream output = null;
    protected HttpServletResponse response = null;
    protected int threshold = 0;
    protected boolean thresholdReached = false;
    protected String uri_d = null;

    public ByteCounterResponseStream(HttpServletResponse response, String uri) throws IOException {
        this.response = response;
        this.output = response.getOutputStream();
        this.uri_d = uri;
    }

    public void close() throws IOException {
        RequestTable.setOriginalSizeForURI(this.uri_d, this.count);
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this.output != null) {
            this.output.close();
        }
        this.flush();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (this.commit && this.bufferCount > 0) {
            this.output.write(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.bufferCount >= this.buffer.length || this.count >= this.threshold) {
            this.thresholdReached = true;
        }
        if (this.thresholdReached) {
            this.writeToStream(b);
        } else {
            this.buffer[this.bufferCount++] = (byte)b;
            ++this.count;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (len == 0) {
            return;
        }
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            this.count += len;
            return;
        }
        this.writeToStream(b, off, len);
        this.count += len;
    }

    public void writeToStream(int b) throws IOException {
        this.output.write(b);
    }

    public void writeToStream(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    protected void setBuffer(int threshold) {
        this.threshold = threshold;
        this.buffer = new byte[this.threshold];
    }

    void setCommit(boolean commit) {
        this.commit = commit;
    }

    boolean getCommit() {
        return this.commit;
    }

    boolean closed() {
        return this.closed;
    }

    void reset() {
        this.count = 0;
    }
}

