/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter.compression;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.web.filter.compression.ByteCounterWrapper;

public class ByteCounterFilter
implements Filter {
    private FilterConfig config = null;
    private boolean debug_d = false;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = "";
        if (request instanceof HttpServletRequest) {
            uri = ((HttpServletRequest)request).getRequestURI();
        }
        if (this.debug_d) {
            this.config.getServletContext().log("ByteCounterFilter: Filtering URI: '" + uri + "'");
        }
        if (response instanceof HttpServletResponse) {
            ByteCounterWrapper wrappedResponse = new ByteCounterWrapper((HttpServletResponse)response, uri);
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        if (filterConfig != null) {
            String str = filterConfig.getInitParameter("enabled");
            this.config.getServletContext().log("ByteCounterFilter.enabled: (" + str + ")");
            if (str != null && str.toLowerCase().equals("true")) {
                this.debug_d = true;
                this.config.getServletContext().log("WARNING: ByteCounterCompressionFilter is enabled !");
            } else {
                this.config.getServletContext().log("WARNING: ByteCounterCompressionFilter: Using ByteCounter filter NOT ENABLED can cause slow downs in the overall Container performance !!!");
            }
        }
    }
}

