/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.bpm.log.Log;
import oracle.bpm.web.filter.BaseFilter;

public class SingleThreadPerSessionFilter
extends BaseFilter {
    private static final String ATTR_SESSION_MUTEX = "sessionMutex";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        Lock mtx;
        HttpSession session;
        HttpSession httpSession = session = req.getSession(true);
        synchronized (httpSession) {
            mtx = (Lock)session.getAttribute(ATTR_SESSION_MUTEX);
            if (mtx == null) {
                mtx = new ReentrantLock();
                session.setAttribute(ATTR_SESSION_MUTEX, (Object)mtx);
            }
        }
        boolean locked = false;
        try {
            locked = mtx.tryLock(20L, TimeUnit.SECONDS);
            if (!locked) {
                this.logDebug("Failed to aquire lock in 20 seconds");
                return;
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logDebug("Locking operation has been interrupted");
            return;
        }
        finally {
            block19: {
                if (locked) {
                    try {
                        mtx.unlock();
                    }
                    catch (Throwable e) {
                        if (!Log.isDebugging()) break block19;
                        Log.logDebug((Throwable)e);
                    }
                }
            }
        }
    }
}

